/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.xml.schema;

import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ValueFilterType;
import com.evolveum.midpoint.xml.schema.ExpressionHolder;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValueAssignmentHolder {
    private Element dom;
    private ExpressionHolder source;
    private XPathType target;
    private List<ValueFilterType> filters;

    public ValueAssignmentHolder(Element dom) {
        this.dom = dom;
        this.source = null;
        this.target = null;
        this.filters = null;
    }

    public ExpressionHolder getSource() {
        if (this.source != null) {
            return this.source;
        }
        NodeList elements = this.dom.getElementsByTagNameNS(SchemaConstants.I_VALUE_ASSIGNMENT_SOURCE.getNamespaceURI(), SchemaConstants.I_VALUE_ASSIGNMENT_SOURCE.getLocalPart());
        if (elements.getLength() == 0) {
            return null;
        }
        if (elements.getLength() > 1) {
            throw new IllegalArgumentException("Value assignment has more than one elements <source>");
        }
        Element element = (Element)elements.item(0);
        this.source = new ExpressionHolder(element);
        return this.source;
    }

    public XPathType getTarget() {
        if (this.target != null) {
            return this.target;
        }
        NodeList elements = this.dom.getElementsByTagNameNS(SchemaConstants.I_VALUE_ASSIGNMENT_TARGET.getNamespaceURI(), SchemaConstants.I_VALUE_ASSIGNMENT_TARGET.getLocalPart());
        if (elements.getLength() == 0) {
            return null;
        }
        if (elements.getLength() > 1) {
            throw new IllegalArgumentException("Value assignment has more than one elements <target>");
        }
        Element element = (Element)elements.item(0);
        this.target = new XPathType(element);
        return this.target;
    }

    public List<ValueFilterType> getFilter() {
        if (this.filters != null) {
            return this.filters;
        }
        NodeList elements = this.dom.getElementsByTagNameNS(SchemaConstants.I_VALUE_ASSIGNMENT_FILTER.getNamespaceURI(), SchemaConstants.I_VALUE_ASSIGNMENT_FILTER.getLocalPart());
        if (elements.getLength() == 0) {
            return null;
        }
        try {
            JAXBContext jctx = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jctx.createUnmarshaller();
            ArrayList<ValueFilterType> newFilters = new ArrayList<ValueFilterType>();
            for (int i = 0; i < elements.getLength(); ++i) {
                Element element = (Element)elements.item(i);
                Object object = unmarshaller.unmarshal((Node)element);
                if (object instanceof JAXBElement) {
                    JAXBElement jaxbElement = (JAXBElement)object;
                    object = jaxbElement.getValue();
                }
                if (!(object instanceof ValueFilterType)) {
                    throw new IllegalArgumentException("Filter is not ValueFilterType, it is " + object.getClass().getName());
                }
                newFilters.add((ValueFilterType)object);
            }
            this.filters = newFilters;
            return this.filters;
        }
        catch (JAXBException ex) {
            throw new IllegalStateException("Cannot create unmarshaller");
        }
    }
}

