/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.xml.schema;

import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.GenericObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceStateType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserTemplateType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;

public abstract class SchemaConstants {
    private static final CatalogResolver catalogResolver;
    private static boolean resolverInitialized;
    public static final String NS_C = "http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd";
    public static final String NS_IDENTITY = "http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd";
    public static final String NS_RESOURCE = "http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd";
    public static final String NS_ICF_RESOURCE = "http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd";
    public static final String NS_ICF_CONFIGURATION = "http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/configuration-1.xsd";
    public static final String NS_FILTER = "http://midpoint.evolveum.com/xml/ns/public/common/value-filter-1.xsd";
    public static final QName C_NAME;
    public static final QName C_GENERIC_OBJECT;
    public static final QName C_ACCESS;
    public static final QName C_RAC_REF;
    public static final QName C_FILTER_TYPE;
    public static final QName C_FILTER_TYPE_URI;
    public static final QName C_FILTER_EQUAL;
    public static final QName C_FILTER_PATH;
    public static final QName C_FILTER_VALUE;
    public static final QName C_FILTER_AND;
    public static final QName C_OBJECT;
    public static final QName I_OBJECTS;
    public static final QName I_RESOURCE;
    public static final QName I_RESOURCE_STATE;
    public static final QName I_TYPE;
    public static final QName I_SCHEMA_HANDLING;
    public static final QName I_USER_TYPE;
    public static final QName I_USER;
    public static final QName I_USER_TEMPLATE_TYPE;
    public static final QName I_GENERIC_OBJECT_TYPE;
    public static final QName I_USER_TEMPLATE;
    public static final QName I_ACCOUNT_TYPE;
    public static final QName I_ACCOUNT_SHADOW_TYPE;
    public static final QName I_RESOURCE_TYPE;
    public static final QName I_SCHEMA;
    public static final QName I_ACCOUNT;
    public static final QName I_RESOURCE_OBJECT_SHADOW;
    public static final QName I_OBJECT_CLASS;
    public static final QName I_OBJECT;
    public static final QName I_ACCOUNT_REF;
    public static final QName I_RESOURCE_REF;
    public static final QName I_ATTRIBUTES;
    public static final QName I_PROPERTY_CONTAINER_REFERENCE_PATH;
    public static final QName I_FILTER_TYPE;
    public static final QName I_RESOURCE_STATE_TYPE;
    public static final QName I_VALUE_ASSIGNMENT_SOURCE;
    public static final QName I_VALUE_ASSIGNMENT_TARGET;
    public static final QName I_VALUE_ASSIGNMENT_FILTER;
    public static final QName I_SYNCHRONIZATION_TYPE;
    public static final QName I_SYNCHRONIZATION;
    public static final QName I_SCRIPTS_TYPE;
    public static final QName I_SCRIPTS;
    public static final QName I_CREDENTIALS_TYPE;
    public static final QName I_CREDENTIALS;
    public static final QName I_PASSWORD;
    public static final QName X_ANNOTATION;
    public static final QName X_APPINFO;
    public static final QName X_SCHEMA;
    public static final QName X_DOCUMENTATION;
    public static final QName I_DIAGNOSTICS_MESSAGE_ERROR;
    public static final QName I_DIAGNOSTICS_MESSAGE_WARNING;
    private static Map<Class, QName> objectTypeElementMap;
    public static final String NS_CHANNEL = "http://midpoint.evolveum.com/xml/ns/public/provisioning/channels-1";
    public static final QName CHANGE_CHANNEL_SYNC;
    public static final QName CHANGE_CHANNEL_RECON;
    public static final QName CHANGE_CHANNEL_DISCOVERY;
    public static final QName CHANGE_CHANNEL_IMPORT;
    public static final String NS_SITUATION = "http://midpoint.evolveum.com/xml/ns/public/model/situation-1.xsd";

    public static void initObjectTypeElementMap() {
        objectTypeElementMap = new HashMap<Class, QName>();
        objectTypeElementMap.put(UserType.class, I_USER);
        objectTypeElementMap.put(GenericObjectType.class, C_GENERIC_OBJECT);
        objectTypeElementMap.put(UserTemplateType.class, I_USER_TEMPLATE);
        objectTypeElementMap.put(ResourceType.class, I_RESOURCE);
        objectTypeElementMap.put(ResourceStateType.class, I_RESOURCE_STATE);
        objectTypeElementMap.put(AccountShadowType.class, I_ACCOUNT);
    }

    public static QName getElementByObjectType(Class clazz) {
        QName qname = objectTypeElementMap.get(clazz);
        if (qname != null) {
            return qname;
        }
        return C_OBJECT;
    }

    public static CatalogResolver getEntityResolver() {
        if (!resolverInitialized) {
            SchemaConstants.initResolver(catalogResolver.getCatalog());
        }
        return catalogResolver;
    }

    private static void initResolver(Catalog resolver) {
        try {
            Enumeration<URL> catalogs = Thread.currentThread().getContextClassLoader().getResources("META-INF/wsdl/catalog.xml");
            while (catalogs.hasMoreElements()) {
                URL catalogURL = catalogs.nextElement();
                System.out.println(catalogURL);
                resolver.parseCatalog(catalogURL);
            }
            resolverInitialized = true;
        }
        catch (IOException ex) {
            resolverInitialized = false;
            ex.printStackTrace();
        }
    }

    static {
        resolverInitialized = false;
        C_NAME = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "name");
        C_GENERIC_OBJECT = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "genericObject");
        C_ACCESS = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "access");
        C_RAC_REF = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "ResourceAccessConfigurationReferenceType");
        C_FILTER_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "type");
        C_FILTER_TYPE_URI = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "uri");
        C_FILTER_EQUAL = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "equal");
        C_FILTER_PATH = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "path");
        C_FILTER_VALUE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "value");
        C_FILTER_AND = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "and");
        C_OBJECT = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "object");
        I_OBJECTS = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "objects");
        I_RESOURCE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "resource");
        I_RESOURCE_STATE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "resourceState");
        I_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "type");
        I_SCHEMA_HANDLING = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "schemaHandling");
        I_USER_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "UserType");
        I_USER = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "user");
        I_USER_TEMPLATE_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "UserTemplateType");
        I_GENERIC_OBJECT_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "GenericObjectType");
        I_USER_TEMPLATE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "userTemplate");
        I_ACCOUNT_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "AccountType");
        I_ACCOUNT_SHADOW_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "AccountShadowType");
        I_RESOURCE_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "ResourceType");
        I_SCHEMA = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "schema");
        I_ACCOUNT = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "account");
        I_RESOURCE_OBJECT_SHADOW = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "resourceObjectShadow");
        I_OBJECT_CLASS = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "objectClass");
        I_OBJECT = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "object");
        I_ACCOUNT_REF = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "accountRef");
        I_RESOURCE_REF = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "resourceRef");
        I_ATTRIBUTES = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "attributes");
        I_PROPERTY_CONTAINER_REFERENCE_PATH = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "path");
        I_FILTER_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "FilterType");
        I_RESOURCE_STATE_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "ResourceStateType");
        I_VALUE_ASSIGNMENT_SOURCE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "source");
        I_VALUE_ASSIGNMENT_TARGET = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "target");
        I_VALUE_ASSIGNMENT_FILTER = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "valueFilter");
        I_SYNCHRONIZATION_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "SynchronizationType");
        I_SYNCHRONIZATION = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "synchronization");
        I_SCRIPTS_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "ScriptsType");
        I_SCRIPTS = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "scripts");
        I_CREDENTIALS_TYPE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "CredentialsType");
        I_CREDENTIALS = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "credentials");
        I_PASSWORD = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "password");
        X_ANNOTATION = new QName("http://www.w3.org/2001/XMLSchema", "annotation");
        X_APPINFO = new QName("http://www.w3.org/2001/XMLSchema", "appinfo");
        X_SCHEMA = new QName("http://www.w3.org/2001/XMLSchema", "schema");
        X_DOCUMENTATION = new QName("http://www.w3.org/2001/XMLSchema", "documentation");
        I_DIAGNOSTICS_MESSAGE_ERROR = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "error");
        I_DIAGNOSTICS_MESSAGE_WARNING = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "error");
        CHANGE_CHANNEL_SYNC = new QName(NS_CHANNEL, "synchronization");
        CHANGE_CHANNEL_RECON = new QName(NS_CHANNEL, "reconciliation");
        CHANGE_CHANNEL_DISCOVERY = new QName(NS_CHANNEL, "discovery");
        CHANGE_CHANNEL_IMPORT = new QName(NS_CHANNEL, "import");
        SchemaConstants.initObjectTypeElementMap();
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setUseStaticCatalog(true);
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setVerbosity(1);
        catalogManager.setPreferPublic(true);
        catalogResolver = new CatalogResolver(catalogManager);
        Catalog resolver = catalogResolver.getCatalog();
        SchemaConstants.initResolver(resolver);
    }
}

