/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.xml.schema;

import com.evolveum.midpoint.xml.schema.TrivialXPathParser;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExpressionHolder {
    private Element dom;
    public static final String LANGUAGE_XPATH_1 = "http://www.w3.org/TR/xpath/";
    public static final String DEFAULT_LANGUAGE = "http://www.w3.org/TR/xpath/";

    public ExpressionHolder(Element domElement) {
        this.dom = domElement;
    }

    public String getLanguage() {
        String language = this.dom.getAttributeNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "language");
        if (language == null || language.isEmpty()) {
            return "http://www.w3.org/TR/xpath/";
        }
        return language;
    }

    public QName getRef() {
        QName qname;
        String refString = this.dom.getAttributeNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "ref");
        String[] qnameArray = refString.split(":");
        if (qnameArray.length > 2) {
            throw new IllegalStateException("Unsupported format: more than one colon in QName segment (ref): " + refString);
        }
        if (qnameArray.length == 1 || qnameArray[1] == null || qnameArray[1].isEmpty()) {
            String namespace = this.lookupNamespaceUri(null);
            qname = new QName(namespace, qnameArray[0]);
        } else {
            String namespace = this.lookupNamespaceUri(qnameArray[0]);
            qname = new QName(namespace, qnameArray[1], qnameArray[0]);
        }
        return qname;
    }

    public NodeList getExpression() {
        return this.dom.getChildNodes();
    }

    public String getFullExpressionAsString() {
        NodeList childNodes = this.dom.getChildNodes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 3 || childNode.getNodeType() == 4) {
                sb.append(childNode.getNodeValue());
                continue;
            }
            if (childNode.getNodeType() != 8) continue;
        }
        return sb.toString();
    }

    public String getExpressionAsString() {
        String stringExpression = this.getFullExpressionAsString();
        if (this.getLanguage().equals("http://www.w3.org/TR/xpath/")) {
            TrivialXPathParser parser = TrivialXPathParser.parse(stringExpression);
            stringExpression = parser.getPureXPathString();
        }
        return stringExpression;
    }

    public String lookupNamespaceUri(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this.dom.lookupNamespaceURI(null);
        }
        return this.dom.lookupNamespaceURI(prefix);
    }

    public Map<String, String> getNamespaceMap() {
        HashMap<String, String> namespaceMap = null;
        String stringExpression = this.getFullExpressionAsString();
        if (this.getLanguage().equals("http://www.w3.org/TR/xpath/")) {
            TrivialXPathParser parser = TrivialXPathParser.parse(stringExpression);
            namespaceMap = parser.getNamespaceMap();
        } else {
            namespaceMap = new HashMap();
        }
        for (Node node = this.dom; node != null; node = node.getParentNode()) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes == null) continue;
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (attribute.getNamespaceURI() == null || !attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                String localName = attribute.getLocalName();
                if (attribute.getPrefix() == null && localName.equals("xmlns")) {
                    if (namespaceMap.get("") != null) continue;
                    namespaceMap.put("", attribute.getNodeValue());
                    continue;
                }
                if (namespaceMap.get(localName) != null) continue;
                namespaceMap.put(localName, attribute.getNodeValue());
            }
        }
        return namespaceMap;
    }
}

