/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.processor;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.schema.processor.Definition;
import com.evolveum.midpoint.schema.processor.ProcessorConstants;
import com.evolveum.midpoint.schema.processor.PropertyContainerDefinition;
import com.evolveum.midpoint.schema.processor.PropertyDefinition;
import com.evolveum.midpoint.schema.processor.ResourceObjectAttributeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceObjectDefinition;
import com.evolveum.midpoint.schema.processor.Schema;
import com.evolveum.midpoint.schema.processor.SchemaProcessorException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SchemaToDomProcessor {
    private static final Trace TRACE = TraceManager.getTrace(SchemaToDomProcessor.class);
    public static final String RESOURCE_OBJECT_CLASS = "ResourceObjectClass";
    private static final String MAX_OCCURS_UNBOUNDED = "unbounded";
    private Map<String, String> prefixMap = null;
    private boolean attributeQualified = false;

    SchemaToDomProcessor() {
        this(null);
    }

    SchemaToDomProcessor(Map<String, String> prefixMap) {
        this.prefixMap = prefixMap;
    }

    void setAttributeQualified(boolean attributeQualified) {
        this.attributeQualified = attributeQualified;
    }

    Document parseSchema(Schema schema) throws SchemaProcessorException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema can't be null.");
        }
        Document document = null;
        try {
            document = this.init(schema);
            Set<Definition> definitions = schema.getDefinitions();
            for (Definition definition : definitions) {
                if (definition instanceof ResourceObjectDefinition) {
                    this.addPropertyContainerDefinition(schema, (ResourceObjectDefinition)definition, document.getDocumentElement());
                    continue;
                }
                if (!(definition instanceof PropertyDefinition)) continue;
                this.addPropertyDefinition(schema, (PropertyDefinition)definition, document.getDocumentElement());
            }
            Set<String> usedNamespaces = this.updatePrefixes(document);
            this.addNamespaces(document.getDocumentElement(), usedNamespaces);
        }
        catch (Exception ex) {
            throw new SchemaProcessorException("Couldn't parse schema, reason: " + ex.getMessage(), ex);
        }
        return document;
    }

    private void addPropertyContainerDefinition(Schema schema, ResourceObjectDefinition definition, Element parent) {
        Document document = parent.getOwnerDocument();
        Element container = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.setAttribute(container, "name", definition.getName().getLocalPart());
        Element annotation = this.createPropertyContainerAnnotation(definition, document);
        if (annotation != null) {
            container.appendChild(annotation);
        }
        Element complexContent = document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
        container.appendChild(complexContent);
        Element extension = document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
        this.setAttribute(extension, "base", this.prefixMap.get("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd") + ":" + RESOURCE_OBJECT_CLASS);
        extension.setAttribute("xmlns:" + this.prefixMap.get("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd"), "http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd");
        complexContent.appendChild(extension);
        Element sequence = document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        extension.appendChild(sequence);
        Set<PropertyDefinition> definitions = definition.getDefinitions();
        for (PropertyDefinition propertyDefinition : definitions) {
            this.addPropertyDefinition(schema, propertyDefinition, sequence);
        }
        parent.appendChild(container);
    }

    private void addPropertyDefinition(Schema schema, PropertyDefinition definition, Element parent) {
        Element annotation;
        Element property = parent.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        String attrNamespace = definition.getName().getNamespaceURI();
        if (attrNamespace != null && attrNamespace.equals(schema.getNamespace())) {
            this.setAttribute(property, "name", definition.getName().getLocalPart());
            this.setAttribute(property, "type", this.createPrefixedValue(definition.getTypeName()));
        } else {
            this.setAttribute(property, "ref", this.createPrefixedValue(definition.getName()));
        }
        if (definition.getMinOccurs() != 1) {
            this.setAttribute(property, "minOccurs", Integer.toString(definition.getMinOccurs()));
        }
        if (definition.getMaxOccurs() != 1) {
            String maxOccurs = definition.getMaxOccurs() == -1 ? MAX_OCCURS_UNBOUNDED : Integer.toString(definition.getMaxOccurs());
            this.setAttribute(property, "maxOccurs", maxOccurs);
        }
        if ((annotation = this.createPropertyAnnotation(definition, parent.getOwnerDocument())) != null) {
            property.appendChild(annotation);
        }
        parent.appendChild(property);
    }

    private Element createPropertyContainerAnnotation(ResourceObjectDefinition definition, Document document) {
        Element annotation = document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        Element appinfo = document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
        annotation.appendChild(appinfo);
        for (ResourceObjectAttributeDefinition identifier : definition.getIdentifiers()) {
            appinfo.appendChild(this.createRefAnnotation(ProcessorConstants.A_IDENTIFIER, this.createPrefixedValue(identifier.getName()), document));
        }
        for (ResourceObjectAttributeDefinition identifier : definition.getSecondaryIdentifiers()) {
            appinfo.appendChild(this.createRefAnnotation(ProcessorConstants.A_SECONDARY_IDENTIFIER, this.createPrefixedValue(identifier.getName()), document));
        }
        if (definition.getDisplayNameAttribute() != null) {
            appinfo.appendChild(this.createRefAnnotation(ProcessorConstants.A_DISPLAY_NAME, this.createPrefixedValue(definition.getDisplayNameAttribute().getName()), document));
        }
        if (definition.getDescriptionAttribute() != null) {
            appinfo.appendChild(this.createRefAnnotation(ProcessorConstants.A_DESCRIPTION_ATTRIBUTE, this.createPrefixedValue(definition.getDescriptionAttribute().getName()), document));
        }
        if (!StringUtils.isEmpty((String)definition.getNativeObjectClass())) {
            appinfo.appendChild(this.createAnnotation(ProcessorConstants.A_NATIVE_OBJECT_CLASS, definition.getNativeObjectClass(), document));
        }
        if (definition.isAccountType()) {
            Element accountTypeAnnotation = this.createAnnotation(ProcessorConstants.A_ACCOUNT_TYPE, null, document);
            if (definition.isDefaultAccountType()) {
                this.setAttribute(accountTypeAnnotation, ProcessorConstants.A_ATTR_DEFAULT, "true");
            }
            appinfo.appendChild(accountTypeAnnotation);
        }
        if (!appinfo.hasChildNodes()) {
            return null;
        }
        return annotation;
    }

    private Element createPropertyAnnotation(PropertyDefinition definition, Document document) {
        ResourceObjectAttributeDefinition attrDefinition;
        Element appinfo = document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
        if (!StringUtils.isEmpty((String)definition.getDisplayName())) {
            appinfo.appendChild(this.createAnnotation(ProcessorConstants.A_ATTRIBUTE_DISPLAY_NAME, definition.getDisplayName(), document));
        }
        if (!StringUtils.isEmpty((String)definition.getHelp())) {
            appinfo.appendChild(this.createAnnotation(ProcessorConstants.A_HELP, definition.getHelp(), document));
        }
        if (definition instanceof ResourceObjectAttributeDefinition && !StringUtils.isEmpty((String)(attrDefinition = (ResourceObjectAttributeDefinition)definition).getNativeAttributeName())) {
            appinfo.appendChild(this.createAnnotation(ProcessorConstants.A_NATIVE_ATTRIBUTE_NAME, attrDefinition.getNativeAttributeName(), document));
        }
        Element annotation = document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        if (!appinfo.hasChildNodes()) {
            return null;
        }
        annotation.appendChild(appinfo);
        return annotation;
    }

    private Element createAnnotation(QName qname, String value, Document document) {
        Element annotation = document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        annotation.setTextContent(value);
        return annotation;
    }

    private Element createRefAnnotation(QName qname, String value, Document document) {
        Element access = document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        this.setAttribute(access, new QName("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd", "ref"), value);
        return access;
    }

    private String createPrefixedValue(QName name) {
        StringBuilder builder = new StringBuilder();
        String prefix = this.prefixMap.get(name.getNamespaceURI());
        if (prefix != null) {
            builder.append(prefix);
            builder.append(":");
        }
        builder.append(name.getLocalPart());
        return builder.toString();
    }

    private Document init(Schema schema) throws ParserConfigurationException {
        Document document = this.createSchemaDocument(schema.getNamespace());
        if (this.prefixMap == null) {
            this.prefixMap = new HashMap<String, String>();
        }
        if (!this.prefixMap.containsKey("http://www.w3.org/2001/XMLSchema")) {
            this.prefixMap.put("http://www.w3.org/2001/XMLSchema", "xsd");
        }
        if (!this.prefixMap.containsKey("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd")) {
            this.prefixMap.put("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "c");
            document.getDocumentElement().appendChild(this.createImport(document, "http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd"));
        }
        if (!this.prefixMap.containsKey("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd")) {
            this.prefixMap.put("http://midpoint.evolveum.com/xml/ns/public/resource/resource-schema-1.xsd", "r");
        }
        if (!this.prefixMap.containsKey("http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd")) {
            this.prefixMap.put("http://midpoint.evolveum.com/xml/ns/public/resource/idconnector/resource-schema-1.xsd", "ids");
        }
        this.prefixMap.put(schema.getNamespace(), "tns");
        int index = 0;
        Set<Definition> definitions = schema.getDefinitions();
        HashSet<String> alreadyImportedNamespaces = new HashSet<String>();
        for (Definition definition : definitions) {
            index += this.addImportFromDefinition(definition, document, index, alreadyImportedNamespaces);
        }
        return document;
    }

    private int addImportFromDefinition(Definition definition, Document document, int index, Set<String> alreadyImportedNamespaces) {
        String namespace = definition.getName().getNamespaceURI();
        String generatedPrefix = "vr";
        if (!this.prefixMap.containsKey(namespace)) {
            this.prefixMap.put(namespace, "vr" + index);
            ++index;
        }
        if (!alreadyImportedNamespaces.contains(namespace) || "http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd".equals(namespace)) {
            document.getDocumentElement().appendChild(this.createImport(document, namespace));
            alreadyImportedNamespaces.add(namespace);
        }
        if (definition instanceof PropertyContainerDefinition) {
            PropertyContainerDefinition container = (PropertyContainerDefinition)definition;
            Set<PropertyDefinition> definitions = container.getDefinitions();
            for (PropertyDefinition property : definitions) {
                index += this.addImportFromDefinition(property, document, index, alreadyImportedNamespaces);
            }
        }
        return index;
    }

    private Element createImport(Document document, String namespace) {
        Element element = document.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
        this.setAttribute(element, "namespace", namespace);
        return element;
    }

    private Document createSchemaDocument(String targetNamespace) throws ParserConfigurationException {
        QName name = new QName("http://www.w3.org/2001/XMLSchema", "schema");
        Document doc = this.createDocument(name);
        Element root = doc.getDocumentElement();
        this.setAttribute(root, "targetNamespace", targetNamespace);
        this.setAttribute(root, "elementFormDefault", "qualified");
        if (this.attributeQualified) {
            this.setAttribute(root, "attributeFormDefault", "qualified");
        }
        return doc;
    }

    private Document createDocument(QName name) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        doc.appendChild(root);
        return doc;
    }

    private void addNamespaces(Element schema, Set<String> usedNamespaces) {
        Set<Map.Entry<String, String>> set = this.prefixMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (schema.hasAttribute("xmlns:" + entry.getValue()) || usedNamespaces.contains(entry.getKey())) continue;
            schema.setAttribute("xmlns:" + entry.getValue(), entry.getKey());
        }
    }

    private Set<String> updatePrefixes(Node parent) {
        HashSet<String> usedNamespaces = new HashSet<String>();
        if (parent.getNamespaceURI() != null) {
            usedNamespaces.add(parent.getNamespaceURI());
            parent.setPrefix(this.prefixMap.get(parent.getNamespaceURI()));
        }
        if (parent.hasChildNodes()) {
            NodeList children = parent.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                usedNamespaces.addAll(this.updatePrefixes(child));
            }
        }
        return usedNamespaces;
    }

    private void setAttribute(Element element, String attrName, String attrValue) {
        this.setAttribute(element, new QName("http://www.w3.org/2001/XMLSchema", attrName), attrValue);
    }

    private void setAttribute(Element element, QName attr, String attrValue) {
        if (this.attributeQualified) {
            element.setAttributeNS(attr.getNamespaceURI(), attr.getLocalPart(), attrValue);
        } else {
            element.setAttribute(attr.getLocalPart(), attrValue);
        }
    }

    @Deprecated
    public static void main(String[] args) throws SchemaProcessorException {
        String ns1 = "http://a.sk";
        Schema schema = new Schema(ns1);
        PropertyContainerDefinition cont1 = new PropertyContainerDefinition(null, new QName(ns1, "account"), new QName("http://www.w3.org/2001/XMLSchema", "string"));
        cont1.setDisplayName("display name");
        cont1.setHelp("help");
        schema.getDefinitions().add(cont1);
        Document document = Schema.parseSchema(schema);
        System.out.println(SchemaToDomProcessor.printDom(document));
    }

    @Deprecated
    static StringBuffer printDom(Node node) {
        StringWriter writer = new StringWriter();
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setParameter("encoding", "utf-8");
            DOMSource source = new DOMSource(node);
            trans.transform(source, new StreamResult(writer));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return writer.getBuffer();
    }
}

