/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.processor;

import com.evolveum.midpoint.schema.processor.Definition;
import com.evolveum.midpoint.schema.processor.DomToSchemaProcessor;
import com.evolveum.midpoint.schema.processor.PropertyContainerDefinition;
import com.evolveum.midpoint.schema.processor.SchemaProcessorException;
import com.evolveum.midpoint.schema.processor.SchemaToDomProcessor;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Schema {
    private String namespace;
    private Set<Definition> definitions;

    Schema(String namespace) {
        if (StringUtils.isEmpty((String)namespace)) {
            throw new IllegalArgumentException("Namespace can't be null or empty.");
        }
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Set<Definition> getDefinitions() {
        if (this.definitions == null) {
            this.definitions = new HashSet<Definition>();
        }
        return this.definitions;
    }

    public static Schema parse(Element schema) throws SchemaProcessorException {
        if (schema == null) {
            throw new IllegalArgumentException("Input stream must not be null.");
        }
        DomToSchemaProcessor processor = new DomToSchemaProcessor();
        return processor.parseDom(schema);
    }

    public static Document parseSchema(Schema schema) throws SchemaProcessorException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema can't be null.");
        }
        SchemaToDomProcessor processor = new SchemaToDomProcessor();
        return processor.parseSchema(schema);
    }

    PropertyContainerDefinition findContainerDefinitionByType(QName typeName) {
        for (Definition definition : this.definitions) {
            if (!(definition instanceof PropertyContainerDefinition) || !typeName.equals(definition.getTypeName())) continue;
            return (PropertyContainerDefinition)definition;
        }
        return null;
    }
}

