/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.processor;

import com.evolveum.midpoint.schema.processor.Definition;
import com.evolveum.midpoint.schema.processor.PropertyContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceObjectAttributeDefinition;
import com.evolveum.midpoint.schema.processor.Schema;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class ResourceObjectDefinition
extends PropertyContainerDefinition {
    private Schema schema;
    private Set<ResourceObjectAttributeDefinition> idenitifiers;
    private Set<ResourceObjectAttributeDefinition> secondaryIdenitifiers;
    private ResourceObjectAttributeDefinition description;
    private ResourceObjectAttributeDefinition displayName;
    private boolean defaultAccountType = false;
    private boolean accountType = false;
    private String nativeObjectClass;

    ResourceObjectDefinition(Schema schema, QName name, QName defaultName, QName typeName) {
        super(name, defaultName, typeName);
        if (schema == null) {
            throw new IllegalArgumentException("Schema can't be null.");
        }
        this.schema = schema;
    }

    public Set<ResourceObjectAttributeDefinition> getIdentifiers() {
        if (this.idenitifiers == null) {
            this.idenitifiers = new HashSet<ResourceObjectAttributeDefinition>();
        }
        return this.idenitifiers;
    }

    public Set<ResourceObjectAttributeDefinition> getSecondaryIdentifiers() {
        if (this.secondaryIdenitifiers == null) {
            this.secondaryIdenitifiers = new HashSet<ResourceObjectAttributeDefinition>();
        }
        return this.secondaryIdenitifiers;
    }

    public ResourceObjectAttributeDefinition getDescriptionAttribute() {
        return this.description;
    }

    public void setDescriptionAttribute(ResourceObjectAttributeDefinition description) {
        this.description = description;
    }

    public String getNativeObjectClass() {
        return this.nativeObjectClass;
    }

    void setNativeObjectClass(String nativeObjectClass) {
        this.nativeObjectClass = nativeObjectClass;
    }

    public boolean isAccountType() {
        return this.accountType;
    }

    void setAccountType(boolean accountType) {
        this.accountType = accountType;
        if (!accountType) {
            this.defaultAccountType = false;
        }
    }

    public boolean isDefaultAccountType() {
        return this.defaultAccountType;
    }

    void setDefaultAccountType(boolean defaultAccountType) {
        this.defaultAccountType = defaultAccountType;
        if (defaultAccountType && !this.accountType) {
            throw new IllegalStateException("Can't be default account type, flat account type (boolean) not set.");
        }
        if (defaultAccountType) {
            Set<Definition> definitions = this.schema.getDefinitions();
            for (Definition definition : definitions) {
                ResourceObjectDefinition resourceDef;
                if (this == definition || !(definition instanceof ResourceObjectDefinition) || !(resourceDef = (ResourceObjectDefinition)definition).isAccountType() || !resourceDef.isDefaultAccountType()) continue;
                throw new IllegalStateException("Can't have two default account types (ResourceObjectDefinition) in schema (" + this.getName() + ", " + resourceDef.getName() + ").");
            }
        }
    }

    public ResourceObjectAttributeDefinition getDisplayNameAttribute() {
        return this.displayName;
    }

    void setDisplayNameAttribute(ResourceObjectAttributeDefinition displayName) {
        this.displayName = displayName;
    }
}

