/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.processor;

import com.evolveum.midpoint.schema.processor.MidPointObject;
import com.evolveum.midpoint.schema.processor.PropertyDefinition;
import java.util.Set;
import javax.xml.namespace.QName;

public class Property {
    private QName name;
    private PropertyDefinition definition;
    private Set<MidPointObject> values;

    public Property() {
    }

    public Property(QName name, PropertyDefinition definition) {
        this.name = name;
        this.definition = definition;
    }

    public Property(QName name, PropertyDefinition definition, Set<MidPointObject> values) {
        this.name = name;
        this.definition = definition;
        this.values = values;
    }

    public PropertyDefinition getDefinition() {
        return this.definition;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public void setDefinition(PropertyDefinition definition) {
        this.definition = definition;
    }

    public Object getValues() {
        return this.values;
    }

    public <T> Set<T> getValues(Class<T> T) {
        return this.values;
    }

    public <T> T getValue(Class<T> T) {
        if (this.values.size() > 1) {
            throw new IllegalStateException("Attempt to get single value from property " + this.name + " with multiple values");
        }
        MidPointObject o = this.values.iterator().next();
        if (o == null) {
            return null;
        }
        return (T)o;
    }

    public String getDisplayName() {
        return this.getDefinition() == null ? null : this.getDefinition().getDisplayName();
    }

    public String getHelp() {
        return this.getDefinition() == null ? null : this.getDefinition().getHelp();
    }
}

