/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.processor;

import com.evolveum.midpoint.schema.processor.ProcessorConstants;
import com.evolveum.midpoint.schema.processor.PropertyDefinition;
import com.evolveum.midpoint.schema.processor.ResourceObjectAttributeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceObjectDefinition;
import com.evolveum.midpoint.schema.processor.Schema;
import com.evolveum.midpoint.schema.processor.SchemaErrorHandler;
import com.evolveum.midpoint.schema.processor.SchemaProcessorException;
import com.evolveum.midpoint.schema.processor.SchemaToDomProcessor;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DomToSchemaProcessor {
    DomToSchemaProcessor() {
    }

    Schema parseDom(Element xsdSchema) throws SchemaProcessorException {
        Schema schema = this.initSchema(xsdSchema);
        XSSchemaSet set = this.parseSchema(xsdSchema);
        Iterator iterator = set.iterateComplexTypes();
        while (iterator.hasNext()) {
            XSComplexType complexType = (XSComplexType)iterator.next();
            if (!complexType.getTargetNamespace().equals(schema.getNamespace())) continue;
            this.addPropertyContainerDefinition(complexType, xsdSchema, schema);
        }
        return schema;
    }

    private Schema initSchema(Element xsdSchema) {
        String targetNamespace = xsdSchema.getAttribute("targetNamespace");
        return new Schema(targetNamespace);
    }

    private void addPropertyContainerDefinition(XSComplexType complexType, Element document, Schema schema) {
        XSTerm term;
        XSParticle particle;
        QName qname = new QName(complexType.getTargetNamespace(), complexType.getName());
        XSAnnotation annotation = complexType.getAnnotation();
        Element nativeAttrElement = this.getAnnotationElement(annotation, ProcessorConstants.A_NATIVE_OBJECT_CLASS);
        String nativeObjectClass = nativeAttrElement == null ? qname.getLocalPart() : nativeAttrElement.getTextContent();
        ResourceObjectDefinition definition = new ResourceObjectDefinition(schema, qname, null, new QName(schema.getNamespace(), complexType.getName()));
        definition.setNativeObjectClass(nativeObjectClass);
        if (this.isAccountObject(annotation)) {
            definition.setAccountType(true);
        }
        List<PropertyDefinition> list = null;
        XSContentType content = complexType.getContentType();
        if (content != null && (particle = content.asParticle()) != null && (term = particle.getTerm()).isModelGroup()) {
            list = this.createResourceAttributeListFromGroup(term.asModelGroup());
        }
        if (list != null) {
            Set<PropertyDefinition> set = definition.getDefinitions();
            for (PropertyDefinition property : list) {
                if (property instanceof ResourceObjectAttributeDefinition) {
                    ResourceObjectAttributeDefinition attrDefinition = (ResourceObjectAttributeDefinition)property;
                    attrDefinition.setObjectDefinition(definition);
                }
                set.add(property);
            }
        }
        this.parseAnnotationForObjectClass(annotation, definition, document);
        schema.getDefinitions().add(definition);
    }

    private List<PropertyDefinition> createResourceAttributeListFromGroup(XSModelGroup group) {
        XSParticle[] particles;
        ArrayList<PropertyDefinition> definitions = new ArrayList<PropertyDefinition>();
        for (XSParticle p : particles = group.getChildren()) {
            XSTerm pterm = p.getTerm();
            if (pterm.isModelGroup()) {
                definitions.addAll(this.createResourceAttributeListFromGroup(pterm.asModelGroup()));
            }
            if (!pterm.isElementDecl()) continue;
            XSAnnotation annotation = this.selectAnnotationToUse(p.getAnnotation(), pterm.getAnnotation());
            XSElementDecl element = pterm.asElementDecl();
            QName qname = new QName(element.getTargetNamespace(), element.getName());
            Element nativeAttrElement = this.getAnnotationElement(annotation, ProcessorConstants.A_NATIVE_ATTRIBUTE_NAME);
            String nativeAttributeName = nativeAttrElement == null ? qname.getLocalPart() : nativeAttrElement.getTextContent();
            XSType type = element.getType();
            if (qname.getLocalPart().contains("NAME")) {
                System.out.println(type.getName());
            }
            ResourceObjectAttributeDefinition attribute = new ResourceObjectAttributeDefinition(qname, null, new QName(type.getTargetNamespace(), type.getName()));
            if (!StringUtils.isEmpty((String)nativeAttributeName)) {
                attribute.setNativeAttributeName(nativeAttributeName);
            }
            attribute.setMinOccurs(p.getMinOccurs());
            attribute.setMaxOccurs(p.getMaxOccurs());
            this.parseAnnotationForAttribute(annotation, attribute);
            definitions.add(attribute);
        }
        return definitions;
    }

    private void parseAnnotationForObjectClass(XSAnnotation annotation, ResourceObjectDefinition objectClass, Element document) {
        String defaultValue;
        Element accountType;
        if (annotation == null || annotation.getAnnotation() == null) {
            return;
        }
        ResourceObjectAttributeDefinition attrDefinition = this.getAnnotationReference(annotation, ProcessorConstants.A_DISPLAY_NAME, document, objectClass);
        if (attrDefinition != null) {
            objectClass.setDisplayNameAttribute(attrDefinition);
        }
        if ((attrDefinition = this.getAnnotationReference(annotation, ProcessorConstants.A_DESCRIPTION_ATTRIBUTE, document, objectClass)) != null) {
            objectClass.setDescriptionAttribute(attrDefinition);
        }
        if ((attrDefinition = this.getAnnotationReference(annotation, ProcessorConstants.A_IDENTIFIER, document, objectClass)) != null) {
            objectClass.getIdentifiers().add(attrDefinition);
        }
        if ((attrDefinition = this.getAnnotationReference(annotation, ProcessorConstants.A_SECONDARY_IDENTIFIER, document, objectClass)) != null) {
            objectClass.getSecondaryIdentifiers().add(attrDefinition);
        }
        if ((accountType = this.getAnnotationElement(annotation, ProcessorConstants.A_ACCOUNT_TYPE)) != null && (defaultValue = accountType.getAttribute("default")) != null) {
            objectClass.setDefaultAccountType(Boolean.parseBoolean(defaultValue));
        }
    }

    private void parseAnnotationForAttribute(XSAnnotation annotation, ResourceObjectAttributeDefinition attribute) {
        Element help;
        if (annotation == null || annotation.getAnnotation() == null) {
            return;
        }
        Element attributeDisplayName = this.getAnnotationElement(annotation, ProcessorConstants.A_ATTRIBUTE_DISPLAY_NAME);
        if (attributeDisplayName != null) {
            attribute.setDisplayName(attributeDisplayName.getTextContent());
        }
        if ((help = this.getAnnotationElement(annotation, ProcessorConstants.A_HELP)) != null) {
            attribute.setHelp(help.getTextContent());
        }
    }

    private ResourceObjectAttributeDefinition getAnnotationReference(XSAnnotation annotation, QName qname, Element document, ResourceObjectDefinition objectClass) {
        PropertyDefinition definition;
        String reference;
        Element element = this.getAnnotationElement(annotation, qname);
        if (element != null && (reference = element.getAttribute("ref")) != null && !reference.isEmpty() && (definition = objectClass.findPropertyDefinition(this.getQNameForReference(reference, document))) instanceof ResourceObjectAttributeDefinition) {
            return (ResourceObjectAttributeDefinition)definition;
        }
        return null;
    }

    private QName getQNameForReference(String reference, Element element) {
        String[] array = reference.split(":");
        String namespace = element.getOwnerDocument().lookupPrefix(array[0]);
        if (namespace == null) {
            namespace = element.getAttribute("xmlns:" + array[0]);
        }
        return new QName(namespace, array[1]);
    }

    private boolean isAccountObject(XSAnnotation annotation) {
        if (annotation == null || annotation.getAnnotation() == null) {
            return false;
        }
        Element accountType = this.getAnnotationElement(annotation, ProcessorConstants.A_ACCOUNT_TYPE);
        return accountType != null;
    }

    private Element getAnnotationElement(XSAnnotation annotation, QName qname) {
        if (annotation == null) {
            return null;
        }
        Element xsdAnnotation = (Element)annotation.getAnnotation();
        NodeList list = xsdAnnotation.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        if (list != null && list.getLength() > 0) {
            return (Element)list.item(0);
        }
        return null;
    }

    private XSAnnotation selectAnnotationToUse(XSAnnotation particleAnnotation, XSAnnotation termAnnotation) {
        boolean useParticleAnnotation = false;
        if (particleAnnotation != null && particleAnnotation.getAnnotation() != null && this.testAnnotationAppinfo(particleAnnotation)) {
            useParticleAnnotation = true;
        }
        boolean useTermAnnotation = false;
        if (termAnnotation != null && termAnnotation.getAnnotation() != null && this.testAnnotationAppinfo(termAnnotation)) {
            useTermAnnotation = true;
        }
        if (useParticleAnnotation) {
            return particleAnnotation;
        }
        if (useTermAnnotation) {
            return termAnnotation;
        }
        return null;
    }

    private boolean testAnnotationAppinfo(XSAnnotation annotation) {
        Element appinfo = this.getAnnotationElement(annotation, new QName("http://www.w3.org/2001/XMLSchema", "appinfo"));
        return appinfo != null;
    }

    private XSOMParser createSchemaParser() {
        XSOMParser parser = new XSOMParser();
        parser.setErrorHandler((ErrorHandler)new SchemaErrorHandler());
        parser.setAnnotationParser((AnnotationParserFactory)new DomAnnotationParserFactory());
        parser.setEntityResolver((EntityResolver)SchemaConstants.getEntityResolver());
        return parser;
    }

    private XSSchemaSet parseSchema(Element schema) throws SchemaProcessorException {
        XSSchemaSet xss = null;
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "no");
            trans.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(schema);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            trans.transform(source, result);
            XSOMParser parser = this.createSchemaParser();
            InputSource inSource = new InputSource(new ByteArrayInputStream(out.toByteArray()));
            inSource.setSystemId("SystemId");
            inSource.setEncoding("utf-8");
            parser.parse(inSource);
            xss = parser.getResult();
        }
        catch (Exception ex) {
            throw new SchemaProcessorException("Uknown error during resource xsd schema parsing: " + ex.getMessage(), ex);
        }
        return xss;
    }

    @Deprecated
    public static void main(String[] args) throws SchemaProcessorException, IOException {
        File file = new File("./src/main/java/a.xsd");
        InputStream stream = new FileInputStream(file);
        Schema schema = Schema.parse(DomToSchemaProcessor.parseDocument(stream));
        Document document = Schema.parseSchema(schema);
        String str = SchemaToDomProcessor.printDom(document).toString();
        System.out.println(str);
        System.out.println("---------------------------");
        stream = new ByteArrayInputStream(str.getBytes("utf-8"));
        schema = Schema.parse(DomToSchemaProcessor.parseDocument(stream));
        document = Schema.parseSchema(schema);
        str = SchemaToDomProcessor.printDom(document).toString();
        System.out.println(str);
    }

    @Deprecated
    private static Element parseDocument(InputStream doc) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder loader = factory.newDocumentBuilder();
            return loader.parse(doc).getDocumentElement();
        }
        catch (SAXException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage());
        }
    }
}

