/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.util;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.util.EnvConfig;

public class EnvUtils {
    private static Logger log = Logger.getLogger(EnvUtils.class.getName());
    public static String ICEFACES_ENV_CONFIG = "org.icefaces.env.config";
    public static String ICEFACES_AUTO = "org.icefaces.render.auto";
    public static String ICEFACES_AUTOID = "org.icefaces.autoid";
    public static String COMPRESS_DOM = "org.icefaces.compressDOM";
    public static String COMPRESS_RESOURCES = "org.icefaces.compressResources";
    public static String DELTA_SUBMT = "org.icefaces.deltaSubmit";
    public static String LAZY_PUSH = "org.icefaces.lazyPush";
    public static String STANDARD_FORM_SERIALIZATION = "org.icefaces.standardFormSerialization";
    public static String STRICT_SESSION_TIMEOUT = "org.icefaces.strictSessionTimeout";
    public static String WINDOW_SCOPE_EXPIRATION = "org.icefaces.windowScopeExpiration";
    public static String MANDATORY_RESOURCE_CONFIG = "org.icefaces.mandatoryResourceConfiguration";
    public static String UNIQUE_RESOURCE_URLS = "org.icefaces.uniqueResourceURLs";
    public static String LAZY_WINDOW_SCOPE = "org.icefaces.lazyWindowScope";
    public static String DISABLE_DEFAULT_ERROR_POPUPS = "org.icefaces.disableDefaultErrorPopups";
    public static String CONNECTION_LOST_REDIRECT_URI = "org.icefaces.connectionLostRedirectURI";
    public static String SESSION_EXPIRED_REDIRECT_URI = "org.icefaces.sessionExpiredRedirectURI";
    public static String ICEFACES_RENDER = "org.icefaces.render";
    public static String ARIA_ENABLED = "org.icefaces.aria.enabled";
    public static String BLOCK_UI_ON_SUBMIT = "org.icefaces.blockUIOnSubmit";
    public static final String HEAD_DETECTED = "org.icefaces.headDetected";
    public static final String BODY_DETECTED = "org.icefaces.bodyDetected";
    private static String RESOURCE_PREFIX = "/javax.faces.resource/";
    private static String PATH_TEMPLATE = "org.icefaces.resource.pathTemplate";
    private static String DUMMY_RESOURCE = "bridge.js";
    private static String[] DEFAULT_TEMPLATE = new String[]{RESOURCE_PREFIX, ".jsf"};
    private static Class PortletSessionClass;
    private static Class PortletRequestClass;
    private static boolean icepushPresent;
    private static boolean mojarraPresent;

    public static boolean isAriaEnabled(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Map viewMap = viewRoot.getViewMap();
        Object ariaEnabled = viewMap.get(ARIA_ENABLED);
        if (null == ariaEnabled) {
            return EnvConfig.getEnvConfig((FacesContext)facesContext).ariaEnabled;
        }
        return Boolean.TRUE.equals(ariaEnabled);
    }

    public static boolean isAutoId(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).autoId;
    }

    public static boolean isAutoRender(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).autoRender;
    }

    public static boolean isBlockUIOnSubmit(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Map viewMap = viewRoot.getViewMap();
        Object blockUIOnSubmit = viewMap.get(BLOCK_UI_ON_SUBMIT);
        if (null == blockUIOnSubmit) {
            return EnvConfig.getEnvConfig((FacesContext)facesContext).blockUIOnSubmit;
        }
        return Boolean.TRUE.equals(blockUIOnSubmit);
    }

    public static boolean isCompressDOM(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).compressDOM;
    }

    public static boolean isCompressResources(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).compressResources;
    }

    public static String getConnectionLostRedirectURI(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).connectionLostRedirectURI;
    }

    public static boolean isDeltaSubmit(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).deltaSubmit;
    }

    public static boolean isLazyPush(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Map viewMap = viewRoot.getViewMap();
        Object lazyPush = viewMap.get(LAZY_PUSH);
        if (null == lazyPush) {
            return EnvConfig.getEnvConfig((FacesContext)facesContext).lazyPush;
        }
        return Boolean.TRUE.equals(lazyPush);
    }

    public static boolean isPartialStateSaving(FacesContext facesContext) {
        return !"false".equalsIgnoreCase(FacesContext.getCurrentInstance().getExternalContext().getInitParameter("javax.faces.PARTIAL_STATE_SAVING"));
    }

    public static String getSessionExpiredRedirectURI(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).sessionExpiredRedirectURI;
    }

    public static boolean isStandardFormSerialization(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).standardFormSerialization;
    }

    public static boolean isStrictSessionTimeout(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).strictSessionTimeout;
    }

    public static long getWindowScopeExpiration(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).windowScopeExpiration;
    }

    public static String getMandatoryResourceConfig(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).mandatoryResourceConfig;
    }

    public static boolean isUniqueResourceURLs(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).uniqueResourceURLs;
    }

    public static boolean isICEfacesView(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Map viewMap = viewRoot.getViewMap();
        Object icefacesRender = viewMap.get(ICEFACES_RENDER);
        if (null == icefacesRender) {
            icefacesRender = EnvConfig.getEnvConfig((FacesContext)facesContext).autoRender;
            viewMap.put(ICEFACES_RENDER, icefacesRender);
        }
        return Boolean.TRUE.equals(icefacesRender);
    }

    public static boolean isICEpushPresent() {
        return icepushPresent;
    }

    public static boolean hasHeadAndBodyComponents(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Map viewMap = viewRoot.getViewMap();
        if (!viewMap.containsKey(HEAD_DETECTED) || !viewMap.containsKey(BODY_DETECTED)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "ICEfaces disabled for view " + viewRoot.getViewId() + "\n  h:head tag available: " + viewMap.containsKey(HEAD_DETECTED) + "\n  h:body tag available: " + viewMap.containsKey(BODY_DETECTED));
            }
            return false;
        }
        return true;
    }

    public static boolean needViewStateHack() {
        return mojarraPresent;
    }

    public static String[] getPathTemplate() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        String[] pathTemplate = (String[])applicationMap.get(PATH_TEMPLATE);
        if (null != pathTemplate) {
            return pathTemplate;
        }
        Resource dummyResource = facesContext.getApplication().getResourceHandler().createResource(DUMMY_RESOURCE);
        if (null != dummyResource) {
            String dummyPath = dummyResource.getRequestPath();
            pathTemplate = EnvUtils.extractPathTemplate(dummyPath);
        }
        if (null == pathTemplate) {
            return DEFAULT_TEMPLATE;
        }
        applicationMap.put(PATH_TEMPLATE, pathTemplate);
        return pathTemplate;
    }

    private static String[] extractPathTemplate(String path) {
        int start = path.indexOf(DUMMY_RESOURCE);
        String pre = path.substring(0, start);
        String post = path.substring(start + DUMMY_RESOURCE.length());
        return new String[]{pre, post};
    }

    public static boolean instanceofPortletSession(Object session) {
        return PortletSessionClass != null && PortletSessionClass.isInstance(session);
    }

    public static boolean instanceofPortletRequest(Object request) {
        return PortletRequestClass != null && PortletRequestClass.isInstance(request);
    }

    public static boolean isPushRequest(FacesContext facesContext) {
        ExternalContext ec = facesContext.getExternalContext();
        String reqPath = ec.getRequestServletPath();
        String pathInfo = ec.getRequestPathInfo();
        String reqParam = (String)ec.getRequestParameterMap().get("ice.submit.type");
        return reqPath != null && reqPath.contains("listen.icepush") || pathInfo != null && pathInfo.contains("listen.icepush") || "ice.push".equals(reqParam);
    }

    public static boolean isLazyWindowScope(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).lazyWindowScope;
    }

    public static boolean disableDefaultErrorPopups(FacesContext facesContext) {
        return EnvConfig.getEnvConfig((FacesContext)facesContext).disableDefaultErrorPopups;
    }

    static {
        try {
            PortletSessionClass = Class.forName("javax.portlet.PortletSession");
            PortletRequestClass = Class.forName("javax.portlet.PortletRequest");
        }
        catch (Throwable t) {
            log.log(Level.FINE, "Portlet classes not available: ", t);
        }
        try {
            Class.forName("org.icepush.PushContext");
            icepushPresent = true;
        }
        catch (ClassNotFoundException e) {
            icepushPresent = false;
        }
        mojarraPresent = false;
        try {
            Class.forName("com.sun.faces.context.FacesContextImpl");
            mojarraPresent = true;
        }
        catch (Throwable t) {
            mojarraPresent = false;
        }
    }
}

