/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.util;

import java.util.Map;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.util.EnvUtils;

class EnvConfig {
    private static Logger log = Logger.getLogger(EnvConfig.class.getName());
    boolean autoRender;
    boolean autoId;
    boolean ariaEnabled;
    boolean blockUIOnSubmit;
    boolean compressDOM;
    boolean compressResources;
    String connectionLostRedirectURI;
    boolean deltaSubmit;
    boolean lazyPush;
    boolean pushActive;
    String sessionExpiredRedirectURI;
    boolean standardFormSerialization;
    boolean strictSessionTimeout;
    long windowScopeExpiration;
    String mandatoryResourceConfig;
    boolean uniqueResourceURLs;
    boolean lazyWindowScope;
    public boolean disableDefaultErrorPopups;

    public EnvConfig(Map initMap) {
        this.init(initMap);
    }

    public void init(Map initMap) {
        StringBuilder info = new StringBuilder();
        this.autoRender = this.decodeBoolean(initMap, EnvUtils.ICEFACES_AUTO, true, info);
        this.autoId = this.decodeBoolean(initMap, EnvUtils.ICEFACES_AUTOID, true, info);
        this.ariaEnabled = this.decodeBoolean(initMap, EnvUtils.ARIA_ENABLED, true, info);
        this.blockUIOnSubmit = this.decodeBoolean(initMap, EnvUtils.BLOCK_UI_ON_SUBMIT, false, info);
        this.compressDOM = this.decodeBoolean(initMap, EnvUtils.COMPRESS_DOM, false, info);
        this.compressResources = this.decodeBoolean(initMap, EnvUtils.COMPRESS_RESOURCES, true, info);
        this.connectionLostRedirectURI = this.decodeString(initMap, EnvUtils.CONNECTION_LOST_REDIRECT_URI, null, info);
        this.deltaSubmit = this.decodeBoolean(initMap, EnvUtils.DELTA_SUBMT, false, info);
        this.lazyPush = this.decodeBoolean(initMap, EnvUtils.LAZY_PUSH, true, info);
        this.sessionExpiredRedirectURI = this.decodeString(initMap, EnvUtils.SESSION_EXPIRED_REDIRECT_URI, null, info);
        this.standardFormSerialization = this.decodeBoolean(initMap, EnvUtils.STANDARD_FORM_SERIALIZATION, false, info);
        this.strictSessionTimeout = this.decodeBoolean(initMap, EnvUtils.STRICT_SESSION_TIMEOUT, false, info);
        this.windowScopeExpiration = this.decodeLong(initMap, EnvUtils.WINDOW_SCOPE_EXPIRATION, 1000L, info);
        this.mandatoryResourceConfig = this.decodeString(initMap, EnvUtils.MANDATORY_RESOURCE_CONFIG, null, info);
        this.uniqueResourceURLs = this.decodeBoolean(initMap, EnvUtils.UNIQUE_RESOURCE_URLS, true, info);
        this.lazyWindowScope = this.decodeBoolean(initMap, EnvUtils.LAZY_WINDOW_SCOPE, true, info);
        this.disableDefaultErrorPopups = this.decodeBoolean(initMap, EnvUtils.DISABLE_DEFAULT_ERROR_POPUPS, false, info);
        log.info("ICEfaces Configuration: \n" + info);
    }

    public static EnvConfig getEnvConfig(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map appMap = externalContext.getApplicationMap();
        EnvConfig envConfig = (EnvConfig)appMap.get(EnvUtils.ICEFACES_ENV_CONFIG);
        if (null == envConfig) {
            envConfig = new EnvConfig(externalContext.getInitParameterMap());
            appMap.put(EnvUtils.ICEFACES_ENV_CONFIG, envConfig);
        }
        return envConfig;
    }

    boolean decodeBoolean(Map map, String name, boolean defaultValue, StringBuilder info) {
        String paramValue = (String)map.get(name);
        if (null == paramValue) {
            info.append(name).append(": ").append(defaultValue).append(" [default]\n");
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(paramValue)) {
            info.append(name).append(": true\n");
            return true;
        }
        if ("false".equalsIgnoreCase(paramValue)) {
            info.append(name).append(": false\n");
            return false;
        }
        info.append(name).append(": ").append(defaultValue).append(" [default replacing malformed non-boolean value: ").append(paramValue).append("]\n");
        return defaultValue;
    }

    String decodeString(Map map, String name, String defaultValue, StringBuilder info) {
        String paramValue = (String)map.get(name);
        if (null == paramValue) {
            info.append(name).append(": ").append(defaultValue).append(" [default]\n");
            return defaultValue;
        }
        info.append(name).append(": ").append(paramValue).append("\n");
        return paramValue;
    }

    long decodeLong(Map map, String name, long defaultValue, StringBuilder info) {
        String paramValue = (String)map.get(name);
        if (null == paramValue) {
            info.append(name).append(" = ").append(defaultValue).append(" [default]\n");
            return defaultValue;
        }
        try {
            return Long.parseLong(paramValue);
        }
        catch (Exception e) {
            info.append(name).append(": ").append(defaultValue).append(" [default replacing malformed long value: ").append(paramValue).append("]\n");
            return defaultValue;
        }
    }
}

