/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.event.AjaxDisabledWriter;
import org.icefaces.impl.event.UIOutputWriter;
import org.icefaces.util.EnvUtils;

public class FormSubmit
implements SystemEventListener {
    public static final String DISABLE_CAPTURE_SUBMIT = "DISABLE_CAPTURE_SUBMIT";
    private static final String CAPTURE_SUBMIT_SUFFIX = "_captureSubmit";
    private boolean deltaSubmit;
    private boolean partialStateSaving;

    public FormSubmit() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.deltaSubmit = EnvUtils.isDeltaSubmit(facesContext);
        this.partialStateSaving = EnvUtils.isPartialStateSaving(facesContext);
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(context)) {
            return;
        }
        final HtmlForm form = (HtmlForm)((PostAddToViewEvent)event).getComponent();
        if (form.getAttributes().get(DISABLE_CAPTURE_SUBMIT) != null) {
            return;
        }
        String componentId = form.getId() + CAPTURE_SUBMIT_SUFFIX;
        if (!this.partialStateSaving) {
            for (UIComponent child : form.getChildren()) {
                String id = child.getId();
                if (null == id || !id.endsWith(CAPTURE_SUBMIT_SUFFIX)) continue;
                return;
            }
        }
        if (null != context.getAttributes().get(componentId)) {
            return;
        }
        context.getAttributes().put(componentId, componentId);
        UIOutputWriter scriptWriter = new UIOutputWriter(){

            public void encode(ResponseWriter writer, FacesContext context) throws IOException {
                if (form.getAttributes().get(FormSubmit.DISABLE_CAPTURE_SUBMIT) != null) {
                    return;
                }
                String formId = form.getClientId(context);
                writer.startElement("script", (UIComponent)this);
                writer.writeAttribute("type", (Object)"text/javascript", "type");
                writer.writeAttribute("id", (Object)this.getClientId(context), "id");
                writer.write("ice.captureSubmit('");
                writer.write(formId);
                writer.write("',");
                writer.write(Boolean.toString(FormSubmit.this.deltaSubmit));
                writer.write(");");
                writer.write("ice.captureEnterKey('");
                writer.write(formId);
                writer.write("');");
                writer.endElement("script");
            }
        };
        scriptWriter.setId(componentId);
        scriptWriter.setTransient(true);
        form.getChildren().add(0, scriptWriter);
        AjaxDisabledWriter disabledWriter = new AjaxDisabledWriter();
        disabledWriter.setTransient(true);
        form.getChildren().add(disabledWriter);
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof HtmlForm;
    }
}

