/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.util.EnvUtils;

public class AjaxDisabledList
implements SystemEventListener {
    public static String DISABLED_LIST = "org.icefaces.ajaxdisabledlist";

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        UIForm theForm;
        FacesContext context = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(context)) {
            return;
        }
        UIComponentBase component = (UIComponentBase)((PreRenderComponentEvent)event).getComponent();
        Map behaviors = component.getClientBehaviors();
        if (null == behaviors) {
            return;
        }
        boolean isDisabled = false;
        Iterator theBehaviors = behaviors.values().iterator();
        while (theBehaviors.hasNext()) {
            ClientBehavior behavior = (ClientBehavior)((List)theBehaviors.next()).get(0);
            if (!(behavior instanceof AjaxBehavior) || !((AjaxBehavior)behavior).isDisabled()) continue;
            isDisabled = true;
            break;
        }
        if (isDisabled && null != (theForm = AjaxDisabledList.getContainingForm((UIComponent)component))) {
            String disabledList = (String)theForm.getAttributes().get(DISABLED_LIST);
            if (null == disabledList) {
                disabledList = " ";
            }
            disabledList = disabledList + component.getClientId() + " ";
            theForm.getAttributes().put(DISABLED_LIST, disabledList);
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIInput || source instanceof UICommand;
    }

    public static UIForm getContainingForm(UIComponent component) {
        UIComponent parent = component.getParent();
        while (!(parent instanceof UIForm) && !(parent instanceof UIViewRoot)) {
            parent = parent.getParent();
        }
        if (parent instanceof UIForm) {
            return (UIForm)parent;
        }
        return null;
    }
}

