/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.faces.FactoryFinder;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostConstructCustomScopeEvent;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.ScopeContext;
import javax.faces.event.SystemEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.icefaces.bean.WindowDisposed;
import org.icefaces.impl.push.SessionViewManager;
import org.icefaces.util.EnvUtils;

public class WindowScopeManager
extends ResourceHandlerWrapper {
    public static final String ScopeName = "window";
    private static final Logger log = Logger.getLogger(WindowScopeManager.class.getName());
    private static final String seed = Integer.toString(new Random().nextInt(1000), 36);
    private static SharedMapLookupStrategy sharedMapLookupStrategy;
    private static ScopeMap UnusedScopeMap;
    private ResourceHandler wrapped;

    public WindowScopeManager(ResourceHandler wrapped) {
        this.wrapped = wrapped;
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        lifecycle.addPhaseListener(new PhaseListener(){

            public void afterPhase(PhaseEvent event) {
            }

            public void beforePhase(PhaseEvent event) {
                FacesContext context = FacesContext.getCurrentInstance();
                try {
                    ExternalContext externalContext = context.getExternalContext();
                    WindowScopeManager.determineWindowID(context);
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Unable to set up WindowScope ", e);
                }
            }

            public PhaseId getPhaseId() {
                return PhaseId.RESTORE_VIEW;
            }
        });
        lifecycle.addPhaseListener(new PhaseListener(){

            public void afterPhase(PhaseEvent event) {
                FacesContext context = FacesContext.getCurrentInstance();
                try {
                    ExternalContext externalContext = context.getExternalContext();
                    Object session = externalContext.getSession(false);
                    if (session != null) {
                        if (EnvUtils.instanceofPortletSession(session)) {
                            PortletSession portletSession = (PortletSession)session;
                            Object state = portletSession.getAttribute(WindowScopeManager.class.getName(), 1);
                            if (state != null) {
                                portletSession.setAttribute(WindowScopeManager.class.getName(), state, 1);
                            }
                        } else {
                            HttpSession servletSession = (HttpSession)session;
                            Object state = servletSession.getAttribute(WindowScopeManager.class.getName());
                            if (state != null) {
                                servletSession.setAttribute(WindowScopeManager.class.getName(), state);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINE, "Unable to reset WindowScope", e);
                }
            }

            public void beforePhase(PhaseEvent event) {
            }

            public PhaseId getPhaseId() {
                return PhaseId.RENDER_RESPONSE;
            }
        });
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        if (null == facesContext.getExternalContext().getSession(false)) {
            this.wrapped.handleResourceRequest(facesContext);
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Map parameters = externalContext.getRequestParameterMap();
        if (WindowScopeManager.isDisposeWindowRequest(parameters)) {
            String windowID = (String)parameters.get("ice.window");
            WindowScopeManager.disposeWindow(facesContext, windowID);
            if (EnvUtils.isICEpushPresent()) {
                try {
                    String[] viewIDs = (String[])externalContext.getRequestParameterValuesMap().get("ice.view");
                    for (int i = 0; i < viewIDs.length; ++i) {
                        SessionViewManager.removeView(facesContext, viewIDs[i]);
                    }
                }
                catch (RuntimeException e) {
                    log.log(Level.FINE, "Exception during dispose-window ", e);
                }
            }
        } else {
            this.wrapped.handleResourceRequest(facesContext);
        }
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map parameters = externalContext.getRequestParameterMap();
        if (WindowScopeManager.isDisposeWindowRequest(parameters)) {
            return true;
        }
        return this.wrapped.isResourceRequest(facesContext);
    }

    public static ScopeMap lookupWindowScope(FacesContext context) {
        String id = WindowScopeManager.lookupAssociatedWindowID(context.getExternalContext().getRequestMap());
        State state = WindowScopeManager.getState(context);
        return state == null ? null : (ScopeMap)state.windowScopedMaps.get(id);
    }

    public static synchronized String determineWindowID(FacesContext context) {
        ScopeMap map;
        State state = WindowScopeManager.getState(context);
        ExternalContext externalContext = context.getExternalContext();
        String id = (String)externalContext.getRequestParameterMap().get("ice.window");
        try {
            for (Object scopeMap : new ArrayList(state.windowScopedMaps.values())) {
                map = (ScopeMap)scopeMap;
                if (map.getId().equals(id)) continue;
                map.disactivateIfUnused(context);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, "Failed to remove window scope map", e);
        }
        try {
            for (Object scopeMap : new ArrayList(state.disposedWindowScopedMaps)) {
                map = (ScopeMap)scopeMap;
                if (map.getId().equals(id)) continue;
                map.discardIfExpired(context);
            }
        }
        catch (Throwable e) {
            log.log(Level.FINE, "Failed to remove window scope map", e);
        }
        Map requestMap = externalContext.getRequestMap();
        if (id == null) {
            Object scopeMap;
            scopeMap = sharedMapLookupStrategy.lookup(context);
            if (scopeMap == null) {
                scopeMap = state.disposedWindowScopedMaps.isEmpty() ? new ScopeMap(context) : (ScopeMap)state.disposedWindowScopedMaps.removeFirst();
                ((ScopeMap)scopeMap).activate(state);
            }
            WindowScopeManager.associateWindowID(((ScopeMap)scopeMap).id, requestMap);
            return ((ScopeMap)scopeMap).id;
        }
        if (state.windowScopedMaps.containsKey(id)) {
            WindowScopeManager.associateWindowID(id, requestMap);
            return id;
        }
        for (Object disposedScopeMap : new ArrayList(state.disposedWindowScopedMaps)) {
            ScopeMap scopeMap = (ScopeMap)disposedScopeMap;
            if (!scopeMap.getId().equals(id)) continue;
            scopeMap.activate(state);
            WindowScopeManager.associateWindowID(id, requestMap);
            return id;
        }
        UnusedScopeMap = UnusedScopeMap == null ? new ScopeMap(context) : UnusedScopeMap;
        id = UnusedScopeMap.getId();
        if (UnusedScopeMap.isEmpty()) {
            UnusedScopeMap.put("dummy-bean", new Object());
        }
        WindowScopeManager.UnusedScopeMap.activate(state);
        WindowScopeManager.associateWindowID(id, requestMap);
        return id;
    }

    private static boolean isDisposeWindowRequest(Map parameters) {
        return "ice.dispose.window".equals(parameters.get("ice.submit.type"));
    }

    private static synchronized String generateID() {
        return seed + Long.toString(System.currentTimeMillis(), 36);
    }

    public static synchronized void disposeWindow(FacesContext context, String id) {
        State state = WindowScopeManager.getState(context);
        ScopeMap scopeMap = (ScopeMap)state.windowScopedMaps.get(id);
        if (scopeMap != null) {
            scopeMap.disactivate(state);
        }
        WindowScopeManager.disposeViewScopeBeans(context);
    }

    private static void disposeViewScopeBeans(FacesContext facesContext) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        ExceptionHandler oldHandler = facesContext.getExceptionHandler();
        facesContext.setExceptionHandler((ExceptionHandler)new DiscardingExceptionHandler(oldHandler));
        lifecycle.execute(facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (null == viewRoot) {
            return;
        }
        Map viewMap = viewRoot.getViewMap();
        Iterator keys = viewMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object object = viewMap.get(key);
            if (!object.getClass().isAnnotationPresent(WindowDisposed.class)) continue;
            keys.remove();
            WindowScopeManager.callPreDestroy(object);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Closing window disposed ViewScoped bean " + key);
        }
        facesContext.setExceptionHandler(oldHandler);
    }

    private static void callPreDestroy(Object object) {
        Class<?> theClass;
        try {
            for (theClass = object.getClass(); null != theClass; theClass = theClass.getSuperclass()) {
                Method[] methods;
                for (Method method : methods = object.getClass().getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(PreDestroy.class)) continue;
                    method.setAccessible(true);
                    method.invoke(object, new Object[0]);
                    return;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to invoke PreDestroy on " + theClass, e);
        }
    }

    public static String lookupAssociatedWindowID(Map requestMap) {
        return (String)requestMap.get(WindowScopeManager.class.getName());
    }

    private static void associateWindowID(String id, Map requestMap) {
        requestMap.put(WindowScopeManager.class.getName(), id);
    }

    private static State getState(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Object session = externalContext.getSession(false);
        if (session != null) {
            return EnvUtils.instanceofPortletSession(session) ? WindowScopeManager.getPortletState(context, session) : WindowScopeManager.getServletState(context, session);
        }
        return null;
    }

    private static State getServletState(FacesContext context, Object session) {
        HttpSession servletSession = (HttpSession)session;
        State state = (State)servletSession.getAttribute(WindowScopeManager.class.getName());
        if (state == null) {
            state = new State(EnvUtils.getWindowScopeExpiration(context));
            servletSession.setAttribute(WindowScopeManager.class.getName(), (Object)state);
        }
        return state;
    }

    private static State getPortletState(FacesContext context, Object session) {
        PortletSession portletSession = (PortletSession)session;
        State state = (State)portletSession.getAttribute(WindowScopeManager.class.getName(), 1);
        if (state == null) {
            state = new State(EnvUtils.getWindowScopeExpiration(context));
            portletSession.setAttribute(WindowScopeManager.class.getName(), (Object)state, 1);
        }
        return state;
    }

    static /* synthetic */ String access$1000() {
        return WindowScopeManager.generateID();
    }

    static {
        try {
            sharedMapLookupStrategy = new LiferayOriginalRequestWindowScopeSharing();
        }
        catch (Exception e) {
            sharedMapLookupStrategy = new TimeBasedHeuristicWindowScopeSharing();
        }
    }

    static class DiscardingExceptionHandler
    extends ExceptionHandlerWrapper {
        ExceptionHandler wrapped;

        public DiscardingExceptionHandler(ExceptionHandler wrapped) {
            this.wrapped = wrapped;
        }

        public void processEvent(SystemEvent exceptionQueuedEvent) {
            Throwable throwable = ((ExceptionQueuedEvent)exceptionQueuedEvent).getContext().getException();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception during window disposal " + throwable);
            }
        }

        public ExceptionHandler getWrapped() {
            return this.wrapped;
        }
    }

    private static class LiferayOriginalRequestWindowScopeSharing
    implements SharedMapLookupStrategy {
        private Class PortalUtilClass = Class.forName("com.liferay.portal.util.PortalUtil");
        private Method GetHttpServletRequest = this.PortalUtilClass.getDeclaredMethod("getHttpServletRequest", PortletRequest.class);
        private Method GetOriginalServletRequest = this.PortalUtilClass.getDeclaredMethod("getOriginalServletRequest", HttpServletRequest.class);

        private LiferayOriginalRequestWindowScopeSharing() throws ClassNotFoundException, NoSuchMethodException {
        }

        public ScopeMap lookup(FacesContext context) {
            State state = WindowScopeManager.getState(context);
            ExternalContext externalContext = context.getExternalContext();
            HttpServletRequest originalRequest = this.getOriginalServletRequest(externalContext);
            String sharedWindowID = (String)originalRequest.getAttribute(WindowScopeManager.class.getName());
            return sharedWindowID == null ? null : (ScopeMap)state.windowScopedMaps.get(sharedWindowID);
        }

        public void associate(FacesContext context, String windowID) {
            ExternalContext externalContext = context.getExternalContext();
            HttpServletRequest originalRequest = this.getOriginalServletRequest(externalContext);
            originalRequest.setAttribute(WindowScopeManager.class.getName(), (Object)windowID);
        }

        private HttpServletRequest getOriginalServletRequest(ExternalContext externalContext) {
            try {
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                HttpServletRequest httpPortletRequest = (HttpServletRequest)this.GetHttpServletRequest.invoke((Object)this.PortalUtilClass, portletRequest);
                HttpServletRequest originalRequest = (HttpServletRequest)this.GetOriginalServletRequest.invoke((Object)this.PortalUtilClass, httpPortletRequest);
                return originalRequest;
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
    }

    private static class TimeBasedHeuristicWindowScopeSharing
    implements SharedMapLookupStrategy {
        private static final int SameWindowMaxDelay = 500;

        private TimeBasedHeuristicWindowScopeSharing() {
        }

        public ScopeMap lookup(FacesContext context) {
            State state = WindowScopeManager.getState(context);
            for (ScopeMap sm : state.windowScopedMaps.values()) {
                if (sm.activateTimestamp + 500L <= System.currentTimeMillis()) continue;
                return sm;
            }
            return null;
        }

        public void associate(FacesContext context, String windowID) {
        }
    }

    private static interface SharedMapLookupStrategy {
        public ScopeMap lookup(FacesContext var1);

        public void associate(FacesContext var1, String var2);
    }

    private static class State
    implements Externalizable {
        private HashMap windowScopedMaps = new HashMap();
        private LinkedList disposedWindowScopedMaps = new LinkedList();
        public long expirationPeriod;

        public State() {
        }

        private State(long expirationPeriod) {
            this.expirationPeriod = expirationPeriod;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.windowScopedMaps);
            out.writeObject(this.disposedWindowScopedMaps);
            out.writeLong(this.expirationPeriod);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.windowScopedMaps = (HashMap)in.readObject();
            this.disposedWindowScopedMaps = (LinkedList)in.readObject();
            this.expirationPeriod = in.readLong();
        }
    }

    public static class ScopeMap
    extends HashMap {
        private String id = WindowScopeManager.access$1000();
        private long activateTimestamp = System.currentTimeMillis();
        private long deactivateTimestamp = -1L;

        public String getId() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScopeMap(FacesContext facesContext) {
            boolean processingEvents = facesContext.isProcessingEvents();
            try {
                facesContext.setProcessingEvents(true);
                ScopeContext context = new ScopeContext(WindowScopeManager.ScopeName, (Map)this);
                facesContext.getApplication().publishEvent(facesContext, PostConstructCustomScopeEvent.class, (Object)context);
            }
            finally {
                facesContext.setProcessingEvents(processingEvents);
                sharedMapLookupStrategy.associate(facesContext, this.id);
            }
        }

        private void disactivateIfUnused(FacesContext facesContext) {
            if (this.isEmpty()) {
                this.disactivate(WindowScopeManager.getState(facesContext));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void discardIfExpired(FacesContext facesContext) {
            State state = WindowScopeManager.getState(facesContext);
            if (System.currentTimeMillis() > this.deactivateTimestamp + state.expirationPeriod) {
                boolean processingEvents = facesContext.isProcessingEvents();
                try {
                    facesContext.setProcessingEvents(true);
                    ScopeContext context = new ScopeContext(WindowScopeManager.ScopeName, (Map)this);
                    facesContext.getApplication().publishEvent(facesContext, PreDestroyCustomScopeEvent.class, (Object)context);
                }
                finally {
                    state.disposedWindowScopedMaps.remove(this);
                    facesContext.setProcessingEvents(processingEvents);
                }
            }
        }

        private void activate(State state) {
            state.windowScopedMaps.put(this.id, this);
            this.activateTimestamp = System.currentTimeMillis();
        }

        private void disactivate(State state) {
            this.deactivateTimestamp = System.currentTimeMillis();
            state.disposedWindowScopedMaps.addLast(state.windowScopedMaps.remove(this.id));
        }
    }
}

