/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.db2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.db2.DB2Authority;
import org.identityconnectors.db2.DB2AuthorityReader;
import org.identityconnectors.db2.DB2AuthorityTable;
import org.identityconnectors.db2.DB2Configuration;
import org.identityconnectors.db2.DB2FilterTranslator;
import org.identityconnectors.db2.DB2Specifics;
import org.identityconnectors.dbcommon.DatabaseQueryBuilder;
import org.identityconnectors.dbcommon.FilterWhereBuilder;
import org.identityconnectors.dbcommon.SQLUtil;
import org.identityconnectors.framework.common.exceptions.AlreadyExistsException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.AttributeNormalizer;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConnectorClass(displayNameKey="db2.connector", configurationClass=DB2Configuration.class, messageCatalogPaths={"org/identityconnectors/dbcommon/Messages", "org/identityconnectors/db2/Messages"})
public class DB2Connector
implements AuthenticateOp,
SchemaOp,
CreateOp,
SearchOp<FilterWhereBuilder>,
DeleteOp,
UpdateAttributeValuesOp,
TestOp,
PoolableConnector,
AttributeNormalizer {
    private static final Log log = Log.getLog(DB2Connector.class);
    private Connection adminConn;
    private DB2Configuration cfg;
    static final String USER_AUTH_GRANTS = "grants";
    private String testSQL;

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        log.info("Authenticate user: {0}", new Object[]{username});
        Connection conn = null;
        try {
            conn = this.createConnection(username, password);
        }
        catch (RuntimeException e) {
            try {
                SQLException sqlE;
                if (e.getCause() instanceof SQLException && "28000".equals((sqlE = (SQLException)e.getCause()).getSQLState()) && -4214 == sqlE.getErrorCode()) {
                    log.info((Throwable)e, "DB2.authenticate : Invalid user/passord for user: {0}", new Object[]{username});
                    throw new InvalidCredentialException(this.cfg.getConnectorMessages().format("db2.authenticate.invalid.credentials", null, new Object[0]), e.getCause());
                }
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(conn);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((Connection)conn);
        log.info("User authenticated : {0}", new Object[]{username});
        return new Uid(username.toUpperCase());
    }

    public Schema schema() {
        HashSet<AttributeInfo> attrInfoSet = new HashSet<AttributeInfo>();
        attrInfoSet.add(AttributeInfoBuilder.build((String)Name.NAME, String.class, EnumSet.of(AttributeInfo.Flags.NOT_UPDATEABLE, AttributeInfo.Flags.REQUIRED)));
        AttributeInfoBuilder grantsBuilder = new AttributeInfoBuilder();
        grantsBuilder.setName(USER_AUTH_GRANTS).setCreateable(true).setUpdateable(true).setRequired(true).setReadable(true).setMultiValued(true).setReturnedByDefault(true);
        attrInfoSet.add(grantsBuilder.build());
        SchemaBuilder schemaBld = new SchemaBuilder(this.getClass());
        schemaBld.defineObjectClass(ObjectClass.ACCOUNT_NAME, attrInfoSet);
        return schemaBld.build();
    }

    private String getTestSQL() {
        if (this.testSQL != null) {
            return this.testSQL;
        }
        this.testSQL = DB2Specifics.findTestSQL(this.adminConn);
        return this.testSQL;
    }

    public void checkAlive() {
        DB2Specifics.testConnection(this.adminConn, this.getTestSQL());
    }

    public void dispose() {
        SQLUtil.closeQuietly((Connection)this.adminConn);
    }

    public DB2Configuration getConfiguration() {
        return this.cfg;
    }

    public void init(Configuration cfg) {
        this.cfg = (DB2Configuration)cfg;
        this.adminConn = this.createAdminConnection();
    }

    private Connection createAdminConnection() {
        Connection conn = this.cfg.createAdminConnection();
        if (!DB2Configuration.ConnectionType.DATASOURCE.equals((Object)this.cfg.getConnType())) {
            try {
                conn.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new ConnectorException("Cannot switch off autocommit", (Throwable)e);
            }
        }
        return conn;
    }

    private Connection createConnection(String user, GuardedString password) {
        Connection conn = this.cfg.createConnection(user, password);
        return conn;
    }

    List<String> buildAuthorityAttributeValue(String userName) {
        DB2AuthorityReader dB2AuthorityReader = new DB2AuthorityReader(this.adminConn);
        Collection<DB2Authority> allAuths = null;
        try {
            allAuths = dB2AuthorityReader.readAllAuthorities(userName);
        }
        catch (SQLException e) {
            throw new ConnectorException("Error reading db2 authorities", (Throwable)e);
        }
        ArrayList<String> result = new ArrayList<String>(2);
        for (DB2Authority authority : allAuths) {
            DB2AuthorityTable authorityTable = DB2Specifics.authType2DB2AuthorityTable(authority.authorityType);
            String grantString = authorityTable.generateGrant(authority);
            result.add(grantString);
        }
        return result;
    }

    public FilterTranslator<FilterWhereBuilder> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        return new DB2FilterTranslator(oclass, options);
    }

    public void executeQuery(ObjectClass oclass, FilterWhereBuilder where, ResultsHandler handler, OperationOptions options) {
        this.checkObjectClass(oclass);
        String ALL_USER_QUERY = "SELECT GRANTEE FROM SYSIBM.SYSDBAUTH WHERE GRANTEETYPE = 'U' AND CONNECTAUTH = 'Y'";
        DatabaseQueryBuilder query = new DatabaseQueryBuilder("SELECT GRANTEE FROM SYSIBM.SYSDBAUTH WHERE GRANTEETYPE = 'U' AND CONNECTAUTH = 'Y'");
        query.setWhere(where);
        String sql = query.getSQL();
        log.info("Executing search query : {0}", new Object[]{sql});
        ResultSet result = null;
        PreparedStatement statement = null;
        try {
            statement = this.adminConn.prepareStatement(sql);
            SQLUtil.setParams((PreparedStatement)statement, (List)query.getParams());
            result = statement.executeQuery();
            while (result.next()) {
                ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
                String userName = result.getString("GRANTEE").trim();
                List<String> authStrings = this.buildAuthorityAttributeValue(userName);
                bld.addAttribute(USER_AUTH_GRANTS, authStrings);
                bld.setUid(new Uid(userName));
                bld.setName(userName);
                bld.setObjectClass(ObjectClass.ACCOUNT);
                ConnectorObject ret = bld.build();
                if (handler.handle(ret)) continue;
            }
        }
        catch (SQLException e) {
            try {
                throw new ConnectorException(this.cfg.getConnectorMessages().format("db2.search.failed", null, new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(result);
                SQLUtil.closeQuietly((Statement)statement);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)result);
        SQLUtil.closeQuietly((Statement)statement);
    }

    private void checkObjectClass(ObjectClass oclass) {
        if (!ObjectClass.ACCOUNT.equals((Object)oclass)) {
            throw new IllegalArgumentException(this.cfg.getConnectorMessages().format("db2.unsupported.object.class", null, new Object[]{oclass}));
        }
    }

    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        this.checkObjectClass(oclass);
        this.checkCreateAttributes(attrs);
        Name user = AttributeUtil.getNameFromAttributes(attrs);
        if (user == null || StringUtil.isBlank((String)user.getNameValue())) {
            throw new IllegalArgumentException(this.cfg.getConnectorMessages().format("db2.name.is.null.or.empty", null, new Object[0]));
        }
        String userName = user.getNameValue();
        log.info("Creating user : {0}", new Object[]{userName});
        this.checkUserNotExist(userName);
        this.checkDB2Validity(userName);
        try {
            this.updateAuthority(userName, attrs, UpdateType.ADD);
            this.adminConn.commit();
            log.info("User created : {0}", new Object[]{userName});
        }
        catch (Exception e) {
            SQLUtil.rollbackQuietly((Connection)this.adminConn);
            throw new ConnectorException(this.cfg.getConnectorMessages().format("db2.create.of.user.failed", null, new Object[]{userName}), (Throwable)e);
        }
        return new Uid(userName);
    }

    private void checkCreateAttributes(Set<Attribute> attrs) {
        for (Attribute attribute : attrs) {
            if (attribute.is(Name.NAME) || attribute.is(USER_AUTH_GRANTS)) continue;
            throw new IllegalArgumentException(MessageFormat.format("Unrecognized argument [{0}] in DB2 create operation", attribute.getName()));
        }
    }

    private void checkUpdateAttributes(Set<Attribute> attrs) {
        for (Attribute attribute : attrs) {
            if (attribute.is(Uid.NAME) || attribute.is(USER_AUTH_GRANTS)) continue;
            throw new IllegalArgumentException(MessageFormat.format("Unrecognized argument [{0}] in DB2 update operation", attribute.getName()));
        }
    }

    private void checkUserNotExist(String user) {
        boolean userExist = this.userExist(user);
        if (userExist) {
            throw new AlreadyExistsException(this.cfg.getConnectorMessages().format("db2.user.already.exists", null, new Object[]{user}));
        }
    }

    private void checkUserExist(String user) {
        boolean userExist = this.userExist(user);
        if (!userExist) {
            throw new UnknownUidException(new Uid(user), ObjectClass.ACCOUNT);
        }
    }

    private boolean userExist(String user) {
        boolean bl;
        String ALL_USER_QUERY = "SELECT GRANTEE FROM SYSIBM.SYSDBAUTH WHERE GRANTEETYPE = 'U' AND CONNECTAUTH = 'Y' AND TRIM(GRANTEE) = ?";
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.adminConn.prepareStatement("SELECT GRANTEE FROM SYSIBM.SYSDBAUTH WHERE GRANTEETYPE = 'U' AND CONNECTAUTH = 'Y' AND TRIM(GRANTEE) = ?");
            st.setString(1, user.toUpperCase());
            rs = st.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new ConnectorException("Cannot test whether user exist", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtil.closeQuietly(rs);
                SQLUtil.closeQuietly((Statement)st);
                throw throwable;
            }
        }
        SQLUtil.closeQuietly((ResultSet)rs);
        SQLUtil.closeQuietly((Statement)st);
        return bl;
    }

    private void updateAuthority(String user, Set<Attribute> attrs, UpdateType type) throws SQLException {
        this.checkAdminConnection();
        Attribute wsAttr = AttributeUtil.find((String)USER_AUTH_GRANTS, attrs);
        ArrayList<String> grants = wsAttr != null ? new ArrayList<String>(wsAttr.getValue()) : new ArrayList(3);
        switch (type) {
            case ADD: {
                this.addMandatoryConnect(grants);
                this.executeGrants(grants, user);
                break;
            }
            case REPLACE: {
                this.addMandatoryConnect(grants);
                this.revokeAllGrants(user);
                this.executeGrants(grants, user);
                break;
            }
            case DELETE: {
                this.removeMandatoryRevoke(grants);
                this.executeRevokes(grants, user);
            }
        }
    }

    private void addMandatoryConnect(Collection<String> grants) {
        boolean addConnect = true;
        for (String grant : grants) {
            if (!grant.trim().equalsIgnoreCase("CONNECT ON DATABASE")) continue;
            addConnect = false;
        }
        if (addConnect) {
            grants.add("CONNECT ON DATABASE");
        }
    }

    private void removeMandatoryRevoke(Collection<String> grants) {
        Iterator<String> i = grants.iterator();
        while (i.hasNext()) {
            if (!i.next().trim().equalsIgnoreCase("CONNECT ON DATABASE")) continue;
            i.remove();
        }
    }

    private void checkAdminConnection() {
        if (this.adminConn == null) {
            throw new IllegalStateException("No admin connection present");
        }
    }

    void checkDB2Validity(String accountID) {
        if (accountID.length() > 30) {
            throw new IllegalArgumentException(this.cfg.getConnectorMessages().format("db2.username.long", null, new Object[]{30}));
        }
        if (DB2Specifics.containsIllegalDB2Chars(accountID.toCharArray())) {
            throw new IllegalArgumentException(this.cfg.getConnectorMessages().format("db2.username.contains.illegal.characters", null, new Object[0]));
        }
        if (DB2Specifics.isReservedName(accountID.toUpperCase())) {
            throw new IllegalArgumentException(this.cfg.getConnectorMessages().format("db2.username.is.reserved.word", null, new Object[0]));
        }
        if (DB2Specifics.hasInvalidPrefix(accountID.toUpperCase())) {
            throw new IllegalArgumentException(this.cfg.getConnectorMessages().format("db2.username.has.invalid.prefix", null, new Object[0]));
        }
    }

    private void revokeAllGrants(String user) throws SQLException {
        this.checkDB2Validity(user);
        Collection<DB2Authority> allAuthorities = new DB2AuthorityReader(this.adminConn).readAllAuthorities(user);
        this.revokeGrants(allAuthorities);
    }

    private void revokeGrants(Collection<DB2Authority> db2AuthoritiesToRevoke) throws SQLException {
        for (DB2Authority auth : db2AuthoritiesToRevoke) {
            DB2AuthorityTable authTable = DB2Specifics.authType2DB2AuthorityTable(auth.authorityType);
            String revokeSQL = authTable.generateRevokeSQL(auth);
            this.executeSQL(revokeSQL);
        }
    }

    private void executeSQL(String sql) throws SQLException {
        this.checkAdminConnection();
        Statement statement = null;
        try {
            statement = this.adminConn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            log.error((Throwable)e, "Error executing sql {0}", new Object[]{sql});
            throw e;
        }
        finally {
            SQLUtil.closeQuietly((Statement)statement);
        }
    }

    private void executeGrants(Collection<String> grants, String user) throws SQLException {
        for (String grant : grants) {
            String sql = "GRANT " + grant + " TO USER " + user.toUpperCase();
            this.executeSQL(sql);
        }
    }

    private void executeRevokes(Collection<String> grants, String user) throws SQLException {
        for (String grant : grants) {
            String sql = "REVOKE " + grant + " FROM USER " + user.toUpperCase();
            this.executeSQL(sql);
        }
    }

    public void delete(ObjectClass objClass, Uid uid, OperationOptions options) {
        this.checkObjectClass(objClass);
        String uidValue = uid.getUidValue();
        this.checkUserExist(uidValue);
        log.info("Deleting user : {0}", new Object[]{uidValue});
        try {
            this.revokeAllGrants(uidValue);
            this.adminConn.commit();
            log.info("User deleted : {0}", new Object[]{uidValue});
        }
        catch (Exception e) {
            SQLUtil.rollbackQuietly((Connection)this.adminConn);
            throw new ConnectorException(this.cfg.getConnectorMessages().format("db2.delete.of.user.failed", null, new Object[]{uidValue}), (Throwable)e);
        }
    }

    public void test() {
        this.cfg.validate();
        DB2Specifics.testConnection(this.adminConn, this.getTestSQL());
    }

    public Uid update(ObjectClass objclass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        if (this.cfg.isReplaceAllGrantsOnUpdate()) {
            return this.update(UpdateType.REPLACE, objclass, (Set<Attribute>)AttributeUtil.addUid(attrs, (Uid)uid), options);
        }
        return this.update(UpdateType.ADD, objclass, (Set<Attribute>)AttributeUtil.addUid(attrs, (Uid)uid), options);
    }

    public Uid addAttributeValues(ObjectClass objclass, Uid uid, Set<Attribute> valuesToAdd, OperationOptions options) {
        return this.update(UpdateType.ADD, objclass, (Set<Attribute>)AttributeUtil.addUid(valuesToAdd, (Uid)uid), options);
    }

    public Uid removeAttributeValues(ObjectClass objclass, Uid uid, Set<Attribute> valuesToRemove, OperationOptions options) {
        return this.update(UpdateType.DELETE, objclass, (Set<Attribute>)AttributeUtil.addUid(valuesToRemove, (Uid)uid), options);
    }

    private Uid update(UpdateType type, ObjectClass objclass, Set<Attribute> attrs, OperationOptions options) {
        this.checkObjectClass(objclass);
        this.checkUpdateAttributes(attrs);
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        if (name != null) {
            throw new IllegalArgumentException(this.cfg.getConnectorMessages().format("db2.name.is.not.updatable", null, new Object[0]));
        }
        Uid uid = AttributeUtil.getUidAttribute(attrs);
        if (uid == null || StringUtil.isBlank((String)uid.getUidValue())) {
            throw new IllegalArgumentException(this.cfg.getConnectorMessages().format("db2.update.uid.cannot.be.null.or.empty", null, new Object[0]));
        }
        String uidValue = uid.getUidValue();
        this.checkUserExist(uidValue);
        try {
            log.info("Update user : {0}", new Object[]{uidValue});
            this.updateAuthority(uidValue, attrs, type);
            this.adminConn.commit();
            log.info("User updated : {0}", new Object[]{uidValue});
        }
        catch (Exception e) {
            SQLUtil.rollbackQuietly((Connection)this.adminConn);
            throw new ConnectorException(this.cfg.getConnectorMessages().format("db2.update.of.user.failed", null, new Object[]{uidValue}), (Throwable)e);
        }
        return uid;
    }

    public Attribute normalizeAttribute(ObjectClass oclass, Attribute attribute) {
        if (attribute.is(Name.NAME)) {
            String value = (String)attribute.getValue().get(0);
            return new Name(value.trim().toUpperCase());
        }
        if (attribute.is(Uid.NAME)) {
            String value = (String)attribute.getValue().get(0);
            return new Uid(value.trim().toUpperCase());
        }
        if (attribute.is(USER_AUTH_GRANTS)) {
            List grants = attribute.getValue();
            ArrayList<String> upGrants = new ArrayList<String>(grants.size());
            for (Object grant : grants) {
                upGrants.add(grant.toString().toUpperCase());
            }
            return AttributeBuilder.build((String)USER_AUTH_GRANTS, upGrants);
        }
        return attribute;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UpdateType {
        ADD,
        REPLACE,
        DELETE;

    }
}

