/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.spml;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.script.ScriptExecutor;
import org.identityconnectors.common.script.ScriptExecutorFactory;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.AlreadyExistsException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoUtil;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributeInfos;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;
import org.identityconnectors.spml.GuardedStringAccessor;
import org.identityconnectors.spml.SpmlConfiguration;
import org.identityconnectors.spml.SpmlConnection;
import org.identityconnectors.spml.SpmlConnectionFactory;
import org.identityconnectors.spml.SpmlFilterTranslator;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.pass.ExpirePasswordRequest;
import org.openspml.v2.msg.pass.ExpirePasswordResponse;
import org.openspml.v2.msg.pass.SetPasswordRequest;
import org.openspml.v2.msg.pass.SetPasswordResponse;
import org.openspml.v2.msg.spml.AddRequest;
import org.openspml.v2.msg.spml.AddResponse;
import org.openspml.v2.msg.spml.Capability;
import org.openspml.v2.msg.spml.DeleteRequest;
import org.openspml.v2.msg.spml.DeleteResponse;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.ExecutionMode;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.ListTargetsRequest;
import org.openspml.v2.msg.spml.ListTargetsResponse;
import org.openspml.v2.msg.spml.LookupRequest;
import org.openspml.v2.msg.spml.LookupResponse;
import org.openspml.v2.msg.spml.Modification;
import org.openspml.v2.msg.spml.ModificationMode;
import org.openspml.v2.msg.spml.ModifyRequest;
import org.openspml.v2.msg.spml.ModifyResponse;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.QueryClause;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.Schema;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.msg.spml.Target;
import org.openspml.v2.msg.spmlsearch.CloseIteratorRequest;
import org.openspml.v2.msg.spmlsearch.IterateRequest;
import org.openspml.v2.msg.spmlsearch.IterateResponse;
import org.openspml.v2.msg.spmlsearch.Query;
import org.openspml.v2.msg.spmlsearch.ResultsIterator;
import org.openspml.v2.msg.spmlsearch.Scope;
import org.openspml.v2.msg.spmlsearch.SearchRequest;
import org.openspml.v2.msg.spmlsearch.SearchResponse;
import org.openspml.v2.msg.spmlsuspend.ActiveRequest;
import org.openspml.v2.msg.spmlsuspend.ActiveResponse;
import org.openspml.v2.msg.spmlsuspend.ResumeRequest;
import org.openspml.v2.msg.spmlsuspend.SuspendRequest;
import org.openspml.v2.profiles.DSMLProfileRegistrar;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.profiles.dsml.DSMLModification;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.profiles.dsml.EqualityMatch;
import org.openspml.v2.profiles.dsml.Filter;
import org.openspml.v2.profiles.dsml.FilterItem;
import org.openspml.v2.profiles.spmldsml.AttributeDefinitionReference;
import org.openspml.v2.profiles.spmldsml.AttributeDefinitionReferences;
import org.openspml.v2.profiles.spmldsml.DSMLSchema;
import org.openspml.v2.profiles.spmldsml.ObjectClassDefinition;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.Spml2ExceptionWithResponse;
import org.openspml.v2.util.xml.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConnectorClass(displayNameKey="SPMLConnector", configurationClass=SpmlConfiguration.class)
public class SpmlConnector
implements PoolableConnector,
CreateOp,
DeleteOp,
SearchOp<FilterItem>,
UpdateOp,
SchemaOp,
TestOp {
    private Log log = Log.getLog(SpmlConnector.class);
    private ScriptExecutorFactory _factory;
    private static final ObjectFactory.ProfileRegistrar mDSMLRegistrar = new DSMLProfileRegistrar();
    public static final String PSOID = "psoID";
    protected SpmlConnection _connection;
    protected SpmlConfiguration _configuration;
    private ScriptExecutor _mapAttributeExecutor;
    private ScriptExecutor _mapSetNameExecutor;
    private ScriptExecutor _schemaExecutor;
    private Map<String, String> _objectClassMap;
    private Map<String, String> _targetMap;
    private Map<String, String> _nameAttributeMap;
    private org.identityconnectors.framework.common.objects.Schema _schema;
    private Map<String, Map<String, AttributeInfo>> _oci;

    public SpmlConnector() {
        ObjectFactory.getInstance().register(mDSMLRegistrar);
    }

    public void dispose() {
        if (this._connection != null) {
            this._connection.dispose();
            this._connection = null;
        }
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public void checkAlive() {
        this._connection.test();
    }

    public void init(Configuration configuration) {
        this._configuration = (SpmlConfiguration)configuration;
        this._connection = SpmlConnectionFactory.newConnection(this._configuration);
        this._factory = ScriptExecutorFactory.newInstance((String)this._configuration.getScriptingLanguage());
        String mapAttributeCommand = this._configuration.getMapAttributeCommand();
        String mapSetNameCommand = this._configuration.getMapSetNameCommand();
        String schemaCommand = this._configuration.getSchemaCommand();
        try {
            if (mapAttributeCommand != null && mapAttributeCommand.length() > 0) {
                this._mapAttributeExecutor = this._factory.newScriptExecutor(this.getClass().getClassLoader(), mapAttributeCommand, true);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("MAPATTRIBUTE_SCRIPT_ERROR"), (Throwable)e);
        }
        try {
            if (mapSetNameCommand != null && mapSetNameCommand.length() > 0) {
                this._mapSetNameExecutor = this._factory.newScriptExecutor(this.getClass().getClassLoader(), mapSetNameCommand, true);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("MAPSETNAME_SCRIPT_ERROR"), (Throwable)e);
        }
        try {
            if (schemaCommand != null && schemaCommand.length() > 0) {
                this._schemaExecutor = this._factory.newScriptExecutor(this.getClass().getClassLoader(), schemaCommand, true);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("MAPSCHEMA_SCRIPT_ERROR"), (Throwable)e);
        }
        this._objectClassMap = CollectionUtil.newCaseInsensitiveMap();
        this._targetMap = CollectionUtil.newCaseInsensitiveMap();
        this._nameAttributeMap = CollectionUtil.newCaseInsensitiveMap();
        if (this._configuration.getObjectClassNames() != null) {
            String[] objectClassNames = this._configuration.getObjectClassNames();
            String[] spmlClassNames = this._configuration.getSpmlClassNames();
            String[] targetNames = this._configuration.getTargetNames();
            String[] nameAttributes = this._configuration.getNameAttributes();
            for (int i = 0; i < objectClassNames.length; ++i) {
                this._objectClassMap.put(objectClassNames[i], spmlClassNames[i]);
                this._targetMap.put(objectClassNames[i], targetNames[i]);
                this._nameAttributeMap.put(objectClassNames[i], nameAttributes[i]);
            }
        }
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> attributes, OperationOptions options) {
        try {
            HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>(AttributeUtil.toMap(attributes));
            AddRequest request = new AddRequest();
            Name name = AttributeUtil.getNameFromAttributes(attributes);
            this.log.info("create(''{0}'')", new Object[]{name.getNameValue()});
            request.setTargetId(this.getTargetForObjectClass(objectClass));
            request.setRequestID(this.objectClassAsString(objectClass.getObjectClassValue()) + ":" + name.getNameValue());
            request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
            Attribute enable = (Attribute)attrMap.remove(OperationalAttributes.ENABLE_NAME);
            Attribute disableDate = (Attribute)attrMap.remove(OperationalAttributes.DISABLE_DATE_NAME);
            Attribute enableDate = (Attribute)attrMap.remove(OperationalAttributes.ENABLE_DATE_NAME);
            Attribute expirePassword = (Attribute)attrMap.remove(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME);
            request.setData(this.getCreateAttributes(objectClass, attrMap));
            AddResponse response = (AddResponse)this._connection.send((Request)request);
            Uid uid = null;
            if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                throw new ConnectorException(this.asString(response.getErrorMessages()));
            }
            uid = new Uid(response.getPso().getPsoID().getID());
            this.processEnable(objectClass, uid, enable, disableDate, enableDate);
            this.processExpirePassword(objectClass, uid, expirePassword);
            return uid;
        }
        catch (Spml2ExceptionWithResponse e) {
            this.log.error((Throwable)e, "create failed:''{0}''", new Object[]{e.getResponse().getError()});
            if (e.getResponse().getError() == ErrorCode.ALREADY_EXISTS) {
                throw new AlreadyExistsException();
            }
            throw ConnectorException.wrap((Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "create failed", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    protected String asString(String[] strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (String string : strings) {
            buffer.append("\n" + string);
        }
        return buffer.toString().substring(1);
    }

    protected Extensible getCreateAttributes(ObjectClass objectClass, Map<String, Attribute> attrMap) throws Exception {
        Extensible extensible = new Extensible();
        for (Attribute attribute : attrMap.values()) {
            AttributeInfo attributeInfo;
            Map<String, AttributeInfo> info;
            String name = attribute.getName();
            if (this._oci != null && (info = this._oci.get(objectClass.getObjectClassValue())) != null && (attributeInfo = info.get(name)) != null && !attributeInfo.isCreateable()) {
                throw new IllegalArgumentException(this._configuration.getMessage("ILLEGAL_MODIFICATION", name));
            }
            extensible.addOpenContentElement((OpenContentElement)new DSMLAttr(this.mapSetName(name, objectClass.getObjectClassValue()), this.asDSMLValueArray(attribute)));
        }
        extensible.addOpenContentElement((OpenContentElement)new DSMLAttr("objectclass", this._objectClassMap.get(objectClass.getObjectClassValue())));
        return extensible;
    }

    private DSMLValue[] asDSMLValueArray(Attribute attribute) {
        List values = attribute.getValue();
        if (values == null) {
            throw new IllegalArgumentException(this._configuration.getMessage("NULL_VALUE", attribute.getName()));
        }
        DSMLValue[] array = new DSMLValue[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value instanceof GuardedString) {
                GuardedStringAccessor accessor = new GuardedStringAccessor();
                ((GuardedString)value).access((GuardedString.Accessor)accessor);
                array[i] = new DSMLValue(new String(accessor.getArray()));
                accessor.clear();
                continue;
            }
            if (value == null) {
                throw new IllegalArgumentException(this._configuration.getMessage("NULL_VALUE", attribute.getName()));
            }
            array[i] = new DSMLValue(value.toString());
        }
        return array;
    }

    private List<Object> asValueList(DSMLValue[] values) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (DSMLValue value : values) {
            list.add(value.getValue());
        }
        return list;
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        try {
            DeleteRequest request = new DeleteRequest();
            PSOIdentifier pso = new PSOIdentifier();
            this.log.info("delete(''{0}'')", new Object[]{uid.getUidValue()});
            pso.setID(uid.getUidValue());
            pso.setTargetID(this.getTargetForObjectClass(objectClass));
            request.setPsoID(pso);
            request.setRequestID(uid.getUidValue());
            request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
            DeleteResponse response = (DeleteResponse)this._connection.send((Request)request);
            if (response.getStatus().equals(StatusCode.SUCCESS)) {
                return;
            }
            throw new ConnectorException(this.asString(response.getErrorMessages()));
        }
        catch (Spml2ExceptionWithResponse e) {
            this.log.error((Throwable)e, "delete failed:''{0}''", new Object[]{e.getResponse().getError()});
            throw this.exceptionForId(e.getResponse());
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "delete failed", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public FilterTranslator<FilterItem> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        return new SpmlFilterTranslator(this._configuration, this._connection);
    }

    public void executeQuery(ObjectClass objectClass, FilterItem query, ResultsHandler handler, OperationOptions options) {
        try {
            PSO[] psos;
            Set attributesToGet = null;
            if (options != null && options.getAttributesToGet() != null) {
                attributesToGet = CollectionUtil.newReadOnlySet((Object[])options.getAttributesToGet());
            }
            if (query instanceof EqualityMatch) {
                EqualityMatch equalityMatch = (EqualityMatch)query;
                String name = equalityMatch.getName();
                String value = equalityMatch.getValue().getValue();
                if (name.equals(PSOID) && !value.equals("*")) {
                    try {
                        ConnectorObject object = this.get(new Uid(value), objectClass, this.getTargetForObjectClass(objectClass), attributesToGet);
                        handler.handle(object);
                    }
                    catch (UnknownUidException e) {
                        // empty catch block
                    }
                    return;
                }
            }
            SearchRequest request = new SearchRequest();
            Query spmlQuery = new Query();
            spmlQuery.setScope(Scope.ONELEVEL);
            if (query != null) {
                spmlQuery.addQueryClause((QueryClause)new Filter(query));
            }
            request.setQuery(spmlQuery);
            request.setReturnData(ReturnData.EVERYTHING);
            request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
            this.log.info("search(''{0}'')", new Object[]{spmlQuery});
            SearchResponse response = (SearchResponse)this._connection.send((Request)request);
            if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                throw new ConnectorException(this.asString(response.getErrorMessages()));
            }
            for (PSO pso : psos = response.getPSOs()) {
                this.log.info("search returned ''{0}'' directly", new Object[]{pso.getPsoID().getID()});
                boolean continueQuery = handler.handle(this.buildConnectorObject(pso, objectClass, attributesToGet));
                if (continueQuery) continue;
                this.closeIterator(response.getIterator());
            }
            ResultsIterator iterator = response.getIterator();
            while (iterator != null) {
                IterateRequest iterRequest = new IterateRequest();
                iterRequest.setIterator(iterator);
                iterRequest.setExecutionMode(ExecutionMode.SYNCHRONOUS);
                IterateResponse iterResponse = (IterateResponse)this._connection.send((Request)iterRequest);
                if (!iterResponse.getStatus().equals(StatusCode.SUCCESS)) {
                    throw new ConnectorException(this.asString(iterResponse.getErrorMessages()));
                }
                for (PSO pso : psos = iterResponse.getPSOs()) {
                    this.log.info("search iterator returned ''{0}''", new Object[]{pso.getPsoID().getID()});
                    boolean continueQuery = handler.handle(this.buildConnectorObject(pso, objectClass, attributesToGet));
                    if (continueQuery) continue;
                    this.closeIterator(iterator);
                }
                iterator = iterResponse.getIterator();
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "searchRequest failed", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    SpmlConnection getConnection() {
        return this._connection;
    }

    private String getTargetForObjectClass(ObjectClass objectClass) {
        String key = objectClass.getObjectClassValue();
        if (this._targetMap.containsKey(key)) {
            return this._targetMap.get(key);
        }
        throw new ConnectorException(this._configuration.getMessage("UNSUPPORTED_OBJECTCLASS", objectClass));
    }

    private void closeIterator(ResultsIterator iterator) throws Spml2ExceptionWithResponse, Spml2Exception {
        CloseIteratorRequest ciRequest = new CloseIteratorRequest();
        ciRequest.setIterator(iterator);
        ciRequest.setExecutionMode(ExecutionMode.SYNCHRONOUS);
        this._connection.send((Request)ciRequest);
    }

    private ConnectorObject get(Uid uid, ObjectClass objectClass, String targetId, Set<String> attributesToGet) {
        try {
            LookupRequest request = new LookupRequest();
            PSOIdentifier psoId = new PSOIdentifier();
            psoId.setTargetID(targetId);
            psoId.setID(uid.getUidValue());
            this.log.info("get(''{0}'')", new Object[]{uid.getUidValue()});
            request.setPsoID(psoId);
            request.setRequestID(uid.getUidValue());
            request.setReturnData(ReturnData.EVERYTHING);
            request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
            LookupResponse response = (LookupResponse)this._connection.send((Request)request);
            if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                throw this.exceptionForId((Response)response);
            }
            PSO pso = response.getPso();
            return this.buildConnectorObject(pso, objectClass, attributesToGet);
        }
        catch (Spml2ExceptionWithResponse e) {
            this.log.error((Throwable)e, "get failed:''{0}''", new Object[]{e.getResponse().getError()});
            throw this.exceptionForId(e.getResponse());
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "get failed", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private Attribute getActiveStatus(Uid uid, String targetId) {
        try {
            ActiveRequest request = new ActiveRequest();
            PSOIdentifier psoId = new PSOIdentifier();
            psoId.setTargetID(targetId);
            psoId.setID(uid.getUidValue());
            this.log.info("getActiveStatus(''{0}'')", new Object[]{uid.getUidValue()});
            request.setPsoID(psoId);
            request.setRequestID(uid.getUidValue());
            request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
            ActiveResponse response = (ActiveResponse)this._connection.send((Request)request);
            if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                throw this.exceptionForId((Response)response);
            }
            return AttributeBuilder.build((String)OperationalAttributes.ENABLE_NAME, (Object[])new Object[]{response.getActive()});
        }
        catch (Spml2ExceptionWithResponse e) {
            this.log.error((Throwable)e, "ActiveRequest failed:''{0}''", new Object[]{e.getResponse().getError()});
            throw this.exceptionForId(e.getResponse());
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "ActiveRequest failed", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private ConnectorObject buildConnectorObject(PSO pso, ObjectClass objectClass, Set<String> attributesToGet) throws Exception {
        AttributeInfo enableInfo;
        Map<String, AttributeInfo> infos;
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        Uid uid = new Uid(pso.getPsoID().getID());
        builder.setUid(uid);
        OpenContentElement[] psoElements = pso.getData().getOpenContentElements();
        String name = null;
        for (OpenContentElement element : psoElements) {
            if (!(element instanceof DSMLAttr)) continue;
            DSMLAttr attr = (DSMLAttr)element;
            String attrName = attr.getName();
            if (attrName.equals(this._nameAttributeMap.get(objectClass.getObjectClassValue()))) {
                name = attr.getValues()[0].getValue();
            }
            if (attributesToGet != null && !attrName.equals(Name.NAME) && !attributesToGet.contains(attrName)) continue;
            builder.addAttribute(new Attribute[]{this.mapAttribute(AttributeBuilder.build((String)attrName, this.asValueList(attr.getValues())), objectClass.getObjectClassValue())});
        }
        builder.setObjectClass(objectClass);
        boolean getEnable = false;
        if (attributesToGet != null) {
            getEnable = attributesToGet.contains(OperationalAttributes.ENABLE_NAME);
        }
        if (!getEnable && this._oci != null && (infos = this._oci.get(objectClass.getObjectClassValue())) != null && (enableInfo = infos.get(OperationalAttributes.ENABLE_NAME)) != null) {
            getEnable = enableInfo.isReturnedByDefault();
        }
        if (getEnable) {
            builder.addAttribute(new Attribute[]{this.getActiveStatus(uid, this.getTargetforObjectClass(objectClass))});
        }
        builder.setName(name);
        return builder.build();
    }

    private String getTargetforObjectClass(ObjectClass objectClass) {
        String[] classNames = this._configuration.getObjectClassNames();
        String[] targetNames = this._configuration.getTargetNames();
        for (int i = 0; i < classNames.length; ++i) {
            if (!objectClass.is(classNames[i])) continue;
            return targetNames[i];
        }
        return null;
    }

    private PSOIdentifier getPsoIdentifier(Uid uid, ObjectClass objectClass) {
        PSOIdentifier pso = new PSOIdentifier();
        pso.setID(uid.getUidValue());
        pso.setTargetID(this.getTargetForObjectClass(objectClass));
        return pso;
    }

    public Uid update(ObjectClass obj, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        return this.update(obj, AttributeUtil.addUid(attrs, (Uid)uid), options);
    }

    Uid update(ObjectClass objectClass, Set<Attribute> attributes, OperationOptions options) {
        try {
            HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>(AttributeUtil.toMap(attributes));
            Uid uid = (Uid)attrMap.remove(Uid.NAME);
            Attribute enable = (Attribute)attrMap.remove(OperationalAttributes.ENABLE_NAME);
            Attribute disableDate = (Attribute)attrMap.remove(OperationalAttributes.DISABLE_DATE_NAME);
            Attribute enableDate = (Attribute)attrMap.remove(OperationalAttributes.ENABLE_DATE_NAME);
            this.processEnable(objectClass, uid, enable, disableDate, enableDate);
            Attribute password = (Attribute)attrMap.remove(OperationalAttributes.PASSWORD_NAME);
            this.processPassword(objectClass, uid, password);
            Attribute expirePassword = (Attribute)attrMap.remove(OperationalAttributes.PASSWORD_EXPIRATION_DATE_NAME);
            this.processExpirePassword(objectClass, uid, expirePassword);
            if (attrMap.size() > 0) {
                ModifyRequest request = new ModifyRequest();
                this.setModifications(request, objectClass, attrMap);
                request.setPsoID(this.getPsoIdentifier(uid, objectClass));
                request.setRequestID(uid.getUidValue());
                request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
                request.setReturnData(ReturnData.EVERYTHING);
                this.log.info("update(''{0}''", new Object[]{uid.getUidValue()});
                ModifyResponse response = (ModifyResponse)this._connection.send((Request)request);
                if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                    this.log.error("update failed:''{0}''", new Object[]{response.getError()});
                    throw this.exceptionForId((Response)response);
                }
            }
            return uid;
        }
        catch (Spml2ExceptionWithResponse e) {
            this.log.error((Throwable)e, "update failed:''{0}''", new Object[]{e.getResponse().getError()});
            throw this.exceptionForId(e.getResponse());
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "update failed", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private void processPassword(ObjectClass objectClass, Uid uid, Attribute password) throws Spml2ExceptionWithResponse, Spml2Exception {
        if (password != null) {
            SetPasswordRequest request = new SetPasswordRequest();
            GuardedString passwordGS = AttributeUtil.getGuardedStringValue((Attribute)password);
            GuardedStringAccessor accessor = new GuardedStringAccessor();
            passwordGS.access((GuardedString.Accessor)accessor);
            String passwordString = new String(accessor.getArray());
            accessor.clear();
            request.setPassword(passwordString);
            request.setPsoID(this.getPsoIdentifier(uid, objectClass));
            request.setRequestID(uid.getUidValue());
            request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
            this.log.info("change password(''{0}'')", new Object[]{uid.getUidValue()});
            SetPasswordResponse response = (SetPasswordResponse)this._connection.send((Request)request);
            if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                this.log.error("change password failed:''{0}''", new Object[]{response.getError()});
                throw this.exceptionForId((Response)response);
            }
        }
    }

    private void processExpirePassword(ObjectClass objectClass, Uid uid, Attribute expirePassword) throws Spml2ExceptionWithResponse, Spml2Exception {
        if (expirePassword != null) {
            ExpirePasswordRequest request = new ExpirePasswordRequest();
            request.setRemainingLogins(0);
            request.setPsoID(this.getPsoIdentifier(uid, objectClass));
            request.setRequestID(uid.getUidValue());
            request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
            this.log.info("expire password(''{0}''", new Object[]{uid.getUidValue()});
            ExpirePasswordResponse response = (ExpirePasswordResponse)this._connection.send((Request)request);
            if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                this.log.error("expire password failed:''{0}''", new Object[]{response.getError()});
                throw this.exceptionForId((Response)response);
            }
        }
    }

    private void processEnable(ObjectClass objectClass, Uid uid, Attribute enable, Attribute disableDate, Attribute enableDate) throws Spml2ExceptionWithResponse, Spml2Exception {
        if (enable != null) {
            boolean isEnable = AttributeUtil.getBooleanValue((Attribute)enable);
            if (isEnable) {
                Long date;
                ResumeRequest request = new ResumeRequest();
                Long l = date = enableDate != null ? AttributeUtil.getLongValue((Attribute)enableDate) : null;
                if (date != null) {
                    Date effectiveDate = new Date(date);
                    String dateString = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS").format(effectiveDate);
                    request.setEffectiveDate(dateString);
                }
                request.setPsoID(this.getPsoIdentifier(uid, objectClass));
                request.setRequestID(uid.getUidValue());
                request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
                this.log.info("enable(''{0}'')", new Object[]{uid.getUidValue()});
                Response response = this._connection.send((Request)request);
                if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                    this.log.error("enable failed:''{0}''", new Object[]{response.getError()});
                    throw this.exceptionForId(response);
                }
            } else {
                Long date;
                SuspendRequest request = new SuspendRequest();
                Long l = date = disableDate != null ? AttributeUtil.getLongValue((Attribute)disableDate) : null;
                if (date != null) {
                    Date effectiveDate = new Date(date);
                    String dateString = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS").format(effectiveDate);
                    request.setEffectiveDate(dateString);
                }
                request.setPsoID(this.getPsoIdentifier(uid, objectClass));
                request.setRequestID(uid.getUidValue());
                request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
                this.log.info("disable(''{0}'')", new Object[]{uid.getUidValue()});
                Response response = this._connection.send((Request)request);
                if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                    this.log.error("disable failed:''{0}''", new Object[]{response.getError()});
                    throw this.exceptionForId(response);
                }
            }
        }
    }

    protected void setModifications(ModifyRequest modifyRequest, ObjectClass objectClass, Map<String, Attribute> attributes) throws Exception {
        for (Attribute attribute : attributes.values()) {
            AttributeInfo attributeInfo;
            Map<String, AttributeInfo> info;
            String name = attribute.getName();
            if (this._oci != null && (info = this._oci.get(objectClass.getObjectClassValue())) != null && (attributeInfo = info.get(name)) != null && !attributeInfo.isUpdateable()) {
                throw new IllegalArgumentException(this._configuration.getMessage("ILLEGAL_MODIFICATION", name));
            }
            Modification modification = new Modification();
            modification.addOpenContentElement((OpenContentElement)new DSMLModification(this.mapSetName(name, objectClass.getObjectClassValue()), this.asDSMLValueArray(attribute), ModificationMode.REPLACE));
            modifyRequest.addModification(modification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        SpmlConnection connection = SpmlConnectionFactory.newConnection(this._configuration);
        try {
            connection.test();
        }
        finally {
            connection.dispose();
        }
    }

    public org.identityconnectors.framework.common.objects.Schema schema() {
        SchemaBuilder schemaBuilder = new SchemaBuilder(this.getClass());
        try {
            ListTargetsRequest request = new ListTargetsRequest();
            request.setExecutionMode(ExecutionMode.SYNCHRONOUS);
            this.log.info("listTargets", new Object[0]);
            ListTargetsResponse response = (ListTargetsResponse)this._connection.send((Request)request);
            if (!response.getStatus().equals(StatusCode.SUCCESS)) {
                this.log.error("listTargets failed:''{0}''", new Object[]{response.getError()});
                throw new ConnectorException(this.asString(response.getErrorMessages()));
            }
            Target[] targets = response.getTargets();
            String[] spmlClassNames = this._configuration.getSpmlClassNames();
            String[] objectClassNames = this._configuration.getObjectClassNames();
            int length = spmlClassNames == null ? 0 : spmlClassNames.length;
            for (Target target : targets) {
                Schema[] schemas;
                for (Schema schema : schemas = target.getSchemas()) {
                    for (OpenContentElement element : schema.getOpenContentElements()) {
                        if (!(element instanceof DSMLSchema)) continue;
                        DSMLSchema dsmlSchema = (DSMLSchema)element;
                        for (ObjectClassDefinition ocd : dsmlSchema.getObjectClassDefinitions()) {
                            for (int i = 0; i < length; ++i) {
                                if (!spmlClassNames[i].equals(ocd.getName())) continue;
                                HashSet<AttributeInfo> attributes = new HashSet<AttributeInfo>();
                                AttributeDefinitionReferences refs = ocd.getMemberAttributes();
                                Capability[] capabilities = target.getCapabilities().getCapabilities();
                                this.fillInSchemaForObjectClass(schemaBuilder, objectClassNames[i], refs, attributes, capabilities);
                            }
                        }
                    }
                }
            }
        }
        catch (Spml2ExceptionWithResponse e) {
            this.log.error((Throwable)e, "update failed:''{0}''", new Object[]{e.getResponse().getError()});
            throw new ConnectorException(this.asString(e.getResponse().getErrorMessages()));
        }
        catch (Exception e) {
            this.log.error((Throwable)e, "listTargets failed", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        this._schema = schemaBuilder.build();
        this._oci = CollectionUtil.newCaseInsensitiveMap();
        for (ObjectClassInfo info : this._schema.getObjectClassInfo()) {
            this._oci.put(info.getType(), AttributeInfoUtil.toMap((Collection)info.getAttributeInfo()));
        }
        return this._schema;
    }

    private void fillInSchemaForObjectClass(SchemaBuilder schemaBuilder, String objectClass, AttributeDefinitionReferences refs, Set<AttributeInfo> attributes, Capability[] capabilities) throws Exception {
        for (AttributeDefinitionReference ref : refs.getAttributeDefinitionReferences()) {
            boolean required = false;
            if (ref.getRequired() != null) {
                required = ref.getRequired();
            }
            attributes.add(new AttributeInfoBuilder(ref.getName()).setRequired(required).build());
        }
        boolean searchFound = false;
        for (Capability capability : capabilities) {
            if (capability.getNamespaceURI().toASCIIString().equals("urn:oasis:names:tc:SPML:2:0:password")) {
                attributes.add(OperationalAttributeInfos.PASSWORD);
            }
            if (capability.getNamespaceURI().toASCIIString().equals("urn:oasis:names:tc:SPML:2:0:suspend")) {
                attributes.add(OperationalAttributeInfos.ENABLE);
            }
            if (!capability.getNamespaceURI().toASCIIString().equals("urn:oasis:names:tc:SPML:2:0:search")) continue;
            searchFound = true;
        }
        this.updateSchema(objectClass, attributes);
        ObjectClassInfoBuilder bld = new ObjectClassInfoBuilder();
        bld.setType(objectClass);
        bld.addAllAttributeInfo(attributes);
        ObjectClassInfo objectClassInfo = bld.build();
        schemaBuilder.defineObjectClass(objectClassInfo);
        if (!searchFound) {
            schemaBuilder.removeSupportedObjectClass(SearchOp.class, objectClassInfo);
        }
    }

    private String mapSetName(String name, String objectClass) throws Exception {
        try {
            if (this._mapSetNameExecutor != null) {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("name", name);
                arguments.put("objectClass", objectClass);
                arguments.put("configuration", (Object)this._configuration);
                arguments.put("memory", this._connection.getMemory());
                return (String)this._mapSetNameExecutor.execute(arguments);
            }
            return name;
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("MAPSETNAME_SCRIPT_ERROR"), (Throwable)e);
        }
    }

    private void updateSchema(String objectClass, Set<AttributeInfo> attributeInfos) throws Exception {
        try {
            if (this._schemaExecutor != null) {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("objectClass", objectClass);
                arguments.put("attributeInfos", attributeInfos);
                arguments.put("memory", this._connection.getMemory());
                this._schemaExecutor.execute(arguments);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("MAPSCHEMA_SCRIPT_ERROR"), (Throwable)e);
        }
    }

    private Attribute mapAttribute(Attribute attribute, String objectClass) throws Exception {
        try {
            if (this._mapAttributeExecutor != null) {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("attribute", attribute);
                arguments.put("objectClass", objectClass);
                arguments.put("configuration", (Object)this._configuration);
                arguments.put("memory", this._connection.getMemory());
                return (Attribute)this._mapAttributeExecutor.execute(arguments);
            }
            return attribute;
        }
        catch (Exception e) {
            throw new ConnectorException(this._configuration.getMessage("MAPATTRIBUTE_SCRIPT_ERROR"), (Throwable)e);
        }
    }

    private ConnectorException exceptionForId(Response response) {
        if (response.getError() == ErrorCode.NO_SUCH_IDENTIFIER) {
            return new UnknownUidException();
        }
        return new ConnectorException(this.asString(response.getErrorMessages()));
    }

    private String objectClassAsString(String objectClass) {
        if (this._objectClassMap.containsKey(objectClass)) {
            return this._objectClassMap.get(objectClass);
        }
        throw new ConnectorException(this._configuration.getMessage("UNSUPPORTED_OBJECTCLASS", objectClass));
    }
}

