/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.spml;

import java.net.URL;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.spml.GuardedStringAccessor;
import org.identityconnectors.spml.SpmlConfiguration;
import org.identityconnectors.spml.SpmlConnection;
import org.openspml.v2.client.Spml2Client;

public class SpmlConnectionFactory {
    private static final Log log = Log.getLog(SpmlConnectionFactory.class);

    public static SpmlConnection newConnection(SpmlConfiguration configuration) {
        Spml2Client client = null;
        try {
            URL url = new URL(configuration.getUrl());
            GuardedStringAccessor accessor = new GuardedStringAccessor();
            configuration.getPassword().access((GuardedString.Accessor)accessor);
            String password = new String(accessor.getArray());
            accessor.clear();
            client = new Spml2Client(url.toExternalForm(), configuration.getUserName(), password);
            SpmlConnection connection = new SpmlConnection(client, configuration);
            log.info("created SPML connection to ''{0}''", new Object[]{configuration.getUrl()});
            return connection;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new ConnectorIOException((Throwable)e);
        }
    }
}

