/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.script.ScriptExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptExecutorFactory {
    private static Map<String, Class<?>> _factoryCache;

    private static synchronized Map<String, Class<?>> getFactoryCache() {
        if (_factoryCache == null) {
            _factoryCache = CollectionUtil.newCaseInsensitiveMap();
            List<String> factories = ScriptExecutorFactory.getRegisteredFactories();
            for (String factory : factories) {
                try {
                    Class<?> clazz = Class.forName(factory);
                    ScriptExecutorFactory instance = (ScriptExecutorFactory)clazz.newInstance();
                    String language = instance.getLanguageName();
                    if (_factoryCache.containsKey(language)) continue;
                    _factoryCache.put(language, clazz);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                }
            }
        }
        return _factoryCache;
    }

    private static List<String> getRegisteredFactories() {
        ArrayList<String> result = new ArrayList<String>();
        String path = "META-INF/services/" + ScriptExecutorFactory.class.getName();
        try {
            Enumeration<URL> configFiles = ScriptExecutorFactory.class.getClassLoader().getResources(path);
            while (configFiles.hasMoreElements()) {
                URL configFile = configFiles.nextElement();
                ScriptExecutorFactory.addFactories(configFile, result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFactories(URL configFile, List<String> result) throws IOException {
        InputStream input = configFile.openStream();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            try {
                String line = reader.readLine();
                while (line != null) {
                    int comment = line.indexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, comment);
                    }
                    if (StringUtil.isNotBlank(line = line.trim())) {
                        result.add(line);
                    }
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            input.close();
        }
    }

    public static Set<String> getSupportedLanguages() {
        return Collections.unmodifiableSet(ScriptExecutorFactory.getFactoryCache().keySet());
    }

    public static ScriptExecutorFactory newInstance(String language) throws IllegalArgumentException {
        if (StringUtil.isBlank(language)) {
            throw new IllegalArgumentException("Language must be specified");
        }
        Class<?> clazz = ScriptExecutorFactory.getFactoryCache().get(language);
        if (clazz == null) {
            String MSG = String.format("Language not supported: %s", language);
            throw new IllegalArgumentException(MSG);
        }
        try {
            return (ScriptExecutorFactory)clazz.newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract ScriptExecutor newScriptExecutor(ClassLoader var1, String var2, boolean var3);

    public abstract String getLanguageName();
}

