/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.builder;

import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class AstBuilderTransformation
implements ASTTransformation {
    public void visit(ASTNode[] nodes, SourceUnit sourceUnit) {
        AstBuilderInvocationTrap transformer = new AstBuilderInvocationTrap(sourceUnit.getAST().getImports(), sourceUnit.getAST().getImportPackages(), sourceUnit.getSource(), sourceUnit);
        if (nodes != null) {
            for (ASTNode aSTNode : nodes) {
                if (aSTNode instanceof AnnotationNode || aSTNode instanceof ClassNode) continue;
                aSTNode.visit(transformer);
            }
        }
        if (sourceUnit.getAST() != null) {
            sourceUnit.getAST().visit(transformer);
            if (sourceUnit.getAST().getStatementBlock() != null) {
                sourceUnit.getAST().getStatementBlock().visit(transformer);
            }
            if (sourceUnit.getAST().getClasses() != null) {
                for (ClassNode classNode : sourceUnit.getAST().getClasses()) {
                    if (classNode.getMethods() != null) {
                        for (MethodNode methodNode : classNode.getMethods()) {
                            if (methodNode == null || methodNode.getCode() == null) continue;
                            methodNode.getCode().visit(transformer);
                        }
                    }
                    try {
                        if (classNode.getDeclaredConstructors() != null) {
                            for (MethodNode methodNode : classNode.getDeclaredConstructors()) {
                                if (methodNode == null || methodNode.getCode() == null) continue;
                                methodNode.getCode().visit(transformer);
                            }
                        }
                    }
                    catch (MissingPropertyException ignored) {
                        // empty catch block
                    }
                    if (classNode.getFields() != null) {
                        for (FieldNode fieldNode : classNode.getFields()) {
                            if (fieldNode.getInitialValueExpression() == null) continue;
                            fieldNode.getInitialValueExpression().visit(transformer);
                        }
                    }
                    try {
                        if (classNode.getObjectInitializerStatements() == null) continue;
                        for (Statement statement : classNode.getObjectInitializerStatements()) {
                            if (statement == null) continue;
                            statement.visit(transformer);
                        }
                    }
                    catch (MissingPropertyException ignored) {
                    }
                }
            }
            if (sourceUnit.getAST().getMethods() != null) {
                for (MethodNode node : sourceUnit.getAST().getMethods()) {
                    if (node == null) continue;
                    if (node.getParameters() != null) {
                        for (Parameter parameter : node.getParameters()) {
                            if (parameter == null || parameter.getInitialExpression() == null) continue;
                            parameter.getInitialExpression().visit(transformer);
                        }
                    }
                    if (node.getCode() == null) continue;
                    node.getCode().visit(transformer);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AstBuilderInvocationTrap
    extends CodeVisitorSupport {
        private final List<String> factoryTargets = new ArrayList<String>();
        private final ReaderSource source;
        private final SourceUnit sourceUnit;

        AstBuilderInvocationTrap(List<ImportNode> imports, List<String> importPackages, ReaderSource source, SourceUnit sourceUnit) {
            if (source == null) {
                throw new IllegalArgumentException("Null: source");
            }
            if (sourceUnit == null) {
                throw new IllegalArgumentException("Null: sourceUnit");
            }
            this.source = source;
            this.sourceUnit = sourceUnit;
            this.factoryTargets.add("org.codehaus.groovy.ast.builder.AstBuilder");
            if (imports != null) {
                for (ImportNode importStatement : imports) {
                    if (!"org.codehaus.groovy.ast.builder.AstBuilder".equals(importStatement.getType().getName())) continue;
                    this.factoryTargets.add(importStatement.getAlias());
                }
            }
            if (importPackages.contains("org.codehaus.groovy.ast.builder.")) {
                this.factoryTargets.add("AstBuilder");
            }
        }

        private void addError(String msg, ASTNode expr) {
            int line = expr.getLineNumber();
            int col = expr.getColumnNumber();
            this.sourceUnit.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', line, col), this.sourceUnit));
        }

        @Override
        public void visitMethodCallExpression(MethodCallExpression call) {
            if (this.isBuildInvocation(call)) {
                ClosureExpression closureExpression = this.getClosureArgument(call);
                List<Expression> otherArgs = this.getNonClosureArguments(call);
                String source = this.convertClosureToSource(closureExpression);
                otherArgs.add(new ConstantExpression(source));
                call.setArguments(new ArgumentListExpression(otherArgs));
                call.setMethod(new ConstantExpression("buildFromBlock"));
                call.setSpreadSafe(false);
                call.setSafe(false);
                call.setImplicitThis(false);
            } else {
                call.getObjectExpression().visit(this);
                call.getMethod().visit(this);
                call.getArguments().visit(this);
            }
        }

        private List<Expression> getNonClosureArguments(MethodCallExpression call) {
            ArrayList<Expression> result = new ArrayList<Expression>();
            if (call.getArguments() instanceof TupleExpression) {
                for (ASTNode aSTNode : ((TupleExpression)call.getArguments()).getExpressions()) {
                    if (aSTNode instanceof ClosureExpression) continue;
                    result.add((Expression)aSTNode);
                }
            }
            return result;
        }

        private ClosureExpression getClosureArgument(MethodCallExpression call) {
            if (call.getArguments() instanceof TupleExpression) {
                for (ASTNode aSTNode : ((TupleExpression)call.getArguments()).getExpressions()) {
                    if (!(aSTNode instanceof ClosureExpression)) continue;
                    return (ClosureExpression)aSTNode;
                }
            }
            return null;
        }

        private boolean isBuildInvocation(MethodCallExpression call) {
            String name;
            if (call == null) {
                throw new IllegalArgumentException("Null: call");
            }
            if (call.getMethod() instanceof ConstantExpression && "buildFromCode".equals(((ConstantExpression)call.getMethod()).getValue()) && call.getObjectExpression() != null && call.getObjectExpression().getType() != null && (name = call.getObjectExpression().getType().getName()) != null && !"".equals(name) && this.factoryTargets.contains(name) && call.getArguments() != null && call.getArguments() instanceof TupleExpression && ((TupleExpression)call.getArguments()).getExpressions() != null) {
                for (ASTNode aSTNode : ((TupleExpression)call.getArguments()).getExpressions()) {
                    if (!(aSTNode instanceof ClosureExpression)) continue;
                    return true;
                }
            }
            return false;
        }

        private String convertClosureToSource(ClosureExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Null: expression");
            }
            StringBuilder result = new StringBuilder();
            for (int x = expression.getLineNumber(); x <= expression.getLastLineNumber(); ++x) {
                String line = this.source.getLine(x, null);
                if (line == null) {
                    this.addError("Error calculating source code for expression. Trying to read line " + x + " from " + this.source.getClass(), expression);
                }
                if (x == expression.getLastLineNumber()) {
                    line = line.substring(0, expression.getLastColumnNumber() - 1);
                }
                if (x == expression.getLineNumber()) {
                    line = line.substring(expression.getColumnNumber() - 1);
                }
                result.append(line).append('\n');
            }
            String source = result.toString().trim();
            if (!source.startsWith("{")) {
                this.addError("Error converting ClosureExpression into source code. Closures must start with {. Found: " + source, expression);
            }
            return source;
        }
    }
}

