/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext;

import com.icesoft.faces.component.ext.ClickActionEvent;
import com.icesoft.faces.component.ext.HtmlDataTable;
import com.icesoft.faces.component.ext.RowSelectorActionEvent;
import com.icesoft.faces.component.ext.RowSelectorEvent;
import com.icesoft.faces.component.ext.UIColumns;
import com.icesoft.faces.component.ext.renderkit.TableRenderer;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class RowSelector
extends UIPanel {
    private Boolean value;
    private Boolean toggleOnClick;
    private Boolean toggleOnInput;
    private Boolean multiple;
    private Boolean enhancedMultiple;
    private String mouseOverClass;
    private String selectedClass;
    private String selectedMouseOverClass;
    private MethodBinding selectionListener;
    private MethodBinding selectionAction;
    private MethodBinding clickListener;
    private MethodBinding clickAction;
    private Integer clickedRow;
    private Boolean immediate;
    private Integer dblClickDelay;
    private Boolean preStyleOnSelection;
    private String renderedOnUserRole = null;
    private transient List selectedRowsList = new ArrayList();
    private Boolean keyboardNavigationEnabled;
    private Boolean singleRowAutoSelect;
    public static final String COMPONENT_TYPE = "com.icesoft.faces.RowSelector";
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.RowSelectorFamily";
    public static final int DEFAULT_DBLCLICK_DELAY = 200;
    private List currentSelection = new ArrayList();
    private String styleClass;

    public RowSelector() {
        JavascriptContext.includeLib(JavascriptContext.ICE_EXTRAS, this.getFacesContext());
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Boolean getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.value != null) {
            return this.value;
        }
        return Boolean.FALSE;
    }

    public void setValue(Boolean value) {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)value);
        } else {
            this.value = value;
        }
        try {
            this.updateCurrentSelection(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateCurrentSelection(Boolean value) {
        HtmlDataTable dataTable = RowSelector.getParentDataTable((UIComponent)this);
        int rowindex = dataTable.getRowIndex();
        if (value.booleanValue()) {
            this.currentSelection.add(new Integer(rowindex));
        } else {
            this.currentSelection.remove(new Integer(rowindex));
        }
    }

    public Integer getClickedRow() {
        ValueBinding vb = this.getValueBinding("clickedRow");
        if (vb != null) {
            return (Integer)vb.getValue(this.getFacesContext());
        }
        if (this.clickedRow != null) {
            return this.clickedRow;
        }
        return new Integer(-1);
    }

    public void setClickedRow(Integer clickedRow) {
        ValueBinding vb = this.getValueBinding("clickedRow");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)clickedRow);
        } else {
            this.clickedRow = clickedRow;
        }
    }

    public boolean isEnhancedMultiple() {
        if (this.enhancedMultiple != null) {
            return this.enhancedMultiple;
        }
        ValueBinding vb = this.getValueBinding("enhancedMultiple");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setEnhancedMultiple(boolean enhancedMultiple) {
        this.enhancedMultiple = new Boolean(enhancedMultiple);
    }

    public Boolean getMultiple() {
        ValueBinding vb = this.getValueBinding("multiple");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.multiple != null) {
            return this.multiple;
        }
        return Boolean.FALSE;
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
    }

    public Boolean getToggleOnClick() {
        ValueBinding vb = this.getValueBinding("toggleOnClick");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.toggleOnClick != null) {
            return this.toggleOnClick;
        }
        return Boolean.TRUE;
    }

    public void setToggleOnClick(Boolean toggleOnClick) {
        this.toggleOnClick = toggleOnClick;
    }

    public Boolean getToggleOnInput() {
        ValueBinding vb = this.getValueBinding("toggleOnInput");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.toggleOnInput != null) {
            return this.toggleOnInput;
        }
        return Boolean.TRUE;
    }

    public void setToggleOnInput(Boolean toggleOnInput) {
        this.toggleOnInput = toggleOnInput;
    }

    public String getMouseOverClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.mouseOverClass, "MouseOver", "mouseOverClass");
    }

    public void setMouseOverClass(String mouseOverClass) {
        this.mouseOverClass = mouseOverClass;
    }

    public String getSelectedClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.selectedClass, "Selected", "selectedClass");
    }

    public void setSelectedClass(String selectedClass) {
        this.selectedClass = selectedClass;
    }

    public String getSelectedMouseOverClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.selectedMouseOverClass, "SelectedMouseOver", "selectedMouseOverClass");
    }

    public void setSelectedMouseOverClass(String selectedMouseOverClass) {
        this.selectedMouseOverClass = selectedMouseOverClass;
    }

    public MethodBinding getSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(MethodBinding selectionListener) {
        this.selectionListener = selectionListener;
    }

    public MethodBinding getSelectionAction() {
        return this.selectionAction;
    }

    public void setSelectionAction(MethodBinding selectionListener) {
        this.selectionAction = selectionListener;
    }

    public MethodBinding getClickListener() {
        return this.clickListener;
    }

    public void setClickListener(MethodBinding clickListener) {
        this.clickListener = clickListener;
    }

    public MethodBinding getClickAction() {
        return this.clickAction;
    }

    public void setClickAction(MethodBinding clickAction) {
        this.clickAction = clickAction;
    }

    public Integer getDblClickDelay() {
        ValueBinding vb = this.getValueBinding("dblClickDelay");
        if (vb != null) {
            return (Integer)vb.getValue(this.getFacesContext());
        }
        if (this.dblClickDelay != null) {
            return this.dblClickDelay;
        }
        return new Integer(200);
    }

    public void setDblClickDelay(Integer dblClickDelay) {
        ValueBinding vb = this.getValueBinding("dblClickDelay");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)dblClickDelay);
        } else {
            this.dblClickDelay = dblClickDelay;
        }
    }

    public Boolean getImmediate() {
        if (this.immediate != null) {
            return this.immediate;
        }
        ValueBinding vb = this.getValueBinding("immediate");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        return Boolean.TRUE;
    }

    public void setImmediate(Boolean immediate) {
        this.immediate = immediate;
    }

    public boolean isPreStyleOnSelection() {
        Boolean ret;
        if (this.preStyleOnSelection != null) {
            return this.preStyleOnSelection;
        }
        ValueBinding vb = this.getValueBinding("preStyleOnSelection");
        if (vb != null && (ret = (Boolean)vb.getValue(this.getFacesContext())) != null) {
            return ret;
        }
        return false;
    }

    public void setPreStyleOnSelection(boolean preStyleOnSelection) {
        this.preStyleOnSelection = new Boolean(preStyleOnSelection);
    }

    public void processDecodes(FacesContext facesContext) {
        block34: {
            HtmlDataTable dataTable = RowSelector.getParentDataTable((UIComponent)this);
            String dataTableId = dataTable.getClientId(facesContext);
            String selectedRowsParameter = TableRenderer.getSelectedRowParameterName(dataTableId);
            Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
            String selectedRows = (String)requestMap.get(selectedRowsParameter);
            boolean isCtrlKey = "true".equals(requestMap.get(selectedRowsParameter + "ctrKy"));
            boolean isShiftKey = "true".equals(requestMap.get(selectedRowsParameter + "sftKy"));
            String clickedRowParameter = TableRenderer.getClickedRowParameterName(dataTableId);
            String clickCountParameter = TableRenderer.getClickCountParameterName(dataTableId);
            String clickedRowIndex = (String)requestMap.get(clickedRowParameter);
            String clickCount = (String)requestMap.get(clickCountParameter);
            ClickActionEvent clickActionEvent = null;
            RowSelector rowSelector = this;
            boolean skipSelection = false;
            if (clickedRowIndex != null && clickCount != null && clickedRowIndex.trim().length() != 0 && clickCount.trim().length() != 0) {
                int rowIndex = dataTable.getRowIndex();
                boolean rowClicked = false;
                int row = Integer.parseInt(clickedRowIndex);
                if (row == rowIndex) {
                    if (this.getParent() instanceof UIColumns) {
                        Object servedRow = this.getParent().getAttributes().get("rowServed");
                        if (servedRow != null) {
                            if (String.valueOf(servedRow).equals(String.valueOf(rowIndex))) {
                                return;
                            }
                        } else {
                            this.getParent().getAttributes().put("rowServed", String.valueOf(rowIndex));
                        }
                    }
                    rowClicked = true;
                }
                try {
                    if (rowClicked) {
                        if (rowSelector.getClickListener() != null || rowSelector.getClickAction() != null) {
                            clickActionEvent = this.createClickActionEvent(rowSelector, row, Integer.parseInt(clickCount));
                        }
                        if (Integer.parseInt(clickCount) == 2 && this.getValue().booleanValue()) {
                            skipSelection = true;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (selectedRows == null || selectedRows.trim().length() == 0 || skipSelection) {
                if (null != clickActionEvent) {
                    rowSelector.queueEvent((FacesEvent)clickActionEvent);
                }
                return;
            }
            Integer oldRow = this.getClickedRow();
            int rowIndex = dataTable.getRowIndex();
            boolean rowClicked = false;
            int row = Integer.parseInt(selectedRows);
            if (row == rowIndex) {
                if (this.getParent() instanceof UIColumns) {
                    Object servedRow = this.getParent().getAttributes().get("rowServed");
                    if (servedRow != null) {
                        if (String.valueOf(servedRow).equals(String.valueOf(rowIndex))) {
                            return;
                        }
                    } else {
                        this.getParent().getAttributes().put("rowServed", String.valueOf(rowIndex));
                    }
                }
                rowClicked = true;
            }
            try {
                if (!rowClicked) break block34;
                boolean b = rowSelector.getValue();
                if (this.isEnhancedMultiple()) {
                    if (!isCtrlKey && !isShiftKey || isShiftKey) {
                        b = true;
                        if (!isCtrlKey && !isShiftKey) {
                            this.deselectPreviousSelection((UIData)dataTable, rowIndex);
                        } else if (isShiftKey) {
                            int currentIndex;
                            int oldIndex;
                            if (!isCtrlKey) {
                                this.deselectPreviousSelection((UIData)dataTable, rowIndex);
                            }
                            if (oldIndex > rowIndex) {
                                for (currentIndex = rowIndex; oldIndex >= currentIndex; ++currentIndex) {
                                    dataTable.setRowIndex(currentIndex);
                                    this.setValue(Boolean.TRUE);
                                }
                            } else if (oldIndex < rowIndex) {
                                for (oldIndex = oldRow.intValue(); oldIndex < currentIndex; ++oldIndex) {
                                    dataTable.setRowIndex(oldIndex);
                                    this.setValue(Boolean.TRUE);
                                }
                            }
                            dataTable.setRowIndex(rowIndex);
                        }
                        this._queueEvent(rowSelector, rowIndex, b, clickActionEvent);
                        return;
                    }
                    if (isCtrlKey && !isShiftKey) {
                        b = !b;
                        this._queueEvent(rowSelector, rowIndex, b, clickActionEvent);
                        return;
                    }
                    break block34;
                }
                b = !b;
                this._queueEvent(rowSelector, rowIndex, b, clickActionEvent);
                if (!this.getMultiple().booleanValue() && oldRow != null && oldRow >= 0 && oldRow != rowIndex) {
                    dataTable.setRowIndex(oldRow);
                    if (dataTable.isRowAvailable()) {
                        this.setValue(Boolean.FALSE);
                    }
                    dataTable.setRowIndex(rowIndex);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void deselectPreviousSelection(UIData uiData, int rowindex) {
        Integer[] selection = new Integer[this.currentSelection.size()];
        this.currentSelection.toArray(selection);
        for (int i = 0; i < selection.length; ++i) {
            uiData.setRowIndex(selection[i].intValue());
            if (!uiData.isRowAvailable()) continue;
            this.setValue(Boolean.FALSE);
        }
        uiData.setRowIndex(rowindex);
    }

    private static HtmlDataTable getParentDataTable(UIComponent uiComponenent) {
        UIComponent parentComp = uiComponenent.getParent();
        if (parentComp == null) {
            throw new RuntimeException("RowSelectorRenderer: decode. Could not find an Ice:dataTable as a parent componenent");
        }
        if (parentComp instanceof HtmlDataTable) {
            return (HtmlDataTable)parentComp;
        }
        return RowSelector.getParentDataTable(parentComp);
    }

    public void broadcast(FacesEvent event) {
        NavigationHandler nh;
        String outcome;
        Object result;
        FacesContext facesContext;
        super.broadcast(event);
        if (event instanceof RowSelectorEvent) {
            this.setClickedRow(new Integer(((RowSelectorEvent)event).getRow()));
            ((RowSelectorEvent)event).setSelectedRows(this.selectedRowsList);
        }
        if (event instanceof RowSelectorEvent && this.selectionListener != null) {
            this.selectionListener.invoke(this.getFacesContext(), new Object[]{(RowSelectorEvent)event});
        }
        if (event instanceof RowSelectorActionEvent && this.selectionAction != null) {
            try {
                facesContext = this.getFacesContext();
                result = this.selectionAction.invoke(facesContext, null);
                outcome = result != null ? result.toString() : null;
                nh = facesContext.getApplication().getNavigationHandler();
                nh.handleNavigation(facesContext, this.selectionAction.getExpressionString(), outcome);
                facesContext.renderResponse();
            }
            catch (MethodNotFoundException e) {
                throw new FacesException(this.selectionAction.getExpressionString() + ": " + e.getMessage(), (Throwable)e);
            }
            catch (EvaluationException e) {
                throw new FacesException(this.selectionAction.getExpressionString() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (event instanceof ClickActionEvent && this.clickListener != null) {
            this.clickListener.invoke(this.getFacesContext(), new Object[]{(ClickActionEvent)event});
        }
        if (event instanceof ClickActionEvent && this.clickAction != null) {
            try {
                facesContext = this.getFacesContext();
                result = this.clickAction.invoke(facesContext, null);
                outcome = result != null ? result.toString() : null;
                nh = facesContext.getApplication().getNavigationHandler();
                nh.handleNavigation(facesContext, this.clickAction.getExpressionString(), outcome);
                facesContext.renderResponse();
            }
            catch (MethodNotFoundException e) {
                throw new FacesException(this.clickAction.getExpressionString() + ": " + e.getMessage(), (Throwable)e);
            }
            catch (EvaluationException e) {
                throw new FacesException(this.clickAction.getExpressionString() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        this.selectedRowsList.clear();
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.value, this.multiple, this.toggleOnClick, this.toggleOnInput, this.clickedRow, this.mouseOverClass, this.selectedClass, this.selectedMouseOverClass, RowSelector.saveAttachedState((FacesContext)context, (Object)this.selectionListener), RowSelector.saveAttachedState((FacesContext)context, (Object)this.selectionAction), this.immediate, this.styleClass, this.enhancedMultiple, RowSelector.saveAttachedState((FacesContext)context, (Object)this.clickListener), RowSelector.saveAttachedState((FacesContext)context, (Object)this.clickAction), this.dblClickDelay, this.preStyleOnSelection, this.renderedOnUserRole, this.keyboardNavigationEnabled, this.singleRowAutoSelect, this.currentSelection};
        return state;
    }

    public void restoreState(FacesContext context, Object stateIn) {
        Object[] state = (Object[])stateIn;
        super.restoreState(context, state[0]);
        this.value = (Boolean)state[1];
        this.multiple = (Boolean)state[2];
        this.toggleOnClick = (Boolean)state[3];
        this.toggleOnInput = (Boolean)state[4];
        this.clickedRow = (Integer)state[5];
        this.mouseOverClass = (String)state[6];
        this.selectedClass = (String)state[7];
        this.selectedMouseOverClass = (String)state[8];
        this.selectionListener = (MethodBinding)RowSelector.restoreAttachedState((FacesContext)context, (Object)state[9]);
        this.selectionAction = (MethodBinding)RowSelector.restoreAttachedState((FacesContext)context, (Object)state[10]);
        this.immediate = (Boolean)state[11];
        this.styleClass = (String)state[12];
        this.enhancedMultiple = (Boolean)state[13];
        this.clickListener = (MethodBinding)RowSelector.restoreAttachedState((FacesContext)context, (Object)state[14]);
        this.clickAction = (MethodBinding)RowSelector.restoreAttachedState((FacesContext)context, (Object)state[15]);
        this.dblClickDelay = (Integer)state[16];
        this.preStyleOnSelection = (Boolean)state[17];
        this.renderedOnUserRole = (String)state[18];
        this.keyboardNavigationEnabled = (Boolean)state[19];
        this.singleRowAutoSelect = (Boolean)state[20];
        this.currentSelection = (List)state[21];
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceRowSel", "styleClass");
    }

    void _queueEvent(RowSelector rowSelector, int rowIndex, boolean isSelected, ClickActionEvent clickActionEvent) {
        rowSelector.setValue(new Boolean(isSelected));
        if (isSelected) {
            this.selectedRowsList.add(new Integer(rowIndex));
        }
        RowSelectorEvent evt = new RowSelectorEvent((UIComponent)rowSelector, rowIndex, isSelected);
        if (this.getImmediate().booleanValue()) {
            evt.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else {
            evt.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
        rowSelector.queueEvent(evt);
        if (null != clickActionEvent) {
            clickActionEvent.setRowSelectorEvent(evt);
            rowSelector.queueEvent((FacesEvent)clickActionEvent);
        }
        if (rowSelector.getSelectionAction() != null) {
            RowSelectorActionEvent actevt = new RowSelectorActionEvent((UIComponent)this);
            if (this.getImmediate().booleanValue()) {
                actevt.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                actevt.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            rowSelector.queueEvent((FacesEvent)actevt);
        }
    }

    private ClickActionEvent createClickActionEvent(RowSelector rowSelector, int rowIndex, int clickCount) {
        ClickActionEvent evt = new ClickActionEvent((UIComponent)rowSelector, rowIndex, clickCount);
        if (this.getImmediate().booleanValue()) {
            evt.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else {
            evt.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
        return evt;
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public boolean isKeyboardNavigationEnabled() {
        if (this.keyboardNavigationEnabled != null) {
            return this.keyboardNavigationEnabled;
        }
        ValueBinding vb = this.getValueBinding("keyboardNavigationEnabled");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : true;
    }

    public void setKeyboardNavigationEnabled(boolean keyboardNavigationEnabled) {
        this.keyboardNavigationEnabled = new Boolean(keyboardNavigationEnabled);
    }

    public boolean isSingleRowAutoSelect() {
        if (this.singleRowAutoSelect != null) {
            return this.singleRowAutoSelect;
        }
        ValueBinding vb = this.getValueBinding("singleRowAutoSelect");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : false;
    }

    public void setSingleRowAutoSelect(boolean singleRowAutoSelect) {
        this.singleRowAutoSelect = new Boolean(singleRowAutoSelect);
    }
}

