/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.dataexporter;

import com.icesoft.faces.component.dataexporter.OutputTypeHandler;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.faces.context.FacesContext;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class ExcelOutputHandler
extends OutputTypeHandler {
    WritableSheet sheet = null;
    WritableWorkbook workbook = null;

    public ExcelOutputHandler(String path, FacesContext fc, String title) {
        super(path);
        try {
            WorkbookSettings settings = new WorkbookSettings();
            settings.setLocale(fc.getViewRoot().getLocale());
            this.workbook = Workbook.createWorkbook((File)super.getFile());
            this.sheet = this.workbook.createSheet(title, 0);
            this.mimeType = "application/vnd.ms-excel";
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void flushFile() {
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (WriteException ioe) {
            ioe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void writeCell(Object output, int col, int row) {
        WritableCellFormat format = this.getCellFormat();
        WritableCell cell = this.deriveCellFromObject(output, col, row + 1, format);
        this.addCell(cell);
    }

    public void writeHeaderCell(String text, int col) {
        WritableCellFormat format = this.getHeaderCellFormat();
        WritableCell cell = this.deriveCellFromObject(text, col, 0, format);
        this.addCell(cell);
    }

    public void writeFooterCell(Object output, int col, int row) {
        WritableCellFormat format = this.getFooterCellFormat();
        WritableCell cell = this.deriveCellFromObject(output, col, row + 1, format);
        this.addCell(cell);
    }

    protected WritableCell deriveCellFromObject(Object output, int col, int row, WritableCellFormat format) {
        Object cell = null;
        cell = output == null ? new Blank(col, row) : (output instanceof String ? new Label(col, row, (String)output) : (output instanceof Double ? new Number(col, row, ((Double)output).doubleValue()) : (output instanceof Date ? new DateTime(col, row, (Date)output) : (output instanceof java.lang.Boolean ? new Boolean(col, row, ((java.lang.Boolean)output).booleanValue()) : new Label(col, row + 1, (String)output)))));
        if (cell != null && format != null) {
            cell.setCellFormat((CellFormat)format);
        }
        return cell;
    }

    protected void addCell(WritableCell cell) {
        try {
            this.sheet.addCell(cell);
        }
        catch (WriteException we) {
            System.out.println("Could not write excel cell");
            we.printStackTrace();
        }
    }

    protected WritableCellFormat getHeaderCellFormat() {
        WritableFont font = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat format = new WritableCellFormat(font);
        return format;
    }

    protected WritableCellFormat getCellFormat() {
        return null;
    }

    protected WritableCellFormat getFooterCellFormat() {
        WritableFont font = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat format = new WritableCellFormat(font);
        return format;
    }
}

