/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.dataexporter;

import com.icesoft.faces.component.dataexporter.DataExporter;
import com.icesoft.faces.renderkit.dom_html_basic.BaseRenderer;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class DataExporterRenderer
extends BaseRenderer {
    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        if (requestMap.containsKey("ice.event.captured") && clientId.equals(requestMap.get("ice.event.captured"))) {
            uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        DataExporter dataExporter = (DataExporter)uiComponent;
        String label = dataExporter.getLabel();
        String image = dataExporter.getImage();
        boolean renderLabelAsButton = dataExporter.isRenderLabelAsButton();
        boolean linkRequired = false;
        String type = dataExporter.getType();
        if (type != null && !"".equals(type) || dataExporter.getOutputTypeHandler() != null) {
            linkRequired = true;
        }
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)ClientIdPool.get(clientId + "container"), "id");
        String style = dataExporter.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("class", (Object)dataExporter.getStyleClass(), "class");
        if (linkRequired) {
            if (renderLabelAsButton && image == null) {
                writer.startElement("input", uiComponent);
                writer.writeAttribute("id", (Object)clientId, "id");
                writer.writeAttribute("type", (Object)"button", "type");
                writer.writeAttribute("onclick", (Object)"return iceSubmitPartial(form, this, event);", "onclick");
                writer.writeAttribute("value", (Object)label, "value");
                writer.endElement("input");
            } else {
                writer.startElement("a", uiComponent);
                writer.writeAttribute("id", (Object)clientId, "id");
                writer.writeAttribute("href", (Object)"javascript:;", "href");
                writer.writeAttribute("onclick", (Object)"var form=formOf(this); return iceSubmitPartial(form, this, event);", "onclick");
                if (image != null) {
                    writer.startElement("img", uiComponent);
                    writer.writeAttribute("src", (Object)CoreUtils.resolveResourceURL(facesContext, image), "src");
                    writer.writeAttribute("title", (Object)label, "title");
                    writer.writeAttribute("alt", (Object)label, "alt");
                    writer.endElement("img");
                } else {
                    writer.write(label);
                }
                writer.endElement("a");
            }
        }
        writer.endElement("div");
    }
}

