/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.flatfile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.flatfile.FlatFileConfiguration;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConnectorClass(configurationClass=FlatFileConfiguration.class, displayNameKey="FlatFile")
public class FlatFileConnector
implements Connector,
SearchOp<String>,
SchemaOp {
    private static Log log = Log.getLog(FlatFileConnector.class);
    private static final String MSG_SKIPPING = "Skipping blank line.";
    private FlatFileConfiguration cfg;

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public void init(Configuration cfg) {
        this.cfg = (FlatFileConfiguration)cfg;
    }

    public void dispose() {
    }

    public Schema schema() {
        SchemaBuilder bld = new SchemaBuilder(this.getClass());
        BufferedReader rdr = null;
        try {
            rdr = this.cfg.newFileReader();
            HashSet<AttributeInfo> attrInfos = new HashSet<AttributeInfo>();
            List<String> fieldNames = FlatFileConnector.readHeader(rdr, this.cfg.getFieldDelimiter(), this.cfg.getTextQualifier(), this.cfg.getUniqueAttributeName());
            for (String fieldName : fieldNames) {
                AttributeInfoBuilder abld = new AttributeInfoBuilder();
                abld.setName(fieldName);
                abld.setCreateable(false);
                abld.setUpdateable(false);
                attrInfos.add(abld.build());
            }
            bld.defineObjectClass(ObjectClass.ACCOUNT_NAME, attrInfos);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtil.quietClose((Reader)rdr);
        }
        return bld.build();
    }

    public FilterTranslator<String> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        return new AbstractFilterTranslator<String>(){};
    }

    public void executeQuery(ObjectClass oclass, String query, ResultsHandler handler, OperationOptions options) {
        long lines = 0L;
        char textQualifier = this.cfg.getTextQualifier();
        char fieldSeparator = this.cfg.getFieldDelimiter();
        String uniqueIdField = this.cfg.getUniqueAttributeName();
        BufferedReader rdr = null;
        try {
            String line;
            rdr = this.cfg.newFileReader();
            List<String> fieldNames = FlatFileConnector.readHeader(rdr, fieldSeparator, textQualifier, uniqueIdField);
            while ((line = rdr.readLine()) != null) {
                ++lines;
                if (line.trim().length() == 0) {
                    log.info(MSG_SKIPPING, new Object[0]);
                    continue;
                }
                log.ok("Processing Data Line: {0}", new Object[]{line});
                List fieldValues = StringUtil.parseLine((String)line, (char)fieldSeparator, (char)textQualifier);
                if (fieldValues == null) {
                    log.error("Error: {0}", new Object[]{line});
                } else {
                    ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
                    for (int i = 0; i < fieldValues.size(); ++i) {
                        String name = fieldNames.get(i);
                        String value = (String)fieldValues.get(i);
                        if (name.equals(uniqueIdField)) {
                            bld.setUid(value);
                            bld.setName(value);
                            continue;
                        }
                        bld.addAttribute(name, new Object[]{value});
                    }
                    ConnectorObject ret = bld.build();
                    if (handler.handle(ret)) continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new ConnectorIOException((Throwable)e);
        }
        finally {
            IOUtil.quietClose((Reader)rdr);
        }
    }

    static List<String> readHeader(BufferedReader rdr, char fieldSeparator, char textQualifier, String uniqueAttribute) throws IOException {
        String line;
        List ret = null;
        while ((line = rdr.readLine()) != null) {
            if (line.trim().length() == 0) {
                log.info(MSG_SKIPPING, new Object[0]);
                continue;
            }
            log.ok("Processing Header Line: {0}", new Object[]{line});
            ret = StringUtil.parseLine((String)line, (char)fieldSeparator, (char)textQualifier);
            if (ret == null) {
                String msg = "Error Parsing field names: Line ";
                throw new IllegalStateException("Error Parsing field names: Line " + line);
            }
            if (!ret.contains(uniqueAttribute)) {
                String msg = "Error unique attribute field does not exist: Line ";
                throw new IllegalStateException("Error unique attribute field does not exist: Line " + line);
            }
            log.info("Found Field Names: {0}", new Object[]{ret});
            break;
        }
        return ret;
    }
}

