/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.xml.common;

import java.util.ArrayList;
import java.util.List;

public abstract class ObjectPool<T> {
    public static final String code_id = "$Id$";
    private List<T> locked = new ArrayList<T>();
    private List<T> unlocked = new ArrayList<T>();

    public ObjectPool() {
    }

    public ObjectPool(int initialSize) {
        this();
        for (int i = 0; i < initialSize; ++i) {
            this.unlocked.add(this.create());
        }
    }

    public synchronized void dispose() {
        ArrayList<T> disposeList = new ArrayList<T>();
        disposeList.addAll(this.locked);
        disposeList.addAll(this.unlocked);
        this.locked.clear();
        this.unlocked.clear();
        for (Object pooled : disposeList) {
            Object var3_3 = null;
        }
        disposeList.clear();
    }

    protected abstract T create();

    public synchronized T checkout() {
        if (this.unlocked.size() > 0) {
            T pooled = this.unlocked.remove(0);
            this.locked.add(pooled);
            return pooled;
        }
        T pooled = this.create();
        this.locked.add(pooled);
        return pooled;
    }

    public synchronized void checkin(T pooled) {
        this.locked.remove(pooled);
        this.unlocked.add(pooled);
    }

    public int numLocked() {
        return this.locked.size();
    }

    public int numUnlocked() {
        return this.unlocked.size();
    }
}

