/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.validator;

public class ValidationMessage {
    public Type type;
    public String message;
    public String oid;
    public String property;

    public ValidationMessage() {
    }

    public ValidationMessage(Type type, String message) {
        this.type = type;
        this.message = message;
    }

    public ValidationMessage(Type type, String message, String oid) {
        this.type = type;
        this.message = message;
        this.oid = oid;
    }

    public ValidationMessage(Type type, String message, String oid, String property) {
        this.type = type;
        this.message = message;
        this.oid = oid;
        this.property = property;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (Type.ERROR.equals((Object)this.getType())) {
            sb.append("ERROR: ");
        } else if (Type.WARNING.equals((Object)this.getType())) {
            sb.append("WARNING: ");
        }
        sb.append(this.message);
        if (this.getOid() != null || this.getProperty() != null) {
            sb.append(" (");
            if (this.getOid() != null) {
                sb.append("OID: ");
                sb.append(this.getOid());
            }
            if (this.getProperty() != null) {
                sb.append(", property: ");
                sb.append(this.getProperty());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationMessage other = (ValidationMessage)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.oid == null ? other.oid != null : !this.oid.equals(other.oid)) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.type.hashCode();
        hash = 71 * hash + (this.message != null ? this.message.hashCode() : 0);
        hash = 71 * hash + (this.oid != null ? this.oid.hashCode() : 0);
        hash = 71 * hash + (this.property != null ? this.property.hashCode() : 0);
        return hash;
    }

    public static enum Type {
        WARNING,
        ERROR;

    }
}

