/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util.diff;

import java.util.LinkedList;
import java.util.List;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceConstants;

public class DiffConstants {
    public static List<Difference> IGNORE_DIFFERENCES = new LinkedList<Difference>();
    public static List<String> CONTAINER_PROPERTIES;
    public static List<String> REPLACE_PROPERTIES;

    public static boolean isForContainerProperty(Difference difference) {
        String propertyName = difference.getControlNodeDetail().getNode().getParentNode().getNodeName();
        return CONTAINER_PROPERTIES.contains(propertyName);
    }

    public static boolean isForReplaceProperty(Difference difference) {
        String controlXpath = difference.getControlNodeDetail().getXpathLocation();
        String testXpath = difference.getTestNodeDetail().getXpathLocation();
        for (String replaceProperty : REPLACE_PROPERTIES) {
            if (!(null != controlXpath ? controlXpath.contains(replaceProperty) : testXpath.contains(replaceProperty))) continue;
            return true;
        }
        return false;
    }

    public static String getReplacePropertyName(Difference difference) {
        String controlXpath = difference.getControlNodeDetail().getXpathLocation();
        String testXpath = difference.getTestNodeDetail().getXpathLocation();
        for (String replaceProperty : REPLACE_PROPERTIES) {
            if (!(null != controlXpath ? controlXpath.contains(replaceProperty) : testXpath.contains(replaceProperty))) continue;
            return replaceProperty;
        }
        throw new IllegalArgumentException("Difference is not for replace property");
    }

    static {
        IGNORE_DIFFERENCES.add(DifferenceConstants.HAS_DOCTYPE_DECLARATION);
        IGNORE_DIFFERENCES.add(DifferenceConstants.DOCTYPE_NAME);
        IGNORE_DIFFERENCES.add(DifferenceConstants.DOCTYPE_PUBLIC_ID);
        IGNORE_DIFFERENCES.add(DifferenceConstants.DOCTYPE_SYSTEM_ID);
        IGNORE_DIFFERENCES.add(DifferenceConstants.NAMESPACE_PREFIX);
        IGNORE_DIFFERENCES.add(DifferenceConstants.CHILD_NODELIST_SEQUENCE);
        IGNORE_DIFFERENCES.add(DifferenceConstants.CHILD_NODELIST_LENGTH);
        IGNORE_DIFFERENCES.add(DifferenceConstants.ATTR_SEQUENCE);
        IGNORE_DIFFERENCES.add(DifferenceConstants.COMMENT_VALUE);
        CONTAINER_PROPERTIES = new LinkedList<String>();
        CONTAINER_PROPERTIES.add("account");
        CONTAINER_PROPERTIES.add("user");
        CONTAINER_PROPERTIES.add("resource");
        CONTAINER_PROPERTIES.add("extension");
        CONTAINER_PROPERTIES.add("attributes");
        REPLACE_PROPERTIES = new LinkedList<String>();
        REPLACE_PROPERTIES.add("schemaHandling");
        REPLACE_PROPERTIES.add("schema");
        REPLACE_PROPERTIES.add("configuration");
        REPLACE_PROPERTIES.add("synchronizationState");
        REPLACE_PROPERTIES.add("synchronization");
        REPLACE_PROPERTIES.add("scripts");
    }
}

