/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.logging;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.LoggerMXBean;
import com.evolveum.midpoint.logging.TraceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jmx.export.MBeanExporter;

public class LoggerMXBeanExporter {
    private static Trace trace = TraceManager.getTrace(LoggerMXBeanExporter.class);
    private MBeanExporter exporter;

    public void setExporter(MBeanExporter exporter) {
        this.exporter = exporter;
    }

    public void setBeans(Map<String, LoggerBean> map) {
        if (map == null) {
            return;
        }
        this.exporter.setRegistrationBehavior(2);
        try {
            Set<Map.Entry<String, LoggerBean>> entries = map.entrySet();
            HashMap<String, LoggerMXBean> beanMap = new HashMap<String, LoggerMXBean>();
            for (Map.Entry<String, LoggerBean> entry : entries) {
                trace.info(this.toString() + " Trying to export: " + entry.getKey() + ", " + entry.getValue());
                ClassPathResource resource = new ClassPathResource(entry.getValue().getContext());
                XmlBeanFactory factory = new XmlBeanFactory((Resource)resource);
                LoggerMXBean logger = (LoggerMXBean)factory.getBean(entry.getValue().getBeanName());
                beanMap.put(entry.getKey(), logger);
            }
            this.exporter.setBeans(beanMap);
            this.exporter.afterPropertiesSet();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class LoggerBean {
        private String context;
        private String beanName;

        public LoggerBean(String context, String beanName) {
            this.context = context;
            this.beanName = beanName;
        }

        public String getContext() {
            return this.context;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

