/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer;

import java.util.ArrayList;
import java.util.List;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.CompositeFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.NotFilter;
import org.identityconnectors.framework.common.objects.filter.OrFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;
import org.identityconnectors.framework.impl.serializer.AbstractObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectDecoder;
import org.identityconnectors.framework.impl.serializer.ObjectEncoder;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapper;

class FilterHandlers {
    public static final List<ObjectTypeMapper> HANDLERS = new ArrayList<ObjectTypeMapper>();

    FilterHandlers() {
    }

    static {
        HANDLERS.add(new CompositeFilterHandler<AndFilter>(AndFilter.class, "AndFilter"){

            @Override
            protected AndFilter createFilter(Filter left, Filter right) {
                return new AndFilter(left, right);
            }
        });
        HANDLERS.add(new AttributeFilterHandler<ContainsFilter>(ContainsFilter.class, "ContainsFilter"){

            @Override
            protected ContainsFilter createFilter(Attribute attribute) {
                return new ContainsFilter(attribute);
            }
        });
        HANDLERS.add(new AttributeFilterHandler<EndsWithFilter>(EndsWithFilter.class, "EndsWithFilter"){

            @Override
            protected EndsWithFilter createFilter(Attribute attribute) {
                return new EndsWithFilter(attribute);
            }
        });
        HANDLERS.add(new AttributeFilterHandler<EqualsFilter>(EqualsFilter.class, "EqualsFilter"){

            @Override
            protected EqualsFilter createFilter(Attribute attribute) {
                return new EqualsFilter(attribute);
            }
        });
        HANDLERS.add(new AttributeFilterHandler<GreaterThanFilter>(GreaterThanFilter.class, "GreaterThanFilter"){

            @Override
            protected GreaterThanFilter createFilter(Attribute attribute) {
                return new GreaterThanFilter(attribute);
            }
        });
        HANDLERS.add(new AttributeFilterHandler<GreaterThanOrEqualFilter>(GreaterThanOrEqualFilter.class, "GreaterThanOrEqualFilter"){

            @Override
            protected GreaterThanOrEqualFilter createFilter(Attribute attribute) {
                return new GreaterThanOrEqualFilter(attribute);
            }
        });
        HANDLERS.add(new AttributeFilterHandler<LessThanFilter>(LessThanFilter.class, "LessThanFilter"){

            @Override
            protected LessThanFilter createFilter(Attribute attribute) {
                return new LessThanFilter(attribute);
            }
        });
        HANDLERS.add(new AttributeFilterHandler<LessThanOrEqualFilter>(LessThanOrEqualFilter.class, "LessThanOrEqualFilter"){

            @Override
            protected LessThanOrEqualFilter createFilter(Attribute attribute) {
                return new LessThanOrEqualFilter(attribute);
            }
        });
        HANDLERS.add(new AbstractObjectSerializationHandler((Class)NotFilter.class, "NotFilter"){

            public Object deserialize(ObjectDecoder decoder) {
                Filter filter = (Filter)decoder.readObjectContents(0);
                return new NotFilter(filter);
            }

            public void serialize(Object object, ObjectEncoder encoder) {
                NotFilter val = (NotFilter)object;
                encoder.writeObjectContents(val.getFilter());
            }
        });
        HANDLERS.add(new CompositeFilterHandler<OrFilter>(OrFilter.class, "OrFilter"){

            @Override
            protected OrFilter createFilter(Filter left, Filter right) {
                return new OrFilter(left, right);
            }
        });
        HANDLERS.add(new AttributeFilterHandler<StartsWithFilter>(StartsWithFilter.class, "StartsWithFilter"){

            @Override
            protected StartsWithFilter createFilter(Attribute attribute) {
                return new StartsWithFilter(attribute);
            }
        });
        HANDLERS.add(new AttributeFilterHandler<ContainsAllValuesFilter>(ContainsAllValuesFilter.class, "ContainsAllValuesFilter"){

            @Override
            protected ContainsAllValuesFilter createFilter(Attribute attribute) {
                return new ContainsAllValuesFilter(attribute);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AttributeFilterHandler<T extends AttributeFilter>
    extends AbstractObjectSerializationHandler {
        protected AttributeFilterHandler(Class<T> clazz, String typeName) {
            super(clazz, typeName);
        }

        @Override
        public final Object deserialize(ObjectDecoder decoder) {
            Attribute attribute = (Attribute)decoder.readObjectField("attribute", null, null);
            return this.createFilter(attribute);
        }

        @Override
        public final void serialize(Object object, ObjectEncoder encoder) {
            AttributeFilter val = (AttributeFilter)object;
            encoder.writeObjectField("attribute", val.getAttribute(), false);
        }

        protected abstract T createFilter(Attribute var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CompositeFilterHandler<T extends CompositeFilter>
    extends AbstractObjectSerializationHandler {
        protected CompositeFilterHandler(Class<T> clazz, String typeName) {
            super(clazz, typeName);
        }

        @Override
        public final Object deserialize(ObjectDecoder decoder) {
            Filter left = (Filter)decoder.readObjectContents(0);
            Filter right = (Filter)decoder.readObjectContents(1);
            return this.createFilter(left, right);
        }

        @Override
        public final void serialize(Object object, ObjectEncoder encoder) {
            CompositeFilter val = (CompositeFilter)object;
            encoder.writeObjectContents(val.getLeft());
            encoder.writeObjectContents(val.getRight());
        }

        protected abstract T createFilter(Filter var1, Filter var2);
    }
}

