/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer;

import org.identityconnectors.framework.impl.serializer.AbstractObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectDecoder;
import org.identityconnectors.framework.impl.serializer.ObjectEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSerializationHandler
extends AbstractObjectSerializationHandler {
    public EnumSerializationHandler(Class<? extends Enum<?>> clazz, String name) {
        super(clazz, name);
    }

    @Override
    public Object deserialize(ObjectDecoder decoder) {
        String val = decoder.readStringField("value", null);
        Class<?> enumClass = this.getHandledObjectType();
        Object rv = Enum.valueOf(enumClass, val);
        return rv;
    }

    @Override
    public void serialize(Object object, ObjectEncoder encoder) {
        Enum e = (Enum)object;
        encoder.writeStringField("value", e.name());
    }
}

