/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.remote;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.BinaryObjectDeserializer;
import org.identityconnectors.framework.common.serializer.BinaryObjectSerializer;
import org.identityconnectors.framework.common.serializer.ObjectSerializerFactory;

public class RemoteFrameworkConnection {
    private Socket _socket;
    private BinaryObjectSerializer _encoder;
    private BinaryObjectDeserializer _decoder;

    public RemoteFrameworkConnection(RemoteFrameworkConnectionInfo info) {
        try {
            this.init(info);
        }
        catch (Exception e) {
            throw ConnectorException.wrap(e);
        }
    }

    public RemoteFrameworkConnection(Socket socket) {
        try {
            this.init(socket);
        }
        catch (Exception e) {
            throw ConnectorException.wrap(e);
        }
    }

    private void init(RemoteFrameworkConnectionInfo connectionInfo) throws Exception {
        Socket socket = new Socket();
        socket.setSoTimeout(connectionInfo.getTimeout());
        socket.connect(new InetSocketAddress(connectionInfo.getHost(), connectionInfo.getPort()), connectionInfo.getTimeout());
        try {
            if (connectionInfo.getUseSSL()) {
                SSLSocketFactory factory;
                List<TrustManager> trustManagers = connectionInfo.getTrustManagers();
                TrustManager[] trustManagerArr = null;
                if (trustManagers.size() > 0) {
                    trustManagerArr = trustManagers.toArray(new TrustManager[trustManagers.size()]);
                }
                if (trustManagers == null) {
                    factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                } else {
                    SSLContext context = SSLContext.getInstance("TLS");
                    context.init(null, trustManagerArr, null);
                    factory = context.getSocketFactory();
                }
                socket = factory.createSocket(socket, connectionInfo.getHost(), connectionInfo.getPort(), true);
                ((SSLSocket)socket).startHandshake();
            }
        }
        catch (Exception e) {
            try {
                socket.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
        this.init(socket);
    }

    private void init(Socket socket) throws Exception {
        this._socket = socket;
        InputStream inputStream = this._socket.getInputStream();
        OutputStream outputStream = this._socket.getOutputStream();
        ObjectSerializerFactory factory = ObjectSerializerFactory.getInstance();
        this._encoder = factory.newBinarySerializer(outputStream);
        this._decoder = factory.newBinaryDeserializer(inputStream);
    }

    public void close() {
        this.flush();
        try {
            if (this._socket instanceof SSLSocket) {
                this._socket.close();
            } else {
                this._socket.shutdownOutput();
                this._socket.shutdownInput();
                this._socket.close();
            }
        }
        catch (Exception e) {
            throw ConnectorException.wrap(e);
        }
    }

    public void flush() {
        this._encoder.flush();
    }

    public void writeObject(Object object) {
        this._encoder.writeObject(object);
    }

    public Object readObject() {
        this.flush();
        return this._decoder.readObject();
    }
}

