/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.remote;

import java.util.List;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteFrameworkConnection;
import org.identityconnectors.framework.impl.api.remote.messages.HelloRequest;
import org.identityconnectors.framework.impl.api.remote.messages.HelloResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConnectorInfoManagerImpl
implements ConnectorInfoManager {
    private List<ConnectorInfo> _connectorInfo;

    private RemoteConnectorInfoManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteConnectorInfoManagerImpl(RemoteFrameworkConnectionInfo info) throws RuntimeException {
        RemoteFrameworkConnection connection = new RemoteFrameworkConnection(info);
        try {
            connection.writeObject(CurrentLocale.get());
            connection.writeObject(info.getKey());
            connection.writeObject(new HelloRequest());
            HelloResponse response = (HelloResponse)connection.readObject();
            if (response.getException() != null) {
                throw ConnectorException.wrap(response.getException());
            }
            List<RemoteConnectorInfoImpl> remoteInfos = response.getConnectorInfos();
            for (RemoteConnectorInfoImpl remoteInfo : remoteInfos) {
                remoteInfo.setRemoteConnectionInfo(info);
            }
            this._connectorInfo = CollectionUtil.newReadOnlyList(remoteInfos);
        }
        finally {
            connection.close();
        }
    }

    public RemoteConnectorInfoManagerImpl derive(RemoteFrameworkConnectionInfo info) {
        RemoteConnectorInfoManagerImpl rv = new RemoteConnectorInfoManagerImpl();
        List remoteInfos = (List)SerializerUtil.cloneObject(this._connectorInfo);
        for (RemoteConnectorInfoImpl remoteInfo : remoteInfos) {
            remoteInfo.setRemoteConnectionInfo(info);
        }
        rv._connectorInfo = CollectionUtil.newReadOnlyList(remoteInfos);
        return rv;
    }

    @Override
    public ConnectorInfo findConnectorInfo(ConnectorKey key) {
        for (ConnectorInfo info : this._connectorInfo) {
            if (!info.getConnectorKey().equals(key)) continue;
            return info;
        }
        return null;
    }

    @Override
    public List<ConnectorInfo> getConnectorInfos() {
        return this._connectorInfo;
    }
}

