/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributesToGetResultsHandler {
    private final String[] _attrsToGet;

    public AttributesToGetResultsHandler(String[] attrsToGet) {
        Assertions.nullCheck(attrsToGet, "attrsToGet");
        this._attrsToGet = attrsToGet;
    }

    public Set<Attribute> reduceToAttrsToGet(Set<Attribute> attrs) {
        HashSet<Attribute> ret = new HashSet<Attribute>(this._attrsToGet.length);
        Map<String, Attribute> map = AttributeUtil.toMap(attrs);
        for (String attrName : this._attrsToGet) {
            Attribute attr = map.get(attrName);
            if (attr == null) continue;
            ret.add(attr);
        }
        return ret;
    }

    public ConnectorObject reduceToAttrsToGet(ConnectorObject obj) {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        bld.setUid(obj.getUid());
        bld.setName(obj.getName());
        bld.setObjectClass(obj.getObjectClass());
        Set<Attribute> objAttrs = obj.getAttributes();
        Set<Attribute> attrs = this.reduceToAttrsToGet(objAttrs);
        bld.addAttributes(attrs);
        return bld.build();
    }
}

