/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.operations.SPIOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassProperties {
    public static ConfigurationPropertiesImpl createConfigurationProperties(Configuration config) {
        try {
            return JavaClassProperties.createConfigurationProperties2(config);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static Configuration createBean(ConfigurationPropertiesImpl properties, Class<? extends Configuration> configClass) {
        try {
            return JavaClassProperties.createBean2(properties, configClass);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static void mergeIntoBean(ConfigurationPropertiesImpl properties, Configuration config) {
        try {
            JavaClassProperties.mergeIntoBean2(properties, config);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private static ConfigurationPropertiesImpl createConfigurationProperties2(Configuration defaultObject) throws Exception {
        Class<?> config = defaultObject.getClass();
        ConfigurationPropertiesImpl properties = new ConfigurationPropertiesImpl();
        ArrayList<ConfigurationPropertyImpl> temp = new ArrayList<ConfigurationPropertyImpl>();
        Map<String, PropertyDescriptor> descs = JavaClassProperties.getFilteredProperties(config);
        for (PropertyDescriptor desc : descs.values()) {
            Class<?> type;
            Method getter = desc.getReadMethod();
            Method setter = desc.getWriteMethod();
            String name = desc.getName();
            ConfigurationProperty options = JavaClassProperties.getPropertyOptions(getter, setter);
            int order = 0;
            String helpKey = name + ".help";
            String displKey = name + ".display";
            boolean confidential = false;
            boolean required = false;
            if (options != null) {
                if (StringUtil.isNotBlank(options.helpMessageKey())) {
                    helpKey = options.helpMessageKey();
                }
                if (StringUtil.isNotBlank(options.displayMessageKey())) {
                    displKey = options.displayMessageKey();
                }
                order = options.order();
                confidential = options.confidential();
                required = options.required();
            }
            if (!FrameworkUtil.isSupportedConfigurationType(type = desc instanceof IndexedPropertyDescriptor ? Array.newInstance(desc.getPropertyType(), 0).getClass() : desc.getPropertyType())) {
                String MSG = "Property type ''{0}'' is not supported.";
                throw new IllegalArgumentException(MessageFormat.format("Property type ''{0}'' is not supported.", type));
            }
            Object value = getter.invoke((Object)defaultObject, new Object[0]);
            ConfigurationPropertyImpl prop = new ConfigurationPropertyImpl();
            prop.setConfidential(confidential);
            prop.setDisplayMessageKey(displKey);
            prop.setHelpMessageKey(helpKey);
            prop.setName(name);
            prop.setOrder(order);
            prop.setValue(value);
            prop.setType(type);
            prop.setRequired(required);
            prop.setOperations(options == null ? null : JavaClassProperties.translateOperations(options.operations()));
            temp.add(prop);
        }
        properties.setProperties(temp);
        return properties;
    }

    private static Set<Class<? extends APIOperation>> translateOperations(Class<? extends SPIOperation>[] ops) {
        HashSet<Class<? extends APIOperation>> set = new HashSet<Class<? extends APIOperation>>();
        for (Class<? extends SPIOperation> spi : ops) {
            set.addAll(FrameworkUtil.spi2apis(spi));
        }
        return set;
    }

    private static Configuration createBean2(ConfigurationPropertiesImpl properties, Class<? extends Configuration> configClass) throws Exception {
        Configuration rv = configClass.newInstance();
        rv.setConnectorMessages(properties.getParent().getConnectorInfo().getMessages());
        JavaClassProperties.mergeIntoBean2(properties, rv);
        return rv;
    }

    private static void mergeIntoBean2(ConfigurationPropertiesImpl properties, Configuration config) throws Exception {
        Class<?> configClass = config.getClass();
        Map<String, PropertyDescriptor> descriptors = JavaClassProperties.getFilteredProperties(configClass);
        for (ConfigurationPropertyImpl property : properties.getProperties()) {
            String name = property.getName();
            PropertyDescriptor desc = descriptors.get(name);
            if (desc == null) {
                String FMT = "Class ''{0}'' does not have a property ''{1}''.";
                String MSG = MessageFormat.format("Class ''{0}'' does not have a property ''{1}''.", configClass.getName(), name);
                throw new IllegalArgumentException(MSG);
            }
            Object value = property.getValue();
            value = SerializerUtil.cloneObject(value);
            Method setter = desc.getWriteMethod();
            try {
                setter.invoke((Object)config, value);
            }
            catch (IllegalArgumentException ex) {
                if (value == null) {
                    throw ex;
                }
                Class<?> expected = setter.getParameterTypes()[0];
                Class<?> actual = value.getClass();
                String fmt = "For property ''{0}'' expected type ''{1}'' actual type ''{2}''.";
                String msg = MessageFormat.format(fmt, name, expected, actual);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    private static Map<String, PropertyDescriptor> getFilteredProperties(Class<? extends Configuration> config) throws Exception {
        PropertyDescriptor[] descriptors;
        HashMap<String, PropertyDescriptor> rv = new HashMap<String, PropertyDescriptor>();
        BeanInfo info = Introspector.getBeanInfo(config);
        for (PropertyDescriptor descriptor : descriptors = info.getPropertyDescriptors()) {
            String propName = descriptor.getName();
            if (descriptor.getWriteMethod() == null || "connectorMessages".equals(propName)) continue;
            if (descriptor.getReadMethod() == null) {
                String FMT = "Found setter ''{0}'' but not the corresponding getter.";
                String MSG = MessageFormat.format("Found setter ''{0}'' but not the corresponding getter.", propName);
                throw new IllegalArgumentException(MSG);
            }
            rv.put(propName, descriptor);
        }
        return rv;
    }

    private static ConfigurationProperty getPropertyOptions(Method getter, Method setter) {
        ConfigurationProperty opts = setter.getAnnotation(ConfigurationProperty.class);
        if (opts == null) {
            opts = getter.getAnnotation(ConfigurationProperty.class);
        }
        return opts;
    }
}

