/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationPropertiesImpl
implements ConfigurationProperties {
    LinkedHashMap<String, ConfigurationPropertyImpl> _properties;
    private transient APIConfigurationImpl _parent;

    public APIConfigurationImpl getParent() {
        return this._parent;
    }

    public void setParent(APIConfigurationImpl parent) {
        this._parent = parent;
    }

    public void setProperties(Collection<ConfigurationPropertyImpl> in) {
        ArrayList<ConfigurationPropertyImpl> properties = new ArrayList<ConfigurationPropertyImpl>(in);
        Collections.sort(properties, new Comparator<ConfigurationPropertyImpl>(){

            @Override
            public int compare(ConfigurationPropertyImpl o1, ConfigurationPropertyImpl o2) {
                int or2;
                int or1 = o1.getOrder();
                return or1 < (or2 = o2.getOrder()) ? -1 : (or1 > or2 ? 1 : 0);
            }
        });
        LinkedHashMap<String, ConfigurationPropertyImpl> temp = new LinkedHashMap<String, ConfigurationPropertyImpl>();
        for (ConfigurationPropertyImpl property : properties) {
            temp.put(property.getName(), property);
            property.setParent(this);
        }
        this._properties = temp;
    }

    public Collection<ConfigurationPropertyImpl> getProperties() {
        return this._properties.values();
    }

    @Override
    public ConfigurationProperty getProperty(String name) {
        return this._properties.get(name);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>(this._properties.keySet());
        return CollectionUtil.newReadOnlyList(names);
    }

    @Override
    public void setPropertyValue(String name, Object value) {
        ConfigurationPropertyImpl property = this._properties.get(name);
        if (property == null) {
            String TMPL = "Property ''{0}'' does not exist.";
            String MSG = MessageFormat.format("Property ''{0}'' does not exist.", name);
            throw new IllegalArgumentException(MSG);
        }
        property.setValue(value);
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigurationPropertiesImpl) {
            ConfigurationPropertiesImpl other = (ConfigurationPropertiesImpl)o;
            HashSet<ConfigurationPropertyImpl> set1 = new HashSet<ConfigurationPropertyImpl>(this._properties.values());
            HashSet<ConfigurationPropertyImpl> set2 = new HashSet<ConfigurationPropertyImpl>(other._properties.values());
            return set1.equals(set2);
        }
        return false;
    }

    public int hashCode() {
        HashSet<ConfigurationPropertyImpl> set1 = new HashSet<ConfigurationPropertyImpl>(this._properties.values());
        return set1.hashCode();
    }
}

