/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import org.identityconnectors.common.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assertions {
    private static final String NULL_FORMAT = "Parameter '%s' must not be null.";
    private static final String BLANK_FORMAT = "Parameter '%s' must not be blank.";

    private Assertions() {
        throw new AssertionError();
    }

    public static void nullCheck(Object o, String param) {
        assert (StringUtil.isNotBlank(param));
        if (o == null) {
            throw new NullPointerException(String.format(NULL_FORMAT, param));
        }
    }

    public static <T> T nullChecked(T o, String param) {
        assert (StringUtil.isNotBlank(param));
        if (o == null) {
            throw new NullPointerException(String.format(NULL_FORMAT, param));
        }
        return o;
    }

    public static void blankCheck(String o, String param) {
        assert (StringUtil.isNotBlank(param));
        if (StringUtil.isBlank(o)) {
            throw new IllegalArgumentException(String.format(BLANK_FORMAT, param));
        }
    }

    public static String blankChecked(String o, String param) {
        assert (StringUtil.isNotBlank(param));
        if (StringUtil.isBlank(o)) {
            throw new IllegalArgumentException(String.format(BLANK_FORMAT, param));
        }
        return o;
    }
}

