/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.validator;

import com.evolveum.midpoint.validator.ObjectHandler;
import com.evolveum.midpoint.validator.ValidationMessage;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.Objects;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import org.xml.sax.SAXParseException;

public class Validator {
    private boolean verbose = false;
    private List<ValidationMessage> errors;
    private List<ValidationMessage> objectErrors;
    ObjectHandler handler;

    public Validator() {
        this.handler = null;
    }

    public Validator(ObjectHandler handler) {
        this.handler = handler;
    }

    public ObjectHandler getHanlder() {
        return this.handler;
    }

    public void setHandler(ObjectHandler handler) {
        this.handler = handler;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public List<ValidationMessage> validate(InputStream inputStream) {
        this.errors = new ArrayList<ValidationMessage>();
        Unmarshaller u = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            u = jc.createUnmarshaller();
        }
        catch (JAXBException ex) {
            this.errors.add(new ValidationMessage(ValidationMessage.Type.ERROR, "Error initializing JAXB: " + (Object)((Object)ex)));
            if (this.verbose) {
                ex.printStackTrace();
            }
            return this.errors;
        }
        Objects objects = null;
        try {
            Object object = u.unmarshal(inputStream);
            if (object instanceof Objects) {
                objects = (Objects)object;
            } else {
                objects = new Objects();
                objects.getObject().add((JAXBElement)object);
            }
        }
        catch (JAXBException ex) {
            Throwable linkedException;
            if (this.verbose) {
                ex.printStackTrace();
            }
            if ((linkedException = ex.getLinkedException()) instanceof SAXParseException) {
                SAXParseException saxex = (SAXParseException)linkedException;
                this.errors.add(new ValidationMessage(ValidationMessage.Type.ERROR, "XML Parse error: " + saxex.getMessage() + " (line " + saxex.getLineNumber() + " col " + saxex.getColumnNumber() + ")"));
            } else if (ex instanceof UnmarshalException) {
                this.errors.add(new ValidationMessage(ValidationMessage.Type.ERROR, "Unmarshalling error: " + ex.getMessage()));
            } else {
                this.errors.add(new ValidationMessage(ValidationMessage.Type.ERROR, "Unmarshalling error: " + (linkedException != null ? linkedException.getMessage() : "unknown: " + (Object)((Object)ex))));
            }
            return this.errors;
        }
        for (JAXBElement jaxbObject : objects.getObject()) {
            this.objectErrors = new ArrayList<ValidationMessage>();
            ObjectType object = (ObjectType)jaxbObject.getValue();
            if (this.verbose) {
                System.out.println("Processing OID " + object.getOid());
            }
            this.checkName(object, object.getName(), "name");
            if (object instanceof ResourceType) {
                ResourceType resource = (ResourceType)object;
                this.checkResource(resource);
            }
            if (this.handler == null) continue;
            this.handler.handleObject(object, this.objectErrors);
        }
        return this.errors;
    }

    void checkName(ObjectType object, String value, String propertyName) {
        if (value == null || value.isEmpty()) {
            this.error("Empty property", object, propertyName);
        }
    }

    void checkUri(ObjectType object, String value, String propertyName) {
        if (value == null || value.isEmpty()) {
            this.error("Empty property", object, propertyName);
        }
        try {
            URI uri = new URI(value);
            if (uri.getScheme() == null) {
                this.error("URI is supposed to be absolute", object, propertyName);
            }
        }
        catch (URISyntaxException ex) {
            this.error("Wrong URI syntax: " + ex, object, propertyName);
        }
    }

    void checkResource(ResourceType resource) {
        this.checkUri((ObjectType)resource, resource.getType(), "type");
        this.checkUri((ObjectType)resource, resource.getNamespace(), "namespace");
    }

    void error(String message, ObjectType object) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Type.ERROR, message, object.getOid());
        this.errors.add(vm);
        this.objectErrors.add(vm);
    }

    void error(String message, ObjectType object, String propertyName) {
        ValidationMessage vm = new ValidationMessage(ValidationMessage.Type.ERROR, message, object.getOid(), propertyName);
        this.errors.add(vm);
        this.objectErrors.add(vm);
    }
}

