/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util.patch;

import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.XPathUtil;
import com.evolveum.midpoint.util.jaxb.JAXBUtil;
import com.evolveum.midpoint.util.patch.PatchException;
import com.evolveum.midpoint.util.patch.PatchingListener;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationTypeType;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatchXml
extends XPathUtil {
    private static final Logger logger = TraceManager.getTrace(PatchXml.class);
    private XPath xpath;
    private PatchingListener listener;

    public void setPatchingListener(PatchingListener listener) {
        this.listener = listener;
    }

    private void applyDifference(Document doc, PropertyModificationType change) throws PatchException {
        if (null != this.listener && !this.listener.isApplicable(change)) {
            return;
        }
        XPathType xpathUtil = new XPathType(change.getPath());
        List values = change.getValue().getAny();
        Element newOrOldNode = (Element)values.get(0);
        NodeList nodes = null;
        switch (change.getModificationType()) {
            case add: {
                NodeList parentNodes = null;
                try {
                    parentNodes = new XPathUtil().matchedNodesByXPath(xpathUtil, null, doc.getFirstChild());
                }
                catch (XPathExpressionException ex) {
                    throw new PatchException((Throwable)ex);
                }
                if (null == parentNodes || parentNodes.getLength() != 1) {
                    logger.error("XPath '{}' matches incorrect number of nodes (actual match was {})", (Object)xpathUtil.getXPath(), (Object)(parentNodes != null ? parentNodes.getLength() : 0));
                    throw new PatchException("XPath matches incorrect number of nodes");
                }
                Node parentNode = parentNodes.item(0);
                DOMUtil.addChildNodes(parentNode, newOrOldNode);
                break;
            }
            case replace: 
            case delete: {
                try {
                    nodes = this.matchedNodesByXPath(xpathUtil, null, doc.getFirstChild());
                }
                catch (XPathExpressionException ex) {
                    throw new PatchException((Throwable)ex);
                }
                if (null == nodes || nodes.getLength() == 0) {
                    logger.warn("No matches for XPath {}", (Object)xpathUtil.getXPath());
                    if (PropertyModificationTypeType.replace.equals((Object)change.getModificationType())) {
                        logger.warn("Will create nodes defined by XPath {}", (Object)xpathUtil.getXPath());
                        DOMUtil.createNodesDefinedByXPath(doc, xpathUtil);
                        try {
                            nodes = this.matchedNodesByXPath(xpathUtil, null, doc.getFirstChild());
                        }
                        catch (XPathExpressionException ex) {
                            throw new PatchException((Throwable)ex);
                        }
                    }
                }
                if (nodes.getLength() > 1) {
                    logger.warn("XPath {} matches more than one node ({}). It is ok, for multi value nodes", (Object)xpathUtil.getXPath(), (Object)nodes.getLength());
                }
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (PropertyModificationTypeType.replace.equals((Object)change.getModificationType())) {
                        DOMUtil.replaceChildNodes(node, newOrOldNode);
                    }
                    if (!PropertyModificationTypeType.delete.equals((Object)change.getModificationType())) continue;
                    DOMUtil.deleteChildNodes(node, newOrOldNode);
                }
                break;
            }
        }
        if (null != this.listener) {
            this.listener.applied(change);
        }
    }

    private static String serializePatchedXml(Document objectDoc) {
        try {
            String patchedXml = DOMUtil.serializeDOMToString(objectDoc);
            logger.trace("Patched xml (original xml with applied relative changes) = {}", (Object)patchedXml);
            return patchedXml;
        }
        catch (Exception ex) {
            logger.error("Failed to serialize DOM to String", (Throwable)ex);
            return null;
        }
    }

    private static JAXBElement prepareJaxbObject(File oldXmlFile) throws PatchException {
        JAXBElement object = null;
        try {
            object = (JAXBElement)JAXBUtil.unmarshal(oldXmlFile);
            return object;
        }
        catch (JAXBException ex) {
            logger.error("Failed to unmarshall object", (Throwable)ex);
            throw new PatchException("Failed to unmarshall object", (Throwable)ex);
        }
    }

    private static String marshallJaxbObject(ObjectType jaxbObject) throws PatchException {
        try {
            ObjectFactory of = new ObjectFactory();
            JAXBElement jaxb = of.createObject(jaxbObject);
            String xml = JAXBUtil.marshal(jaxb);
            return xml;
        }
        catch (JAXBException ex) {
            throw new PatchException("Failed to marshall object", (Throwable)ex);
        }
    }

    public String applyDifferences(ObjectModificationType changes, ObjectType objectType) throws PatchException {
        String xmlObject = PatchXml.marshallJaxbObject(objectType);
        logger.trace("Original XML that we are going to patch {}", (Object)xmlObject);
        Document objectDoc = DOMUtil.parseDocument(xmlObject);
        this.xpath = this.setupXPath();
        logger.debug("Iterate through relative changes and apply them");
        for (PropertyModificationType change : changes.getPropertyModification()) {
            logger.debug("Apply change: changeType = {}, changePath = {}", new Object[]{change.getModificationType(), null == change.getPath() ? null : change.getPath().getTextContent()});
            if (change.getValue().getAny().isEmpty() || change.getModificationType() == null) {
                logger.warn("Skipping property modification, empty value list or undefined modification type.");
                continue;
            }
            logger.trace("Value of the relative change = {}", (Object)DOMUtil.serializeDOMToString((Node)change.getValue().getAny().get(0)));
            this.applyDifference(objectDoc, change);
            logger.debug("Finished application of change: changeType = {}, changePath = {}", new Object[]{change.getModificationType(), null == change.getPath() ? null : change.getPath().getTextContent()});
        }
        logger.debug("Finished iteration through relative changes");
        return PatchXml.serializePatchedXml(objectDoc);
    }

    public String applyDifferences(ObjectModificationType changes, File oldXmlFile) throws PatchException {
        JAXBElement jaxbObject = PatchXml.prepareJaxbObject(oldXmlFile);
        return this.applyDifferences(changes, (ObjectType)jaxbObject.getValue());
    }
}

