/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.util.MapXPathVariableResolver;
import com.evolveum.midpoint.util.Variable;
import com.evolveum.midpoint.xml.schema.ExpressionHolder;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.XPathType;
import com.evolveum.midpoint.xpath.MidPointNamespaceContext;
import com.evolveum.midpoint.xpath.MidPointXPathFunctionResolver;
import com.evolveum.midpoint.xpath.functions.CapitalizeFunction;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtil {
    private static final Trace logger = TraceManager.getTrace(XPathUtil.class);

    public static Object evaluateExpression(Map<QName, Variable> variables, ExpressionHolder expressionHolder, QName returnType) {
        return new XPathUtil().evaluateExpr(variables, expressionHolder, returnType);
    }

    protected Object evaluateExpr(Map<QName, Variable> variables, ExpressionHolder expressionHolder, QName returnType) {
        logger.trace("Expression '{}' will be evaluated in context: variables = '{}' and namespaces = '{}'", new Object[]{expressionHolder.getExpressionAsString(), variables.values(), expressionHolder.getNamespaceMap()});
        Validate.notNull((Object)expressionHolder);
        try {
            Node nodeForEval;
            XPath xpath = this.setupXPath(variables, expressionHolder.getNamespaceMap());
            XPathExpression expr = xpath.compile(expressionHolder.getExpressionAsString());
            Node node = nodeForEval = variables.get(SchemaConstants.I_ACCOUNT) == null ? null : (Node)variables.get(SchemaConstants.I_ACCOUNT).getObject();
            if (null == nodeForEval) {
                nodeForEval = variables.get(SchemaConstants.I_USER) == null ? null : (Node)variables.get(SchemaConstants.I_USER).getObject();
            }
            Object evaluatedExpression = expr.evaluate(nodeForEval, returnType);
            logger.trace("Expression '{}' was evaluated to '{}' ", new Object[]{expressionHolder.getExpressionAsString(), evaluatedExpression});
            return evaluatedExpression;
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Expression (" + expressionHolder.getExpressionAsString() + ") evaluation failed", ex);
        }
    }

    protected XPath setupXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        return xpath;
    }

    protected XPath setupXPath(Map<QName, Variable> variables, Map<String, String> namespaces) {
        XPath xpath = this.setupXPath();
        if (null != variables) {
            MapXPathVariableResolver variableResolver = new MapXPathVariableResolver(variables);
            xpath.setXPathVariableResolver((XPathVariableResolver)variableResolver);
        }
        xpath.setNamespaceContext(new MidPointNamespaceContext(namespaces));
        MidPointXPathFunctionResolver fc = new MidPointXPathFunctionResolver();
        fc.registerFunction(new QName("http://midpoint.evolveum.com/custom", "capitalize"), (XPathFunction)new CapitalizeFunction());
        xpath.setXPathFunctionResolver((XPathFunctionResolver)fc);
        return xpath;
    }

    public NodeList matchedNodesByXPath(XPathType xpathType, Map<QName, Variable> variables, Node domObject) throws XPathExpressionException {
        Validate.notNull((Object)xpathType, (String)"xpathType is null");
        Validate.notNull((Object)domObject, (String)"domObject is null");
        try {
            XPath xpath = this.setupXPath(variables, xpathType.getNamespaceMap());
            XPathExpression expr = xpath.compile(xpathType.getXPath());
            NodeList result = (NodeList)expr.evaluate(domObject, XPathConstants.NODESET);
            return result;
        }
        catch (XPathExpressionException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

