/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Node;

public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getObjectType(String objectName) {
        if (SchemaConstants.I_USER_TYPE.getLocalPart().equals(objectName)) {
            return QNameUtil.qNameToUri((QName)SchemaConstants.I_USER_TYPE);
        }
        if (SchemaConstants.I_ACCOUNT_TYPE.getLocalPart().equals(objectName)) {
            return QNameUtil.qNameToUri((QName)SchemaConstants.I_ACCOUNT_TYPE);
        }
        if (SchemaConstants.I_RESOURCE_TYPE.getLocalPart().equals(objectName)) {
            return QNameUtil.qNameToUri((QName)SchemaConstants.I_RESOURCE_TYPE);
        }
        if (SchemaConstants.I_RESOURCE_STATE_TYPE.getLocalPart().equals(objectName)) {
            return QNameUtil.qNameToUri((QName)SchemaConstants.I_RESOURCE_STATE_TYPE);
        }
        if (SchemaConstants.I_USER_TEMPLATE_TYPE.getLocalPart().equals(objectName)) {
            return QNameUtil.qNameToUri((QName)SchemaConstants.I_USER_TEMPLATE_TYPE);
        }
        if (SchemaConstants.I_GENERIC_OBJECT_TYPE.getLocalPart().equals(objectName)) {
            return QNameUtil.qNameToUri((QName)SchemaConstants.I_GENERIC_OBJECT_TYPE);
        }
        throw new IllegalArgumentException("UnsupportedObjectType = " + objectName);
    }

    public static String getPropertyName(String name) {
        if (null == name) {
            return "";
        }
        return StringUtils.lowerCase((String)name);
    }

    public static String getPropertySilent(Object object, String property) {
        String result = null;
        try {
            result = BeanUtils.getProperty((Object)object, (String)property);
        }
        catch (IllegalAccessException ex) {
            logger.warn("Failed to get property for instances {}, {}. Error message was {}", new Object[]{object.getClass().getName(), property, ex.getMessage()});
        }
        catch (InvocationTargetException ex) {
            logger.warn("Failed to get property for instances {}, {}. Error message was {}", new Object[]{object.getClass().getName(), property, ex.getMessage()});
        }
        catch (NoSuchMethodException ex) {
            logger.warn("Failed to get property for instances {}, {}. Error message was {}", new Object[]{object.getClass().getName(), property, ex.getMessage()});
        }
        return result;
    }

    public static void copyPropertiesSilent(Object target, Object source) {
        try {
            BeanUtils.copyProperties((Object)target, (Object)source);
            Field[] fields = target.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                ParameterizedType type;
                if (!"List".equals(fields[i].getType().getSimpleName()) || null == (type = (ParameterizedType)fields[i].getGenericType()) || type.getActualTypeArguments().length <= 0 || !"String".equals(((Class)type.getActualTypeArguments()[0]).getSimpleName())) continue;
                boolean existsSetter = true;
                try {
                    Method targetSetterMethod = target.getClass().getDeclaredMethod("set" + StringUtils.capitalise((String)fields[i].getName()), List.class);
                    if (null == targetSetterMethod) {
                        existsSetter = false;
                    }
                }
                catch (NoSuchMethodException ex) {
                    existsSetter = false;
                }
                if (existsSetter) continue;
                Method targetMethod = target.getClass().getDeclaredMethod("get" + StringUtils.capitalise((String)fields[i].getName()), new Class[0]);
                Method sourceMethod = source.getClass().getDeclaredMethod("get" + StringUtils.capitalise((String)fields[i].getName()), new Class[0]);
                if (null == targetMethod || null == sourceMethod) continue;
                List targetList = (List)targetMethod.invoke(target, new Object[0]);
                List sourceList = (List)sourceMethod.invoke(source, new Object[0]);
                if (targetList == null) continue;
                targetList.clear();
                if (sourceList == null) continue;
                for (String str : sourceList) {
                    if (!(str instanceof String)) continue;
                    targetList.add(str);
                }
            }
        }
        catch (NoSuchMethodException ex) {
            logger.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{source, target, ex.getMessage()});
        }
        catch (SecurityException ex) {
            logger.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{source, target, ex.getMessage()});
        }
        catch (IllegalAccessException ex) {
            logger.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{source, target, ex.getMessage()});
        }
        catch (InvocationTargetException ex) {
            logger.warn("Failed to copy properties for instances {}, {}. Error message was {}", new Object[]{source, target, ex.getMessage()});
        }
    }

    public static boolean toResolve(String propertyName, PropertyReferenceListType resolve) {
        for (PropertyReferenceType property : resolve.getProperty()) {
            XPathType xpath = new XPathType(property.getProperty());
            List segments = xpath.toSegments();
            if (CollectionUtils.isEmpty((Collection)segments) || !Utils.getPropertyName(propertyName).equals(((XPathSegment)segments.get(0)).getQName().getLocalPart())) continue;
            return true;
        }
        return false;
    }

    public static void unresolveResource(ResourceObjectShadowType shadow) {
        if (null != shadow.getResource()) {
            ObjectReferenceType ort = new ObjectReferenceType();
            ort.setOid(shadow.getResource().getOid());
            ort.setType(SchemaConstants.I_RESOURCE_TYPE);
            shadow.setResourceRef(ort);
            shadow.setResource(null);
        }
    }

    public static void unresolveResourceForAccounts(List<? extends ResourceObjectShadowType> shadows) {
        for (ResourceObjectShadowType resourceObjectShadowType : shadows) {
            Utils.unresolveResource(resourceObjectShadowType);
        }
    }

    public static PropertyReferenceType fillPropertyReference(String resolve) {
        PropertyReferenceType property = new PropertyReferenceType();
        XPathType xpath = new XPathType(Utils.getPropertyName(resolve));
        property.setProperty(xpath.toElement("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "property"));
        return property;
    }

    public static PropertyReferenceListType getResolveResourceList() {
        PropertyReferenceListType resolveListType = new PropertyReferenceListType();
        resolveListType.getProperty().add(Utils.fillPropertyReference("Account"));
        resolveListType.getProperty().add(Utils.fillPropertyReference("Resource"));
        return resolveListType;
    }

    public static String getNodeOid(Node node) {
        Node oidNode = null;
        if (null == node.getAttributes() || null == (oidNode = node.getAttributes().getNamedItem("oid")) || StringUtils.isEmpty((String)oidNode.getNodeValue())) {
            return null;
        }
        String oid = oidNode.getNodeValue();
        return oid;
    }

    public static String cleanupUtf(String bad) {
        int cp;
        StringBuilder sb = new StringBuilder(bad.length());
        for (int i = 0; i < bad.length(); i += Character.charCount(cp)) {
            cp = bad.codePointAt(i);
            if (!Utils.isValidXmlCodepoint(cp)) continue;
            sb.append(Character.toChars(cp));
        }
        return sb.toString();
    }

    public static boolean isValidXmlCodepoint(int cp) {
        return cp == 9 || cp == 10 || cp == 13 || cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF;
    }
}

