/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.jaxb.JAXBUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SchemaHandlingType;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObjectTypeUtil {
    static Random rnd = new Random();

    public static List<String> extractOids(List<? extends ObjectType> objects, List<? extends ObjectReferenceType> refs) {
        ArrayList<String> oids = new ArrayList<String>();
        if (objects != null) {
            for (ObjectType objectType : objects) {
                oids.add(objectType.getOid());
            }
        }
        if (refs != null) {
            for (ObjectReferenceType objectReferenceType : refs) {
                oids.add(objectReferenceType.getOid());
            }
        }
        return oids;
    }

    public static ObjectReferenceType findRef(String oid, List<ObjectReferenceType> refs) {
        for (ObjectReferenceType ref : refs) {
            if (!ref.getOid().equals(oid)) continue;
            return ref;
        }
        return null;
    }

    public static PropertyModificationType createPropertyModificationType(PropertyModificationTypeType changeType, XPathType xpathType, Node node) {
        PropertyModificationType change = new PropertyModificationType();
        change.setValue(new PropertyModificationType.Value());
        change.setModificationType(changeType);
        change.setPath(xpathType.toElement("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "path"));
        change.getValue().getAny().add((Element)node);
        return change;
    }

    public static PropertyModificationType createPropertyModificationType(PropertyModificationTypeType changetype, XPathType xpath, QName property, Object value) {
        PropertyModificationType propertyChange = new PropertyModificationType();
        propertyChange.setModificationType(changetype);
        Document doc = DOMUtil.getDocument();
        if (xpath == null) {
            xpath = new XPathType();
        }
        if (property.getPrefix() == null) {
            String prefix = "ch" + rnd.nextInt(10000);
            property = new QName(property.getNamespaceURI(), property.getLocalPart(), prefix);
        }
        propertyChange.setPath(xpath.toElement("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "path", doc));
        PropertyModificationType.Value jaxbValue = new PropertyModificationType.Value();
        if (value instanceof String) {
            Element e = doc.createElementNS(property.getNamespaceURI(), property.getLocalPart());
            e.appendChild(doc.createTextNode((String)value));
            jaxbValue.getAny().add(e);
        } else if (value.getClass().getPackage().equals(ObjectFactory.class.getPackage())) {
            Element e;
            try {
                e = JAXBUtil.jaxbToDom(value, property, doc);
            }
            catch (JAXBException ex) {
                throw new IllegalStateException(ex);
            }
            jaxbValue.getAny().add(e);
        } else {
            throw new IllegalArgumentException("Unsupported value type " + value.getClass().getName());
        }
        propertyChange.setValue(jaxbValue);
        return propertyChange;
    }

    public static SchemaHandlingType.AccountType getAccountTypeDefinitionFromSchemaHandling(ResourceObjectShadowType accountShadow, ResourceType resource) {
        Validate.notNull((Object)accountShadow);
        Validate.notNull((Object)resource);
        SchemaHandlingType schemaHandling = resource.getSchemaHandling();
        QName accountObjectClass = accountShadow.getObjectClass();
        for (SchemaHandlingType.AccountType accountType : schemaHandling.getAccountType()) {
            if (!accountObjectClass.equals(accountType.getObjectClass())) continue;
            return accountType;
        }
        for (SchemaHandlingType.AccountType accountType : schemaHandling.getAccountType()) {
            if (!accountType.isDefault()) continue;
            return accountType;
        }
        throw new IllegalArgumentException("Provided wrong AccountShadow or SchemaHandling. No AccountType definition found for provided account's object class: " + accountObjectClass);
    }
}

