/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.util.Utils;
import com.evolveum.midpoint.util.XPathUtil;
import com.evolveum.midpoint.util.diff.MidPointDifferenceListener;
import com.evolveum.midpoint.util.diff.OidQualifier;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMUtil {
    public static String serializeDOMToString(Node node) {
        return DOMUtil.printDom(node).toString();
    }

    public static Document getDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder loader = factory.newDocumentBuilder();
            return loader.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Error creating XML document " + ex.getMessage());
        }
    }

    public static Document parseDocument(String doc) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder loader = factory.newDocumentBuilder();
            return loader.parse(IOUtils.toInputStream((String)doc, (String)"utf-8"));
        }
        catch (SAXException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage());
        }
    }

    public static String showDom(List<Element> elements) {
        StringBuilder sb = new StringBuilder();
        for (Element element : elements) {
            DOMUtil.showDomNode(element, sb, 0);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static StringBuffer printDom(Node node) {
        StringWriter writer = new StringWriter();
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setParameter("encoding", "utf-8");
            DOMSource source = new DOMSource(node);
            trans.transform(source, new StreamResult(writer));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return writer.getBuffer();
    }

    private static void showDomNode(Node node, StringBuilder sb, int level) {
        if (sb == null) {
            return;
        }
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        if (node == null) {
            sb.append("null\n");
        } else {
            sb.append(node.getNodeName());
            sb.append(" (");
            NamedNodeMap attributes = node.getAttributes();
            boolean broken = false;
            if (attributes != null) {
                for (int ii = 0; ii < attributes.getLength(); ++ii) {
                    Node attribute = attributes.item(ii);
                    sb.append(attribute.getPrefix());
                    sb.append(":");
                    sb.append(attribute.getLocalName());
                    sb.append("='");
                    sb.append(attribute.getNodeValue());
                    sb.append("',");
                    if (attribute.getPrefix() != null || !attribute.getLocalName().equals("xmlns") || attribute.getNodeValue() != null && !attribute.getNodeValue().isEmpty()) continue;
                    broken = true;
                }
            }
            sb.append(")");
            if (broken) {
                sb.append(" *** WARNING: empty default namespace");
            }
            sb.append("\n");
            NodeList childNodes = node.getChildNodes();
            for (int ii = 0; ii < childNodes.getLength(); ++ii) {
                Node subnode = childNodes.item(ii);
                DOMUtil.showDomNode(subnode, sb, level + 1);
            }
        }
    }

    private static void setupXmlUnitPatchTool() {
        XMLUnit.setCompareUnmatched((boolean)false);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
    }

    private static boolean isEqualsNode(Node node, Node newNode) {
        if (null == node && null == newNode) {
            return true;
        }
        if (null != node && null == newNode) {
            return false;
        }
        if (null == node && null != newNode) {
            return false;
        }
        DOMUtil.setupXmlUnitPatchTool();
        Document doc = DOMUtil.getDocument();
        Document newDoc = DOMUtil.getDocument();
        doc.appendChild(doc.adoptNode(node));
        newDoc.appendChild(newDoc.adoptNode(newNode));
        Diff d = new Diff(doc, newDoc);
        DetailedDiff dd = new DetailedDiff(d);
        dd.overrideElementQualifier((ElementQualifier)new OidQualifier());
        dd.overrideDifferenceListener((DifferenceListener)new MidPointDifferenceListener());
        List differences = dd.getAllDifferences();
        return differences.size() == 0;
    }

    private static boolean oidEquals(Node node, Node value) {
        String oid = Utils.getNodeOid(node);
        String newOid = Utils.getNodeOid(value);
        if (null == oid && null == newOid) {
            return true;
        }
        if (null != oid && null != newOid) {
            return oid.equals(newOid);
        }
        return false;
    }

    public static void addChildNodes(Node parentNode, Node newNode) {
        Document parentDoc = parentNode.getOwnerDocument();
        Node adoptedNode = parentDoc.importNode(newNode, true);
        parentNode.appendChild(adoptedNode);
    }

    public static void addChildNodes(Node parentNode, List<Element> newNodes) {
        for (Element newNode : newNodes) {
            DOMUtil.addChildNodes(parentNode, newNode);
        }
    }

    public static void deleteChildNodes(Node parentNode, Node newNode) {
        NodeList childNodes = parentNode.getChildNodes();
        String newNodeName = newNode.getLocalName();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node child = childNodes.item(j);
            if (null == child.getLocalName() || !child.getLocalName().equals(newNodeName) || !DOMUtil.oidEquals(child, newNode)) continue;
            parentNode.removeChild(child);
        }
    }

    private static void removeChildNodes(Node parentNode, String newNodeName) {
        NodeList childNodes = parentNode.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node child = childNodes.item(j);
            if (null == child.getLocalName() || !child.getLocalName().equals(newNodeName)) continue;
            parentNode.removeChild(child);
        }
    }

    public static void replaceChildNodes(Node parentNode, Element newNode) {
        DOMUtil.removeChildNodes(parentNode, newNode.getLocalName());
        DOMUtil.addChildNodes(parentNode, newNode);
    }

    public static void replaceChildNodes(Node parentNode, List<Element> newNodes) {
        if (null == newNodes || newNodes.size() == 0) {
            return;
        }
        String newNodeName = newNodes.get(0).getLocalName();
        for (Element newNode : newNodes) {
            if (StringUtils.equals((String)newNodeName, (String)newNode.getLocalName())) continue;
            throw new IllegalArgumentException("Provided list of new nodes contains nodes with different names: " + newNodes);
        }
        DOMUtil.removeChildNodes(parentNode, newNodeName);
        DOMUtil.addChildNodes(parentNode, newNodes);
    }

    public static Node getNextSiblingElement(Node node) {
        if (node == null || node.getParentNode() == null) {
            return null;
        }
        Node parent = node.getParentNode();
        NodeList nodes = parent.getChildNodes();
        if (nodes == null) {
            return null;
        }
        boolean found = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.equals(node)) {
                found = true;
                continue;
            }
            if (!found || child.getNodeType() != 1) continue;
            return child;
        }
        return null;
    }

    public static Node getFirstChildElement(Node parent) {
        if (parent == null || parent.getChildNodes() == null) {
            return null;
        }
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            return child;
        }
        return null;
    }

    public static void createNodesDefinedByXPath(Document doc, XPathType xpathType) {
        Validate.notNull((Object)doc, (String)"Provided parameter doc was null");
        Validate.notNull((Object)xpathType, (String)"Provided parameter xpathType was null");
        List segments = xpathType.toSegments();
        if (null != segments) {
            int i;
            Node docChildToWhichAppend = (Element)doc.getFirstChild();
            for (i = 0; i < segments.size(); ++i) {
                NodeList nodes;
                try {
                    XPathType path = null;
                    path = new XPathType(segments.subList(0, i + 1));
                    nodes = new XPathUtil().matchedNodesByXPath(path, null, doc.getFirstChild());
                }
                catch (XPathExpressionException ex) {
                    throw new IllegalArgumentException(ex);
                }
                if (null == nodes || nodes.getLength() == 0) break;
                docChildToWhichAppend = docChildToWhichAppend.getFirstChild();
            }
            if (i < segments.size()) {
                Element parentElement = null;
                Element element = null;
                for (int j = i; j < segments.size(); ++j) {
                    QName qname = ((XPathSegment)segments.get(j)).getQName();
                    if (null == parentElement) {
                        element = parentElement = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
                        continue;
                    }
                    Element child = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
                    element.appendChild(child);
                    element = child;
                }
                docChildToWhichAppend.appendChild(parentElement);
            }
        }
    }
}

