/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.util.diff.CalculateXmlDiff;
import com.evolveum.midpoint.util.diff.DiffException;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import java.util.List;

public class UnlinkAccountAction
extends BaseAction {
    private static Trace trace = TraceManager.getTrace(UnlinkAccountAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescriptionType change, SynchronizationSituationType situation, ResourceObjectShadowType shadowAfterChange) throws SynchronizationException {
        trace.trace("executeChanges::start");
        UserType userType = this.getUser(userOid);
        UserType oldUserType = this.getUser(userOid);
        ResourceObjectShadowType resourceShadow = change.getShadow();
        if (userType == null) {
            throw new SynchronizationException("Can't unlink account. User with oid '" + userOid + "' doesn't exits. Try insert create action before this action.");
        }
        List references = userType.getAccountRef();
        ObjectReferenceType accountRef = null;
        for (ObjectReferenceType reference : references) {
            if (!SchemaConstants.I_ACCOUNT_REF.equals(reference.getType()) || !reference.getOid().equals(resourceShadow.getOid())) continue;
            accountRef = reference;
            break;
        }
        if (accountRef != null) {
            trace.debug("Removing account ref {} from user {}.", new Object[]{accountRef.getOid(), userOid});
            references.remove(accountRef);
            try {
                ObjectModificationType changes = CalculateXmlDiff.calculateChanges((ObjectType)oldUserType, (ObjectType)userType);
                this.getModel().modifyObject(changes);
            }
            catch (FaultMessage ex) {
                throw new SynchronizationException("Can't unlink account. Can't save user", ex, ex.getFaultInfo());
            }
            catch (DiffException ex) {
                trace.error("Couldn't create user diff for '{}', reason: {}.", (Object)userOid, (Object)ex.getMessage());
                throw new SynchronizationException("Couldn't create user diff for '" + userOid + "'.", ex);
            }
        }
        trace.trace("executeChanges::end");
        return userOid;
    }
}

