/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class ModifyPasswordAction
extends BaseAction {
    private static Trace trace = TraceManager.getTrace(ModifyPasswordAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescriptionType change, SynchronizationSituationType situation, ResourceObjectShadowType shadowAfterChange) throws SynchronizationException {
        UserType userType = this.getUser(userOid);
        if (userType == null) {
            throw new SynchronizationException("Can't find user with oid '" + userOid + "'.");
        }
        if (!(change.getObjectChange() instanceof ObjectChangeModificationType)) {
            throw new SynchronizationException("Object change is not instacne of " + ObjectChangeModificationType.class.getName());
        }
        PropertyModificationType pwd = this.getPasswordFromModification((ObjectChangeModificationType)change.getObjectChange());
        if (pwd == null) {
            trace.error("Couldn't find property modification with password change, returning.");
            return userOid;
        }
        try {
            ObjectModificationType changes = this.createPasswordModification(userType, pwd);
            this.getModel().modifyObjectWithExclusion(changes, change.getShadow().getOid());
        }
        catch (FaultMessage ex) {
            throw new SynchronizationException("Can't save user", ex, ex.getFaultInfo());
        }
        return userOid;
    }

    private ObjectModificationType createPasswordModification(UserType user, PropertyModificationType password) {
        ObjectModificationType changes = new ObjectModificationType();
        changes.setOid(user.getOid());
        changes.getPropertyModification().add(password);
        return changes;
    }

    private PropertyModificationType getPasswordFromModification(ObjectChangeModificationType objectChange) {
        List list = objectChange.getObjectModification().getPropertyModification();
        for (PropertyModificationType propModification : list) {
            PropertyModificationType.Value value;
            XPathType path = new XPathType(propModification.getPath());
            List segments = path.toSegments();
            if (segments.size() == 0 || !((XPathSegment)segments.get(0)).getQName().equals(SchemaConstants.I_CREDENTIALS) || (value = propModification.getValue()) == null) continue;
            List elements = value.getAny();
            for (Element element : elements) {
                if (!SchemaConstants.I_PASSWORD.equals(new QName(element.getNamespaceURI(), element.getLocalName()))) continue;
                return propModification;
            }
        }
        return null;
    }
}

