/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.Utils;
import com.evolveum.midpoint.util.diff.CalculateXmlDiff;
import com.evolveum.midpoint.util.diff.DiffException;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage;

public class LinkAccountAction
extends BaseAction {
    private static Trace trace = TraceManager.getTrace(LinkAccountAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescriptionType change, SynchronizationSituationType situation, ResourceObjectShadowType shadowAfterChange) throws SynchronizationException {
        UserType userType = this.getUser(userOid);
        UserType oldUserType = this.getUser(userOid);
        ResourceObjectShadowType resourceShadow = change.getShadow();
        if (userType != null) {
            if (!(resourceShadow instanceof AccountShadowType)) {
                throw new SynchronizationException("Can't link resource object of type '" + resourceShadow.getClass() + "', only '" + AccountShadowType.class + "' can be linked.");
            }
            ObjectReferenceType accountRef = new ObjectReferenceType();
            accountRef.setOid(resourceShadow.getOid());
            accountRef.setType(QNameUtil.uriToQName((String)Utils.getObjectType((String)"AccountType")));
            userType.getAccountRef().add(accountRef);
            try {
                ObjectModificationType changes = CalculateXmlDiff.calculateChanges((ObjectType)oldUserType, (ObjectType)userType);
                this.getModel().modifyObject(changes);
            }
            catch (FaultMessage ex) {
                trace.error("Error while saving user {} (modifyObject on model).", new Object[]{userOid});
                throw new SynchronizationException("Can't link account. Can't save user", ex, ex.getFaultInfo());
            }
            catch (DiffException ex) {
                trace.error("Couldn't create user diff for '{}', reason: {}.", new Object[]{userOid, ex.getMessage()});
                throw new SynchronizationException("Couldn't create user diff for '" + userOid + "', reason: " + ex.getMessage(), ex);
            }
        } else {
            throw new SynchronizationException("User with oid '" + userOid + "' doesn't exits. Try insert create action before this action.");
        }
        return userOid;
    }
}

