/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.util.diff.CalculateXmlDiff;
import com.evolveum.midpoint.util.diff.DiffException;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ActivationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.FaultMessage;
import javax.xml.ws.Holder;

public class DisableAccountAction
extends BaseAction {
    private static Trace trace = TraceManager.getTrace(DisableAccountAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescriptionType change, SynchronizationSituationType situation, ResourceObjectShadowType shadowAfterChange) throws SynchronizationException {
        if (!(change.getShadow() instanceof AccountShadowType)) {
            throw new SynchronizationException("Resource object is not account (class '" + AccountShadowType.class + "'), but it's '" + change.getShadow().getClass() + "'.");
        }
        AccountShadowType account = (AccountShadowType)change.getShadow();
        ActivationType activation = account.getActivation();
        if (activation == null) {
            ObjectFactory of = new ObjectFactory();
            activation = of.createActivationType();
            account.setActivation(activation);
        }
        activation.setEnabled(Boolean.valueOf(false));
        try {
            ObjectContainerType container = this.getProvisioning().getObject(account.getOid(), new PropertyReferenceListType(), new Holder());
            AccountShadowType oldAccount = (AccountShadowType)container.getObject();
            ObjectModificationType changes = CalculateXmlDiff.calculateChanges((ObjectType)oldAccount, (ObjectType)account);
            ScriptsType scripts = this.getScripts(change.getResource());
            this.getProvisioning().modifyObject(changes, scripts, new Holder());
        }
        catch (DiffException ex) {
            trace.error("Couldn't disable account {}, error while creating diff: {}.", new Object[]{account.getOid(), ex.getMessage()});
            throw new SynchronizationException("Couldn't disable account " + account.getOid() + ", error while creating diff: " + ex.getMessage() + ".", ex);
        }
        catch (FaultMessage ex) {
            trace.error("Couldn't update (disable) account '{}' in provisioning, reason: {}.", new Object[]{account.getOid(), this.getMessage(ex)});
            throw new SynchronizationException("Couldn't update (disable) account '" + account.getOid() + "' in provisioning, reason: " + this.getMessage(ex) + ".", ex, ex.getFaultInfo());
        }
        return userOid;
    }

    private String getMessage(FaultMessage ex) {
        String message = null;
        message = ex.getFaultInfo() != null ? ex.getFaultInfo().getMessage() : ex.getMessage();
        return message;
    }
}

