/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.FaultMessage;
import javax.xml.ws.Holder;

public class DeleteAccountAction
extends BaseAction {
    private static Trace trace = TraceManager.getTrace(DeleteAccountAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescriptionType change, SynchronizationSituationType situation, ResourceObjectShadowType shadowAfterChange) throws SynchronizationException {
        try {
            ScriptsType scripts = this.getScripts(change.getResource());
            this.getProvisioning().deleteObject(change.getShadow().getOid(), scripts, new Holder());
        }
        catch (FaultMessage ex) {
            ResourceType resource = change.getResource();
            String resourceName = resource == null ? "Undefined" : resource.getName();
            trace.error("Couldn't delete resource object with oid '{}' on resource '{}'.", new Object[]{change.getShadow().getOid(), resourceName});
            throw new SynchronizationException("Couldn't delete resource object with oid '" + change.getShadow().getOid() + "' on resource '" + resourceName + "'.", ex, ex.getFaultInfo());
        }
        return userOid;
    }
}

