/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.util.Utils;
import com.evolveum.midpoint.xml.ns._public.common.common_1.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.model.model_1.FaultMessage;

public class AddAccountAction
extends BaseAction {
    private static Trace trace = TraceManager.getTrace(AddAccountAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescriptionType change, SynchronizationSituationType situation, ResourceObjectShadowType shadowAfterChange) throws SynchronizationException {
        if (!(change.getShadow() instanceof AccountShadowType)) {
            throw new SynchronizationException("Resource object is not account (class '" + AccountShadowType.class + "'), but it's '" + change.getShadow().getClass() + "'.");
        }
        ObjectFactory of = new ObjectFactory();
        AccountShadowType account = (AccountShadowType)change.getShadow();
        Utils.unresolveResource((ResourceObjectShadowType)account);
        try {
            ObjectContainerType container = of.createObjectContainerType();
            container.setObject((ObjectType)account);
            this.getModel().addObject(container);
        }
        catch (FaultMessage ex) {
            trace.error("Couldn't add account to provisioning, reason: " + this.getMessage(ex));
            throw new SynchronizationException("Can't add account to provisioning.", ex, ex.getFaultInfo());
        }
        return userOid;
    }

    private String getMessage(FaultMessage ex) {
        String message = null;
        message = ex.getFaultInfo() != null ? ex.getFaultInfo().getMessage() : ex.getMessage();
        return message;
    }
}

