/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.action;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.ModelService;
import com.evolveum.midpoint.model.action.Action;
import com.evolveum.midpoint.model.action.ActionManager;
import com.evolveum.midpoint.model.action.BaseAction;
import com.evolveum.midpoint.model.xpath.SchemaHandling;
import com.evolveum.midpoint.provisioning.service.ProvisioningService;
import com.evolveum.midpoint.xml.ns._public.model.model_1.ModelPortType;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.ProvisioningPortType;
import java.util.Map;

public class ActionManagerImpl<T extends Action>
implements ActionManager<T> {
    private static transient Trace trace = TraceManager.getTrace(ActionManagerImpl.class);
    private Map<String, Class<T>> actionMap;
    private ModelPortType model;
    private ProvisioningPortType provisioning;
    private SchemaHandling schemaHandling;

    @Override
    public void setActionMapping(Map<String, Class<T>> actionMap) {
        this.actionMap = actionMap;
    }

    @Override
    public Action getActionInstance(String uri) {
        Class<T> clazz = this.actionMap.get(uri);
        if (clazz == null) {
            return null;
        }
        Action action = null;
        try {
            action = (Action)clazz.newInstance();
            ((BaseAction)action).setModel((ModelService)this.model);
            ((BaseAction)action).setProvisioning((ProvisioningService)this.provisioning);
            ((BaseAction)action).setSchemaHandling(this.schemaHandling);
        }
        catch (InstantiationException ex) {
            trace.error("Couln't create action instance, reason: {}.", (Object)ex.getMessage());
            trace.debug("Couln't create action instance.", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            trace.error("Couln't create action instance, reason: {}.", (Object)ex.getMessage());
            trace.debug("Couln't create action instance.", (Throwable)ex);
        }
        return action;
    }

    public void setModel(ModelPortType model) {
        this.model = model;
    }

    public void setProvisioning(ProvisioningPortType provisioning) {
        this.provisioning = provisioning;
    }

    public void setSchemaHandling(SchemaHandling schemaHandling) {
        this.schemaHandling = schemaHandling;
    }
}

