/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.model.SynchronizationException;
import com.evolveum.midpoint.model.action.Action;
import com.evolveum.midpoint.model.action.ActionManager;
import com.evolveum.midpoint.model.xpath.SchemaHandling;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.patch.PatchException;
import com.evolveum.midpoint.util.patch.PatchXml;
import com.evolveum.midpoint.xml.ns._public.common.common_1.EmptyType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.FaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.IllegalArgumentFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeAdditionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeDeletionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.QueryType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SynchronizationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.SystemFaultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.ProvisioningPortType;
import com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.ResourceObjectChangeListenerPortType;
import com.evolveum.midpoint.xml.ns._public.repository.repository_1.RepositoryPortType;
import com.evolveum.midpoint.xml.schema.ExpressionHolder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class ResourceObjectChangeService
implements ResourceObjectChangeListenerPortType {
    private static transient Trace trace = TraceManager.getTrace(ResourceObjectChangeService.class);
    @Autowired(required=true)
    private ProvisioningPortType provisioning;
    @Autowired(required=true)
    private RepositoryPortType repository;
    @Autowired(required=true)
    private ActionManager actionManager;
    @Autowired(required=true)
    private SchemaHandling schemaHandling;
    private PatchXml patchXml = new PatchXml();

    public EmptyType notifyChange(ResourceObjectShadowChangeDescriptionType change) throws com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage {
        ResourceType resource;
        trace.info("### MODEL # Enter notifyChange({})", (Object)DebugUtil.prettyPrint((ResourceObjectShadowChangeDescriptionType)change));
        ObjectChangeType objectChange = change.getObjectChange();
        if (objectChange == null) {
            IllegalArgumentFaultType fault = new IllegalArgumentFaultType();
            fault.setMessage("Object change not defined.");
            fault.setTemporary(true);
            trace.error("### MODEL # Fault notifyChange(..): Object change not defined.");
            throw new com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage(fault.getMessage(), (FaultType)fault);
        }
        ResourceObjectShadowType resourceShadow = change.getShadow();
        if (resourceShadow == null) {
            if (change.getObjectChange() instanceof ObjectChangeAdditionType) {
                resourceShadow = (ResourceObjectShadowType)((ObjectChangeAdditionType)change.getObjectChange()).getObject();
            } else {
                trace.error("### MODEL # Fault notifyChange(..): Change doesn't contain ResourceObjectShadow");
                throw this.createFaultMessage("Change doesn't contain ResourceObjectShadow.", (FaultType)new SystemFaultType(), null);
            }
        }
        if ((resource = change.getResource()) == null) {
            trace.error("### MODEL # Fault notifyChange(..): Change doesn't contain resource");
            throw this.createFaultMessage("Change doesn't contain resource", null, null);
        }
        ResourceObjectShadowType shadowAfterChange = null;
        try {
            shadowAfterChange = this.getObjectAfterChange(resourceShadow, objectChange);
        }
        catch (PatchException ex) {
            throw this.createFaultMessage("The changes cannot be applied to the shadow", (FaultType)new IllegalArgumentFaultType(), (Exception)((Object)ex));
        }
        SynchronizationType synchronization = resource.getSynchronization();
        if (synchronization == null) {
            trace.warn("Skipping synchronization on resource: {}. Synchronization element not defined.", (Object)resource.getName());
            trace.warn("### MODEL # Exit notifyChange(...): Skipping synchronization, synchronization element not defined.");
            return new EmptyType();
        }
        SituationState state = this.checkSituation(change);
        if (state.situation == null) {
            trace.error("### MODEL # Fault notifyChange(..): Change on account with oid '{}' couldn't match to any of defined situation.", (Object)resourceShadow.getOid());
            throw this.createFaultMessage("Change on account with oid '" + resourceShadow.getOid() + "' couldn't match to any of defined situation.", null, null);
        }
        trace.info("SITUATION: Determined situation {} for shadow {} (user {})", new Object[]{state.situation, DebugUtil.prettyPrint((ObjectType)resourceShadow), DebugUtil.prettyPrint((ObjectType)state.user)});
        this.notifyChange(change, state, resource, shadowAfterChange);
        trace.info("### MODEL # Exit notifyChange(...)");
        return new EmptyType();
    }

    private void notifyChange(ResourceObjectShadowChangeDescriptionType change, SituationState state, ResourceType resource, ResourceObjectShadowType shadowAfterChange) throws com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage {
        SynchronizationType synchronization = resource.getSynchronization();
        List<Action> actions = this.findActionsForReaction(synchronization.getReaction(), state.situation);
        if (actions.isEmpty()) {
            trace.warn("Skipping synchronization on resource: {}. Action not found.", (Object)resource.getName());
            return;
        }
        if (change.getShadow() != null && change.getShadow().getResource() == null) {
            if (change.getShadow().getResourceRef() != null && !change.getShadow().getResourceRef().getOid().equals(resource.getOid())) {
                throw this.createFaultMessage("OID of resource does not match OID in shadow resourceRef", (FaultType)new SystemFaultType(), null);
            }
            change.getShadow().setResource(resource);
        }
        try {
            trace.trace("Updating user started.");
            String userOid = state.user == null ? null : state.user.getOid();
            for (Action action : actions) {
                trace.debug("ACTION: Executing: {}.", action.getClass());
                userOid = action.executeChanges(userOid, change, state.situation, shadowAfterChange);
            }
            trace.trace("Updating user finished.");
        }
        catch (SynchronizationException ex) {
            trace.error("### MODEL # Fault notifyChange(..): Synchronization action failed, reason: {}.", (Object)ex.getMessage());
            throw this.createFaultMessage("Synchronization action failed, reason: " + this.getMessage(ex), ex.getFaultType(), ex);
        }
        catch (Exception ex) {
            trace.error("### MODEL # Fault notifyChange(..): Unexpected error occured, synchronization action failed, reason: {}.", (Object)ex.getMessage());
            throw this.createFaultMessage("Unexpected error occured, synchronization action failed.", null, ex);
        }
    }

    private String getMessage(SynchronizationException ex) {
        if (ex.getFaultType() != null) {
            return ex.getFaultType().getMessage();
        }
        return ex.getMessage();
    }

    private List<Action> findActionsForReaction(List<SynchronizationType.Reaction> reactions, SynchronizationSituationType situation) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (reactions == null) {
            return actions;
        }
        SynchronizationType.Reaction reaction = null;
        for (SynchronizationType.Reaction react : reactions) {
            if (react.getSituation() == null) {
                trace.warn("Reaction ({}) doesn't contain situation element, skipping.", (Object)reactions.indexOf(react));
                continue;
            }
            if (!situation.equals((Object)react.getSituation())) continue;
            reaction = react;
            break;
        }
        if (reaction == null) {
            trace.warn("Reaction on situation {} was not found.", (Object)situation);
            return actions;
        }
        List actionList = reaction.getAction();
        for (SynchronizationType.Reaction.Action actionXml : actionList) {
            if (actionXml == null) {
                trace.warn("Reaction ({}) doesn't contain action element, skipping.", (Object)reactions.indexOf(reaction));
                return actions;
            }
            if (actionXml.getRef() == null) {
                trace.warn("Reaction ({}): Action element doesn't contain ref attribute, skipping.", (Object)reactions.indexOf(reaction));
                return actions;
            }
            Action action = this.actionManager.getActionInstance(actionXml.getRef());
            if (action == null) {
                trace.warn("Couln't create action with uri '{}' for reaction {}, skipping action.", (Object)actionXml.getRef(), (Object)reactions.indexOf(reaction));
                continue;
            }
            action.setParameters(actionXml.getAny());
            actions.add(action);
        }
        return actions;
    }

    private com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage createFaultMessage(String message, FaultType faultType, Exception ex) {
        if (faultType == null) {
            faultType = new SystemFaultType();
        }
        if (faultType.getMessage() == null || faultType.getMessage().isEmpty()) {
            if (ex != null) {
                faultType.setMessage(message + ":" + ex.getMessage());
            } else {
                faultType.setMessage(message);
            }
        }
        return new com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage(message, faultType, (Throwable)ex);
    }

    private Element updateFilterWithAccountValues(ResourceObjectShadowType resourceObjectShadow, Element filter) {
        trace.trace("updateFilterWithAccountValues::begin");
        if (filter == null) {
            return null;
        }
        try {
            trace.trace("Transforming search filter from:\n{}", (Object)DOMUtil.printDom((Node)filter.getOwnerDocument()));
            Document document = DOMUtil.getDocument();
            String prefix = filter.lookupPrefix("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd") == null ? "c" : filter.lookupPrefix("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd");
            Element and = document.createElementNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", prefix + ":and");
            document.appendChild(and);
            Element type = document.createElementNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", prefix + ":type");
            type.setAttribute("uri", "http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd#UserType");
            and.appendChild(type);
            if ("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd".equals(filter.getNamespaceURI()) && "equal".equals(filter.getLocalName())) {
                Element valueExpression;
                Element equal = (Element)document.adoptNode(filter.cloneNode(true));
                and.appendChild(equal);
                Element path = this.findChildElement(equal, "http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "path");
                if (path != null) {
                    equal.removeChild(path);
                }
                if ((valueExpression = this.findChildElement(equal, "http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "valueExpression")) != null) {
                    equal.removeChild(valueExpression);
                    String ref = valueExpression.getAttribute("ref");
                    String namespace = filter.getOwnerDocument().getNamespaceURI();
                    if (ref.contains(":")) {
                        String pref = ref.substring(0, ref.indexOf(":"));
                        namespace = filter.lookupNamespaceURI(pref);
                    }
                    Element value = document.createElementNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", prefix + ":value");
                    equal.appendChild(value);
                    Element attribute = document.createElementNS(namespace, ref);
                    String expressionResult = this.resolveValueExpression(path, valueExpression, resourceObjectShadow);
                    trace.debug("Search filter expression in the rule for OID {} evaluated to '{}'", (Object)resourceObjectShadow.getOid(), (Object)expressionResult);
                    attribute.setTextContent(expressionResult);
                    value.appendChild(attribute);
                } else {
                    trace.warn("No valueExpression in rule for OID {}", (Object)resourceObjectShadow.getOid());
                }
            }
            filter = and;
            trace.trace("Transforming filter to:\n{}", (Object)DOMUtil.printDom((Node)filter.getOwnerDocument()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        trace.trace("updateFilterWithAccountValues::end");
        return filter;
    }

    private String resolveValueExpression(Element path, Element expression, ResourceObjectShadowType resourceObjectShadow) {
        return this.schemaHandling.evaluateCorrelationExpression(resourceObjectShadow, new ExpressionHolder(expression));
    }

    private Element findChildElement(Element element, String namespace, String name) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !namespace.equals(node.getNamespaceURI()) || !name.equals(node.getLocalName())) continue;
            return (Element)node;
        }
        return null;
    }

    private List<UserType> findUsersByCorrelationRule(ResourceObjectShadowType resourceShadow, QueryType query) throws com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage {
        ArrayList<UserType> users = new ArrayList<UserType>();
        if (query == null) {
            trace.error("Corrrelation rule for resource '{}' doesn't contain query, returning empty list of users.", (Object)resourceShadow.getName());
            return users;
        }
        Element element = query.getFilter();
        if (element == null) {
            trace.error("Corrrelation rule for resource '{}' doesn't contain query, returning empty list of users.", (Object)resourceShadow.getName());
            return users;
        }
        Element filter = this.updateFilterWithAccountValues(resourceShadow, element);
        try {
            Holder holder = new Holder();
            ObjectFactory of = new ObjectFactory();
            query = of.createQueryType();
            query.setFilter(filter);
            trace.debug("CORRELATION: expression for OID {} results in filter {}", (Object)resourceShadow.getOid(), (Object)DebugUtil.prettyPrint((QueryType)query));
            PagingType paging = new PagingType();
            ObjectListType container = this.provisioning.searchObjects(query, paging, holder);
            if (container == null) {
                return users;
            }
            List objects = container.getObject();
            for (ObjectType object : objects) {
                if (!(object instanceof UserType)) continue;
                users.add((UserType)object);
            }
        }
        catch (FaultMessage ex) {
            ex.printStackTrace();
        }
        trace.debug("CORRELATION: expression for OID {} returned {} users.", (Object)resourceShadow.getOid(), (Object)users.size());
        return users;
    }

    private List<UserType> findUserByConfirmationRule(List<UserType> users, ResourceObjectShadowType resourceObjectShadowType, ExpressionHolder expression) {
        ArrayList<UserType> list = new ArrayList<UserType>();
        for (UserType user : users) {
            if (user == null || !this.schemaHandling.confirmUser(user, resourceObjectShadowType, expression)) continue;
            list.add(user);
        }
        trace.debug("CONFIRMATION: expression for OID {} matched {} users.", (Object)resourceObjectShadowType.getOid(), (Object)list.size());
        return list;
    }

    private SituationState checkSituation(ResourceObjectShadowChangeDescriptionType change) throws com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage {
        UserType userType;
        SynchronizationSituationType situation;
        block21: {
            trace.trace("checkSituation::begin");
            if (change.getShadow() != null) {
                trace.trace("Determining situation for OID {}", (Object)change.getShadow().getOid());
            } else {
                trace.trace("Determining situation for [new resource object]");
            }
            ResourceObjectShadowType resourceShadow = change.getShadow();
            ModificationType modType = this.getModificationType(change.getObjectChange());
            ResourceType resource = change.getResource();
            SynchronizationType synchronization = resource.getSynchronization();
            situation = null;
            userType = null;
            try {
                UserContainerType userContainer = null;
                if (resourceShadow != null && resourceShadow.getOid() != null && !resourceShadow.getOid().isEmpty()) {
                    userContainer = this.repository.listAccountShadowOwner(resourceShadow.getOid());
                }
                if (userContainer != null) {
                    userType = userContainer.getUser();
                }
                if (userType != null) {
                    trace.trace("Shadow OID {} does have owner: {}", (Object)change.getShadow().getOid(), (Object)userType.getOid());
                    switch (modType) {
                        case ADD: 
                        case MODIFY: {
                            situation = SynchronizationSituationType.CONFIRMED;
                            break;
                        }
                        case DELETE: {
                            situation = SynchronizationSituationType.DELETED;
                        }
                    }
                    break block21;
                }
                trace.trace("Resource object shadow doesn't have owner.");
                ResourceObjectShadowType objectAfterChange = null;
                try {
                    objectAfterChange = this.getObjectAfterChange(resourceShadow, change.getObjectChange());
                }
                catch (PatchException ex) {
                    throw this.createFaultMessage("Application of changes to object failed", null, (Exception)((Object)ex));
                }
                trace.trace("Object after change: {}", (Object)DebugUtil.prettyPrint((ObjectType)objectAfterChange));
                List<UserType> users = this.findUsersByCorrelationRule(objectAfterChange, synchronization.getCorrelation());
                if (synchronization.getConfirmation() == null) {
                    if (resourceShadow != null) {
                        trace.debug("CONFIRMATION: No expression for OID {}, accepting all results of correlation", (Object)resourceShadow.getOid());
                    } else {
                        trace.debug("CONFIRMATION: No expression for [new resource object], accepting all results of correlation");
                    }
                } else {
                    users = this.findUserByConfirmationRule(users, objectAfterChange, new ExpressionHolder(synchronization.getConfirmation()));
                }
                switch (users.size()) {
                    case 0: {
                        situation = SynchronizationSituationType.UNMATCHED;
                        break;
                    }
                    case 1: {
                        situation = ModificationType.ADD.equals((Object)modType) ? SynchronizationSituationType.FOUND : SynchronizationSituationType.UNASSIGNED;
                        userType = users.get(0);
                        break;
                    }
                    default: {
                        situation = SynchronizationSituationType.DISPUTED;
                    }
                }
            }
            catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
                trace.error("Error occured during resource object shadow owner lookup.");
                throw this.createFaultMessage("Error occured during resource object shadow owner lookup.", ex.getFaultInfo(), (Exception)((Object)ex));
            }
        }
        trace.trace("checkSituation::end - '{}', '{}'", (Object)(userType == null ? "null" : userType.getOid()), (Object)situation);
        return new SituationState(userType, situation);
    }

    private ResourceObjectShadowType getObjectAfterChange(ResourceObjectShadowType resourceShadow, ObjectChangeType objectChange) throws PatchException {
        if (objectChange instanceof ObjectChangeAdditionType) {
            ObjectChangeAdditionType objectAddition = (ObjectChangeAdditionType)objectChange;
            ObjectType object = objectAddition.getObject();
            if (object instanceof ResourceObjectShadowType) {
                return (ResourceObjectShadowType)object;
            }
            throw new IllegalArgumentException("The changed object is not a shadow, it is " + object.getClass().getName());
        }
        if (objectChange instanceof ObjectChangeModificationType) {
            ObjectChangeModificationType objectModification = (ObjectChangeModificationType)objectChange;
            ObjectModificationType modification = objectModification.getObjectModification();
            this.patchXml.applyDifferences(modification, (ObjectType)resourceShadow);
            return resourceShadow;
        }
        if (objectChange instanceof ObjectChangeDeletionType) {
            return resourceShadow;
        }
        throw new IllegalArgumentException("Unknown change type " + objectChange.getClass().getName());
    }

    private ModificationType getModificationType(ObjectChangeType change) throws com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage {
        if (change == null) {
            throw new IllegalArgumentException("Can't check modification type, object change type is null.");
        }
        if (change instanceof ObjectChangeAdditionType) {
            return ModificationType.ADD;
        }
        if (change instanceof ObjectChangeModificationType) {
            return ModificationType.MODIFY;
        }
        if (change instanceof ObjectChangeDeletionType) {
            return ModificationType.DELETE;
        }
        throw this.createFaultMessage("Unknown modification type - change '" + change.getClass() + "'.", null, null);
    }

    private static class SituationState {
        UserType user;
        SynchronizationSituationType situation;

        private SituationState(UserType user, SynchronizationSituationType situation) {
            this.user = user;
            this.situation = situation;
        }
    }

    private static enum ModificationType {
        ADD,
        DELETE,
        MODIFY;

    }
}

