/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.api.logging.Trace;
import com.evolveum.midpoint.logging.TraceManager;
import com.evolveum.midpoint.provisioning.util.ShadowUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.QueryUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectChangeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectContainerType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.OperationalResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyModificationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.QueryType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowChangeDescriptionType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.UserType;
import com.evolveum.midpoint.xml.ns._public.model.password_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.model.password_1.PasswordChangeRequestType;
import com.evolveum.midpoint.xml.ns._public.model.password_1.PasswordChangeResponseType;
import com.evolveum.midpoint.xml.ns._public.model.password_1.PasswordPortType;
import com.evolveum.midpoint.xml.ns._public.model.password_1.PasswordSynchronizeRequestType;
import com.evolveum.midpoint.xml.ns._public.model.password_1.SelfPasswordChangeRequestType;
import com.evolveum.midpoint.xml.ns._public.model.password_1.TargetAccountType;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.provisioning.provisioning_1.ProvisioningPortType;
import com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.ResourceObjectChangeListenerPortType;
import com.evolveum.midpoint.xml.ns._public.repository.repository_1.RepositoryPortType;
import com.evolveum.midpoint.xml.schema.SchemaConstants;
import com.evolveum.midpoint.xml.schema.XPathSegment;
import com.evolveum.midpoint.xml.schema.XPathType;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.Holder;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Service
public class PasswordService
implements PasswordPortType {
    public static final String code_id = "$Id$";
    private static final Trace logger = TraceManager.getTrace(PasswordService.class);
    @Autowired(required=true)
    private RepositoryPortType repositoryService;
    @Autowired(required=true)
    private ProvisioningPortType provisioningService;
    @Autowired(required=true)
    private ResourceObjectChangeListenerPortType resourceObjectChangeService;

    public PasswordChangeResponseType selfChangePassword(SelfPasswordChangeRequestType spcrt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasswordChangeResponseType changePassword(PasswordChangeRequestType pcrt) {
        PropertyModificationType passwordChange = this.createPasswordModification(pcrt.getNewPassword());
        PasswordChangeResponseType result = new PasswordChangeResponseType();
        if (null != passwordChange) {
            this.validatePolicy(pcrt.getUser(), pcrt.getNewPassword());
            for (TargetAccountType accountref : pcrt.getTarget()) {
                ObjectModificationType objectChange = new ObjectModificationType();
                objectChange.setOid(accountref.getOid());
                objectChange.getPropertyModification().add(passwordChange);
                OperationalResultType operationalResult = new OperationalResultType();
                Holder holder = new Holder((Object)operationalResult);
                ScriptsType scripts = new ScriptsType();
                try {
                    this.provisioningService.modifyObject(objectChange, scripts, holder);
                }
                catch (FaultMessage ex) {
                    logger.error("Failed change password: " + accountref.getOid(), (Throwable)ex);
                }
                result.getOperationalResult().add(operationalResult);
            }
        }
        return result;
    }

    public void synchronizePassword(PasswordSynchronizeRequestType body) {
        if (logger.isDebugEnabled()) {
            try {
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                ObjectFactory of = new ObjectFactory();
                Marshaller m = ctx.createMarshaller();
                m.setProperty("jaxb.encoding", (Object)"UTF-8");
                m.setProperty("jaxb.formatted.output", (Object)true);
                m.marshal((Object)of.createPasswordSynchronizeRequest(body), (OutputStream)System.out);
            }
            catch (JAXBException ex) {
                logger.debug("Debug exception", (Throwable)ex);
            }
        }
        String userName = null;
        for (Element e : body.getIdentifier().getAny()) {
            if (!"resourceAccountName".equals(e.getLocalName())) continue;
            userName = e.getTextContent();
            break;
        }
        if (null != userName && null != body.getSubject()) {
            try {
                ResourceObjectShadowType account = this.getCurrentShadow(body.getSubject().getOid(), userName);
                if (null != account) {
                    ObjectContainerType container = this.repositoryService.getObject(body.getSubject().getOid(), new PropertyReferenceListType());
                    ResourceObjectShadowChangeDescriptionType change = new ResourceObjectShadowChangeDescriptionType();
                    change.setResource((ResourceType)container.getObject());
                    change.setShadow(account);
                    change.setSourceChannel(QNameUtil.qNameToUri((QName)SchemaConstants.CHANGE_CHANNEL_SYNC));
                    ObjectChangeModificationType pwchange = new ObjectChangeModificationType();
                    ObjectModificationType mod = new ObjectModificationType();
                    mod.setOid(account.getOid());
                    PropertyModificationType passwordChange = this.createPasswordModification(body.getPassword());
                    mod.getPropertyModification().add(passwordChange);
                    pwchange.setObjectModification(mod);
                    change.setObjectChange((ObjectChangeType)pwchange);
                    this.resourceObjectChangeService.notifyChange(change);
                }
            }
            catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
                logger.error("Failed to synchronize password", (Throwable)ex);
            }
            catch (com.evolveum.midpoint.xml.ns._public.provisioning.resource_object_change_listener_1.FaultMessage ex) {
                logger.error("Failed to synchronize password", (Throwable)ex);
            }
            catch (FaultMessage ex) {
                logger.error("Failed to synchronize password", (Throwable)ex);
            }
        }
    }

    private boolean validatePolicy(ObjectReferenceType userRef, Element newPassword) {
        return true;
    }

    private PropertyModificationType createPasswordModification(Element newPassword) {
        if (null == newPassword) {
            return null;
        }
        PropertyModificationType modification = null;
        try {
            Document doc = this.getXmlDocument();
            modification = new PropertyModificationType();
            modification.setModificationType(PropertyModificationTypeType.replace);
            ArrayList<XPathSegment> segments = new ArrayList<XPathSegment>();
            segments.add(new XPathSegment(SchemaConstants.I_CREDENTIALS));
            XPathType xpath = new XPathType(segments);
            modification.setPath(xpath.toElement("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "path", doc));
            Element e = doc.createElementNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "password");
            Element hash = doc.createElementNS("http://midpoint.evolveum.com/xml/ns/public/common/common-1.xsd", "c:base64");
            hash.setTextContent(Base64.encodeBase64String((byte[])newPassword.getTextContent().getBytes()));
            e.appendChild(hash);
            modification.setValue(new PropertyModificationType.Value());
            modification.getValue().getAny().add(e);
        }
        catch (ParserConfigurationException ex) {
            logger.error("getXmlDocument", (Throwable)ex);
        }
        return modification;
    }

    protected Document getXmlDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder loader = factory.newDocumentBuilder();
        return loader.newDocument();
    }

    private ResourceObjectShadowType getCurrentShadow(String resourceOID, String userName) throws FaultMessage {
        QueryType query = this.createSearchQuery(userName);
        PagingType paging = new PagingType();
        ObjectListType results = null;
        try {
            results = this.repositoryService.searchObjects(query, paging);
            if (results.getObject().size() == 1 && results.getObject().get(0) instanceof UserType) {
                UserType user = (UserType)results.getObject().get(0);
                for (ObjectReferenceType ref : user.getAccountRef()) {
                    ObjectContainerType container = this.repositoryService.getObject(ref.getOid(), new PropertyReferenceListType());
                    ResourceObjectShadowType account = (ResourceObjectShadowType)container.getObject();
                    if (!account.getResourceRef().getOid().equals(resourceOID)) continue;
                    return account;
                }
            }
            if (results.getObject().size() == 0) {
                // empty if block
            }
            if (results.getObject().size() > 1) {
                throw new IllegalStateException("More than one user found for " + userName);
            }
        }
        catch (com.evolveum.midpoint.xml.ns._public.repository.repository_1.FaultMessage ex) {
            throw new FaultMessage(ex.getMessage(), ex.getFaultInfo(), (Throwable)ex);
        }
        return null;
    }

    protected QueryType createSearchQuery(String userName) {
        XPathSegment xpathSegment = new XPathSegment(SchemaConstants.C_NAME);
        ArrayList<XPathSegment> xpathSegments = new ArrayList<XPathSegment>();
        xpathSegments.add(xpathSegment);
        XPathType xpath = new XPathType(xpathSegments);
        Document doc = ShadowUtil.getXmlDocument();
        Element idElement = doc.createElementNS(SchemaConstants.C_NAME.getNamespaceURI(), SchemaConstants.C_NAME.getLocalPart());
        idElement.setTextContent(userName);
        Element filter = QueryUtil.createAndFilter((Document)doc, (Element)QueryUtil.createTypeFilter((Document)doc, (String)QNameUtil.qNameToUri((QName)SchemaConstants.I_USER_TYPE)), (Element)QueryUtil.createEqualFilter((Document)doc, (XPathType)xpath, (Element)idElement));
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }
}

