/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.provisioning.synchronization.SynchronizationProcessManager;
import com.evolveum.midpoint.xml.ns._public.common.common_1.CycleListType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.CycleType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.EmptyType;
import com.evolveum.midpoint.xml.ns._public.common.common_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.model.cycle_management_1.CycleManagementPortType;
import com.evolveum.midpoint.xml.ns._public.model.cycle_management_1.FaultMessage;
import javax.xml.ws.Holder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CycleManagementService
implements CycleManagementPortType {
    public static final String SYNCHRONIZATIONCYCLE = "SynchronizationCycle";
    @Autowired(required=true)
    SynchronizationProcessManager synchronizationProcessManager;
    ObjectFactory objectFactory = new ObjectFactory();

    public CycleListType listCycles(EmptyType empty) throws FaultMessage {
        CycleListType cycles = this.objectFactory.createCycleListType();
        CycleType cycle = this.objectFactory.createCycleType();
        cycle.setDisplayName("Synchronization Cycle");
        cycle.setName(SYNCHRONIZATIONCYCLE);
        cycles.getCycle().add(cycle);
        return cycles;
    }

    public EmptyType startCycle(String name) throws FaultMessage {
        if (SYNCHRONIZATIONCYCLE.equals(name)) {
            this.synchronizationProcessManager.init();
            return this.objectFactory.createEmptyType();
        }
        throw new IllegalArgumentException("Unknown cycle name " + name);
    }

    public EmptyType stopCycle(String name) throws FaultMessage {
        if (SYNCHRONIZATIONCYCLE.equals(name)) {
            this.synchronizationProcessManager.shutdown();
            return this.objectFactory.createEmptyType();
        }
        throw new IllegalArgumentException("Unknown cycle name " + name);
    }

    public void init(Holder<EmptyType> empty) throws FaultMessage {
        this.synchronizationProcessManager.init();
    }

    public void shutdown(Holder<EmptyType> empty) throws FaultMessage {
        this.synchronizationProcessManager.shutdown();
    }
}

